/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public class PackageDeclaration
extends ASTNode {
    private Name packageName = null;

    PackageDeclaration(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 35;
    }

    ASTNode clone(AST target) {
        PackageDeclaration result = new PackageDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public Name getName() {
        if (this.packageName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.packageName;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.packageName, name, false);
        this.packageName = name;
    }

    public IPackageBinding resolveBinding() {
        return this.getAST().getBindingResolver().resolvePackage(this);
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize() + (this.packageName == null ? 0 : this.getName().treeSize());
    }
}

