/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class AliasManager
implements IManager,
ILifecycleListener {
    protected final LocationMap locationsMap = new LocationMap();
    protected final Set aliasedProjects = new HashSet();
    private final Set structureChanges = new HashSet();
    private int linkedResourceCount = 0;
    protected final HashSet aliases = new HashSet();
    private final FindAliasesDoit findAliases = new FindAliasesDoit();
    private final AddToCollectionDoit addToCollection = new AddToCollectionDoit();
    public IPath suffix;
    protected final Workspace workspace;

    public AliasManager(Workspace workspace) {
        this.workspace = workspace;
    }

    private void addToLocationsMap(IProject project) {
        IPath location = project.getLocation();
        if (location != null) {
            this.locationsMap.add(location, project);
        }
        try {
            IResource[] members = project.members();
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (members[i].isLinked()) {
                        this.addToLocationsMap(members[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void addToLocationsMap(IResource linkedResource) {
        IPath location = linkedResource.getLocation();
        if (location != null && this.locationsMap.add(location, linkedResource)) {
            ++this.linkedResourceCount;
        }
    }

    private void buildAliasedProjectsSet() {
        this.aliasedProjects.clear();
        if (this.linkedResourceCount <= 0) {
            return;
        }
        this.addToCollection.setCollection(this.aliasedProjects);
        this.locationsMap.overLappingResourcesDo(this.addToCollection);
    }

    private void buildLocationsMap() {
        this.locationsMap.clear();
        this.linkedResourceCount = 0;
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            this.addToLocationsMap(projects[i]);
            ++i;
        }
    }

    public IResource[] computeAliases(IResource resource, IPath location) {
        if (this.hasNoAliases(resource)) {
            return null;
        }
        this.aliases.clear();
        this.internalComputeAliases(resource, location);
        int size = this.aliases.size();
        if (size == 0) {
            return null;
        }
        return this.aliases.toArray(new IResource[size]);
    }

    private void internalComputeAliases(IResource resource, IPath location) {
        IPath searchLocation;
        IPath iPath = searchLocation = location == null ? resource.getLocation() : location;
        if (searchLocation == null) {
            return;
        }
        this.suffix = Path.EMPTY;
        int segmentCount = searchLocation.segmentCount();
        this.findAliases.setSearchAlias(resource);
        while (true) {
            this.locationsMap.matchingResourcesDo(searchLocation, this.findAliases);
            if (--segmentCount <= 0) break;
            this.suffix = new Path(searchLocation.lastSegment()).append(this.suffix);
            searchLocation = searchLocation.removeLastSegments(1);
        }
    }

    private boolean hasNoAliases(IResource resource) {
        boolean noAliases;
        IProject project = resource.getProject();
        boolean bl = noAliases = this.linkedResourceCount <= 0 || !this.aliasedProjects.contains(project);
        if (!this.structureChanges.isEmpty()) {
            this.updateStructureChanges();
            noAliases &= this.linkedResourceCount <= 0 || !this.aliasedProjects.contains(project);
        }
        return noAliases;
    }

    private void computeDeepAliases(IResource resource, IPath location) {
        if (location == null) {
            return;
        }
        this.internalComputeAliases(resource, location);
        this.addToCollection.setCollection(this.aliases);
        this.locationsMap.matchingPrefixDo(location, this.addToCollection);
        if (resource.getType() == 4) {
            try {
                IResource[] members = ((IProject)resource).members();
                int i = 0;
                while (i < members.length) {
                    IPath linkLocation;
                    if (members[i].isLinked() && (linkLocation = members[i].getLocation()) != null) {
                        this.locationsMap.matchingPrefixDo(linkLocation, this.addToCollection);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                IPath path1 = (IPath)o1;
                IPath path2 = (IPath)o2;
                int segmentCount1 = path1.segmentCount();
                int segmentCount2 = path2.segmentCount();
                int i = 0;
                while (i < segmentCount1 && i < segmentCount2) {
                    String segment2;
                    String segment1 = path1.segment(i);
                    int compare = segment1.compareTo(segment2 = path2.segment(i));
                    if (compare != 0) {
                        return compare;
                    }
                    ++i;
                }
                return segmentCount1 - segmentCount2;
            }
        };
    }

    public void handleEvent(LifecycleEvent event) throws CoreException {
        switch (event.kind) {
            case 1: 
            case 16: {
                this.removeFromLocationsMap((IProject)event.resource);
            }
            case 8: 
            case 32: {
                this.structureChanges.add(event.resource);
                break;
            }
            case 1024: {
                this.removeFromLocationsMap(event.resource);
            }
            case 512: {
                this.structureChanges.add(event.resource);
                break;
            }
            case 4: 
            case 256: {
                this.structureChanges.add(event.newResource);
                break;
            }
            case 64: {
                this.removeFromLocationsMap((IProject)event.resource);
                this.structureChanges.add(event.newResource);
                break;
            }
            case 2048: {
                this.removeFromLocationsMap(event.resource);
                this.structureChanges.add(event.newResource);
            }
        }
    }

    private void removeFromLocationsMap(IProject project) {
        IPath location = project.getLocation();
        if (location != null) {
            this.locationsMap.remove(location, project);
        }
        try {
            IResource[] children = project.members();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (children[i].isLinked()) {
                        this.removeFromLocationsMap(children[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void removeFromLocationsMap(IResource linkedResource) {
        IPath location = linkedResource.getLocation();
        if (location != null && this.locationsMap.remove(location, linkedResource)) {
            --this.linkedResourceCount;
        }
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.workspace.addLifecycleListener(this);
        this.buildLocationsMap();
        this.buildAliasedProjectsSet();
    }

    public void updateAliases(IResource resource, IPath location, int depth, IProgressMonitor monitor) throws CoreException {
        if (this.hasNoAliases(resource)) {
            return;
        }
        this.aliases.clear();
        if (depth == 0) {
            this.internalComputeAliases(resource, location);
        } else {
            this.computeDeepAliases(resource, location);
        }
        if (this.aliases.size() == 0) {
            return;
        }
        FileSystemResourceManager localManager = this.workspace.getFileSystemManager();
        Iterator it = this.aliases.iterator();
        while (it.hasNext()) {
            IResource alias = (IResource)it.next();
            monitor.subTask(Policy.bind("links.updatingDuplicate", alias.getFullPath().toString()));
            localManager.refresh(alias, 2, false, null);
        }
    }

    private void updateStructureChanges() {
        boolean hadChanges = false;
        Iterator it = this.structureChanges.iterator();
        while (it.hasNext()) {
            IResource resource = (IResource)it.next();
            if (!resource.exists()) continue;
            hadChanges = true;
            if (resource.getType() == 4) {
                this.addToLocationsMap((IProject)resource);
                continue;
            }
            this.addToLocationsMap(resource);
        }
        this.structureChanges.clear();
        if (hadChanges) {
            this.buildAliasedProjectsSet();
        }
    }

    class LocationMap {
        private final SortedMap map;

        LocationMap() {
            this.map = new TreeMap(AliasManager.this.getComparator());
        }

        public boolean add(IPath location, IResource resource) {
            Object oldValue = this.map.get(location);
            if (oldValue == null) {
                this.map.put(location, resource);
                return true;
            }
            if (oldValue instanceof IResource) {
                if (resource.equals(oldValue)) {
                    return false;
                }
                ArrayList<Object> newValue = new ArrayList<Object>(2);
                newValue.add(oldValue);
                newValue.add(resource);
                this.map.put(location, newValue);
                return true;
            }
            ArrayList list = (ArrayList)oldValue;
            if (list.contains(resource)) {
                return false;
            }
            list.add(resource);
            return true;
        }

        public void clear() {
            this.map.clear();
        }

        public void matchingPrefixDo(IPath prefix, Doit doit) {
            SortedMap matching;
            if (prefix.segmentCount() > 0) {
                Path endPoint = new Path(String.valueOf(prefix.removeTrailingSeparator().toString()) + "\u0000");
                matching = this.map.subMap(prefix, endPoint);
            } else {
                matching = this.map;
            }
            Iterator it = matching.values().iterator();
            while (it.hasNext()) {
                Object value = it.next();
                if (value == null) {
                    return;
                }
                if (value instanceof List) {
                    Iterator duplicates = ((List)value).iterator();
                    while (duplicates.hasNext()) {
                        doit.doit((IResource)duplicates.next());
                    }
                    continue;
                }
                doit.doit((IResource)value);
            }
        }

        public void matchingResourcesDo(IPath location, Doit doit) {
            Object value = this.map.get(location);
            if (value == null) {
                return;
            }
            if (value instanceof List) {
                Iterator duplicates = ((List)value).iterator();
                while (duplicates.hasNext()) {
                    doit.doit((IResource)duplicates.next());
                }
            } else {
                doit.doit((IResource)value);
            }
        }

        public void overLappingResourcesDo(Doit doit) {
            Iterator entries = this.map.entrySet().iterator();
            IPath previousPath = null;
            IResource previousResource = null;
            while (entries.hasNext()) {
                Map.Entry current = entries.next();
                IPath currentPath = (IPath)current.getKey();
                IResource currentResource = null;
                Object value = current.getValue();
                if (value instanceof List) {
                    Iterator duplicates = ((List)value).iterator();
                    while (duplicates.hasNext()) {
                        doit.doit(((IResource)duplicates.next()).getProject());
                    }
                } else {
                    currentResource = (IResource)value;
                }
                if (previousPath != null && previousPath.isPrefixOf(currentPath)) {
                    if (previousResource != null) {
                        doit.doit(previousResource.getProject());
                    }
                    if (currentResource != null) {
                        doit.doit(currentResource.getProject());
                    }
                }
                previousPath = currentPath;
                previousResource = currentResource;
            }
        }

        public boolean remove(IPath location, IResource resource) {
            Object oldValue = this.map.get(location);
            if (oldValue == null) {
                return false;
            }
            if (oldValue instanceof IResource) {
                if (resource.equals(oldValue)) {
                    this.map.remove(location);
                    return true;
                }
                return false;
            }
            ArrayList list = (ArrayList)oldValue;
            boolean wasRemoved = list.remove(resource);
            if (list.size() == 0) {
                this.map.remove(location);
            }
            return wasRemoved;
        }
    }

    interface Doit {
        public void doit(IResource var1);
    }

    class FindAliasesDoit
    implements Doit {
        private IPath searchPath;
        private int aliasType;

        FindAliasesDoit() {
        }

        public void doit(IResource match) {
            if (match.getFullPath().isPrefixOf(this.searchPath)) {
                return;
            }
            IPath aliasPath = null;
            switch (match.getType()) {
                case 4: {
                    IResource testResource;
                    if (AliasManager.this.suffix.segmentCount() > 0 && (testResource = ((IProject)match).findMember(AliasManager.this.suffix.segment(0))) != null && testResource.isLinked()) {
                        return;
                    }
                    aliasPath = match.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 2: {
                    aliasPath = match.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 1: {
                    if (AliasManager.this.suffix.segmentCount() != 0) break;
                    aliasPath = match.getFullPath();
                }
            }
            if (aliasPath != null) {
                if (this.aliasType == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFile(aliasPath));
                } else if (aliasPath.segmentCount() == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getProject(aliasPath.lastSegment()));
                } else {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFolder(aliasPath));
                }
            }
        }

        public void setSearchAlias(IResource aliasResource) {
            this.aliasType = aliasResource.getType();
            this.searchPath = aliasResource.getFullPath();
        }
    }

    public class AddToCollectionDoit
    implements Doit {
        Collection collection;

        public void setCollection(Collection collection) {
            this.collection = collection;
        }

        public void doit(IResource resource) {
            this.collection.add(resource);
        }
    }
}

