/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class DeclareParents
extends Declare {
    private TypePattern child;
    private TypePatternList parents;

    public DeclareParents(TypePattern child, List parents) {
        this(child, new TypePatternList(parents));
    }

    private DeclareParents(TypePattern child, TypePatternList parents) {
        this.child = child;
        this.parents = parents;
    }

    public boolean match(ResolvedTypeX typeX) {
        if (!this.child.matchesStatically(typeX)) {
            return false;
        }
        if (typeX.getWorld().getLint().typeNotExposedToWeaver.isEnabled() && !typeX.isExposedToWeaver()) {
            typeX.getWorld().getLint().typeNotExposedToWeaver.signal(typeX.getName(), this.getSourceLocation());
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare parents: ");
        buf.append(this.child);
        buf.append(" extends ");
        buf.append(this.parents);
        buf.append(";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclareParents)) {
            return false;
        }
        DeclareParents o = (DeclareParents)other;
        return o.child.equals(this.child) && o.parents.equals(this.parents);
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.child.hashCode();
        result = 37 * result + this.parents.hashCode();
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(2);
        this.child.write(s);
        this.parents.write(s);
        this.writeLocation(s);
    }

    public static Declare read(DataInputStream s, ISourceContext context) throws IOException {
        DeclareParents ret = new DeclareParents(TypePattern.read(s, context), TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolve(IScope scope) {
        this.child = this.child.resolveBindings(scope, Bindings.NONE, false, false);
        this.parents = this.parents.resolveBindings(scope, Bindings.NONE, false, true);
    }

    public TypePatternList getParents() {
        return this.parents;
    }

    public TypePattern getChild() {
        return this.child;
    }

    public boolean isAdviceLike() {
        return false;
    }

    private ResolvedTypeX maybeGetNewParent(ResolvedTypeX targetType, TypePattern typePattern, World world) {
        if (typePattern == TypePattern.NO) {
            return null;
        }
        TypeX iType = typePattern.getExactType();
        ResolvedTypeX parentType = iType.resolve(world);
        if (targetType.equals(world.resolve(TypeX.OBJECT))) {
            world.showMessage(IMessage.ERROR, "can't change the parents of java.lang.Object", this.getSourceLocation(), null);
            return null;
        }
        if (parentType.isAssignableFrom(targetType)) {
            return null;
        }
        if (targetType.isAssignableFrom(parentType)) {
            world.showMessage(IMessage.ERROR, "type '" + targetType.getName() + "'can not extend itself", this.getSourceLocation(), null);
            return null;
        }
        if (parentType.isClass()) {
            if (targetType.isInterface()) {
                world.showMessage(IMessage.ERROR, "interface can not extend a class", this.getSourceLocation(), null);
                return null;
            }
            if (!targetType.getSuperclass().isAssignableFrom(parentType)) {
                world.showMessage(IMessage.ERROR, "can only insert a class into hierarchy, but " + iType.getName() + " is not a subtype of " + targetType.getSuperclass().getName(), this.getSourceLocation(), null);
                return null;
            }
            return parentType;
        }
        return parentType;
    }

    public List findMatchingNewParents(ResolvedTypeX onType) {
        if (!this.match(onType)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResolvedTypeX> ret = new ArrayList<ResolvedTypeX>();
        int i = 0;
        while (i < this.parents.size()) {
            ResolvedTypeX t = this.maybeGetNewParent(onType, this.parents.get(i), onType.getWorld());
            if (t != null) {
                ret.add(t);
            }
            ++i;
        }
        return ret;
    }
}

