/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.util.ArrayList;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex index) {
        this.index = index;
    }

    public void clearCache() {
    }

    public void close() {
        this.sortedFiles = null;
    }

    public IndexedFile getCurrentFile() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    public IndexedFile getIndexedFile(int fileNum) {
        int i = 0;
        while (i < this.sortedFiles.length) {
            if (this.sortedFiles[i].getFileNumber() == fileNum) {
                return this.sortedFiles[i];
            }
            ++i;
        }
        return null;
    }

    public IndexedFile getIndexedFile(SearchDocument document) {
        String name = document.getPath();
        int i = this.index.getNumFiles();
        while (i >= 1) {
            IndexedFile file = this.getIndexedFile(i);
            if (name.equals(file.getPath())) {
                return file;
            }
            --i;
        }
        return null;
    }

    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    public void moveToNextFile() {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    public void moveToNextWordEntry() {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    public void open() {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.setFirstFile();
        this.setFirstWord();
    }

    public String[] query(String word) {
        char[] wordChar = word.toCharArray();
        WordEntry wordEntry = this.index.getWordEntry(wordChar);
        int[] fileNums = wordEntry.getRefs();
        String[] paths = new String[fileNums.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = this.getIndexedFile(fileNums[i]).getPath();
            ++i;
        }
        return paths;
    }

    public EntryResult[] queryEntries(char[] pattern, int matchRule) {
        return null;
    }

    public EntryResult[] queryEntriesPrefixedBy(char[] prefix) {
        return null;
    }

    public String[] queryFilesReferringToPrefix(char[] prefix) {
        return null;
    }

    public String[] queryInDocumentNames(String word) {
        this.setFirstFile();
        ArrayList<String> matches = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        String[] match = new String[matches.size()];
        matches.toArray(match);
        return match;
    }

    protected void setFirstFile() {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    protected void setFirstWord() {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }
}

