/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;

public class OrPattern
extends SearchPattern {
    protected SearchPattern[] patterns;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(256, Math.max(leftPattern.matchRule, rightPattern.matchRule));
        this.mustResolve = leftPattern.mustResolve || rightPattern.mustResolve;
        SearchPattern[] leftPatterns = leftPattern instanceof OrPattern ? ((OrPattern)leftPattern).patterns : null;
        SearchPattern[] rightPatterns = rightPattern instanceof OrPattern ? ((OrPattern)rightPattern).patterns : null;
        int leftSize = leftPatterns == null ? 1 : leftPatterns.length;
        int rightSize = rightPatterns == null ? 1 : rightPatterns.length;
        this.patterns = new SearchPattern[leftSize + rightSize];
        if (leftPatterns == null) {
            this.patterns[0] = leftPattern;
        } else {
            System.arraycopy(leftPatterns, 0, this.patterns, 0, leftSize);
        }
        if (rightPatterns == null) {
            this.patterns[leftSize] = rightPattern;
        } else {
            System.arraycopy(rightPatterns, 0, this.patterns, leftSize, rightSize);
        }
    }

    public void decodeIndexKey(char[] key) {
    }

    public char[] encodeIndexKey() {
        return null;
    }

    public void findIndexMatches(IndexInput input, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        int i = 0;
        int length = this.patterns.length;
        while (i < length) {
            this.patterns[i].findIndexMatches(input, requestor, participant, scope, progressMonitor);
            ++i;
        }
    }

    public SearchPattern getIndexRecord() {
        return null;
    }

    public boolean isMatchingIndexRecord() {
        return false;
    }

    public boolean isPolymorphicSearch() {
        int i = 0;
        int length = this.patterns.length;
        while (i < length) {
            if (this.patterns[i].isPolymorphicSearch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public char[][] getMatchCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.patterns[0].toString());
        int i = 1;
        int length = this.patterns.length;
        while (i < length) {
            buffer.append("\n| ");
            buffer.append(this.patterns[i].toString());
            ++i;
        }
        return buffer.toString();
    }
}

