/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.jdbc2.optional.MysqlPooledConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MysqlXAConnection
extends MysqlPooledConnection
implements XAConnection,
XAResource {
    private Connection underlyingConnection;

    public MysqlXAConnection(Connection connection) {
        super(connection);
        this.underlyingConnection = connection;
    }

    public XAResource getXAResource() throws SQLException {
        return this;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int flag) throws XAException {
        switch (flag) {
            case 0: 
            case 0x800000: 
            case 0x1000000: {
                ResultSet rs = null;
                try {
                    try {
                        rs = this.dispatchCommand("XA RECOVER");
                        if (rs != null) {
                            while (rs.next()) {
                                String gtridBtrid = rs.getString(1);
                            }
                        }
                        Object var5_5 = null;
                        if (rs == null) return new Xid[0];
                    }
                    catch (SQLException sqlEx) {
                        throw MysqlXAConnection.mapXAExceptionFromSQLException(sqlEx);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (rs == null) throw throwable;
                    try {
                        rs.close();
                        throw throwable;
                    }
                    catch (SQLException sqlEx) {
                        throw MysqlXAConnection.mapXAExceptionFromSQLException(sqlEx);
                    }
                }
                try {}
                catch (SQLException sqlEx) {
                    throw MysqlXAConnection.mapXAExceptionFromSQLException(sqlEx);
                }
                rs.close();
                return new Xid[0];
            }
        }
        throw new XAException(-5);
    }

    public int prepare(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA PREPARE ");
        commandBuf.append(MysqlXAConnection.xidToString(xid));
        this.dispatchCommand(commandBuf.toString());
        return 0;
    }

    public void forget(Xid xid) throws XAException {
    }

    public void rollback(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA ROLLBACK ");
        commandBuf.append(MysqlXAConnection.xidToString(xid));
        this.dispatchCommand(commandBuf.toString());
    }

    public void end(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA END ");
        commandBuf.append(MysqlXAConnection.xidToString(xid));
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x2000000: {
                commandBuf.append(" SUSPEND");
                break;
            }
            case 0x20000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
    }

    public void start(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA START TRANSACTION ");
        commandBuf.append(MysqlXAConnection.xidToString(xid));
        switch (flags) {
            case 0x200000: {
                commandBuf.append(" JOIN");
                break;
            }
            case 0x8000000: {
                commandBuf.append(" RESUME");
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA COMMIT ");
        commandBuf.append(MysqlXAConnection.xidToString(xid));
        if (onePhase) {
            commandBuf.append(" ONE PHASE");
        }
        this.dispatchCommand(commandBuf.toString());
    }

    private ResultSet dispatchCommand(String command) throws XAException {
        try {
            Statement stmt = this.underlyingConnection.createStatement();
            System.out.println(this + " -> dispatching command: " + command);
            return null;
        }
        catch (SQLException sqlEx) {
            throw MysqlXAConnection.mapXAExceptionFromSQLException(sqlEx);
        }
    }

    private static XAException mapXAExceptionFromSQLException(SQLException sqlEx) {
        return new XAException(sqlEx.getErrorCode());
    }

    private static String xidToString(Xid xid) {
        String asHex;
        int i;
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] btrid = xid.getBranchQualifier();
        int lengthAsString = 1;
        if (gtrid != null) {
            lengthAsString += 2 * gtrid.length;
        }
        if (btrid != null) {
            lengthAsString += 2 * btrid.length;
        }
        StringBuffer asString = new StringBuffer(lengthAsString);
        if (gtrid != null) {
            for (i = 0; i < gtrid.length; ++i) {
                asHex = Integer.toHexString(gtrid[i] & 0xFF);
                if (asHex.length() == 1) {
                    asString.append("0");
                }
                asString.append(asHex);
            }
        }
        if (btrid != null) {
            asString.append(".");
            for (i = 0; i < btrid.length; ++i) {
                asHex = Integer.toHexString(btrid[i] & 0xFF);
                if (asHex.length() == 1) {
                    asString.append("0");
                }
                asString.append(asHex);
            }
        }
        return asString.toString();
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection connToWrap = super.getConnection();
        return connToWrap;
    }
}

