/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class TypeDeclarationPattern
extends SearchPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new TypeDeclarationPattern(null, null, null, ' ', 4);
        }
    };
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char classOrInterface;

    public static char[] createIndexKey(char[] packageName, char[][] enclosingTypeNames, char[] typeName, boolean isClass) {
        TypeDeclarationPattern record = TypeDeclarationPattern.getTypeDeclarationRecord();
        record.pkg = packageName;
        record.enclosingTypeNames = enclosingTypeNames;
        record.simpleName = typeName;
        record.classOrInterface = (char)(isClass ? 67 : 73);
        return record.encodeIndexKey();
    }

    public static TypeDeclarationPattern getTypeDeclarationRecord() {
        return (TypeDeclarationPattern)indexRecord.get();
    }

    public TypeDeclarationPattern(int matchRule) {
        super(8, matchRule);
    }

    public TypeDeclarationPattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, char classOrInterface, int matchRule) {
        super(8, matchRule);
        boolean isCaseSensitive = this.isCaseSensitive();
        char[] cArray = this.pkg = isCaseSensitive ? pkg : CharOperation.toLowerCase(pkg);
        if (isCaseSensitive || enclosingTypeNames == null) {
            this.enclosingTypeNames = enclosingTypeNames;
        } else {
            int length = enclosingTypeNames.length;
            this.enclosingTypeNames = new char[length][];
            int i = 0;
            while (i < length) {
                this.enclosingTypeNames[i] = CharOperation.toLowerCase(enclosingTypeNames[i]);
                ++i;
            }
        }
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.mustResolve = pkg != null && enclosingTypeNames != null;
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        this.classOrInterface = key[0];
        int oldSlash = 1;
        int slash = CharOperation.indexOf('/', key, oldSlash + 1);
        this.pkg = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray(key, oldSlash + 1, slash);
        int n = slash + 1;
        slash = CharOperation.indexOf('/', key, slash + 1);
        this.simpleName = CharOperation.subarray(key, n, slash);
        this.enclosingTypeNames = slash + 1 < size ? (slash + 3 == size && key[slash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO_CHAR : CharOperation.splitOn('/', CharOperation.subarray(key, slash + 1, size - 1))) : CharOperation.NO_CHAR_CHAR;
    }

    public char[] encodeIndexKey() {
        char[] typeName;
        char[] packageName = this.isCaseSensitive() ? this.pkg : null;
        switch (this.classOrInterface) {
            case 'C': {
                if (packageName != null) break;
                return new char[]{'C', '/'};
            }
            case 'I': {
                if (packageName != null) break;
                return new char[]{'I', '/'};
            }
            default: {
                return CharOperation.NO_CHAR;
            }
        }
        char[] cArray = typeName = this.isCaseSensitive() ? this.simpleName : null;
        if (typeName != null && this.matchMode() == 2) {
            int starPos = CharOperation.indexOf('*', typeName);
            switch (starPos) {
                case -1: {
                    break;
                }
                case 0: {
                    typeName = null;
                    break;
                }
                default: {
                    typeName = CharOperation.subarray(typeName, 0, starPos);
                }
            }
        }
        int packageLength = packageName.length;
        int enclosingTypeNamesLength = 0;
        if (this.enclosingTypeNames != null) {
            int i = 0;
            int length = this.enclosingTypeNames.length;
            while (i < length) {
                enclosingTypeNamesLength += this.enclosingTypeNames[i].length + 1;
                ++i;
            }
        }
        int pos = 0;
        int typeNameLength = typeName == null ? 0 : typeName.length;
        int resultLength = pos + packageLength + typeNameLength + enclosingTypeNamesLength + 4;
        char[] result = new char[resultLength];
        result[pos++] = this.classOrInterface;
        result[pos++] = 47;
        if (packageLength > 0) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 47;
        if (typeName != null) {
            System.arraycopy(typeName, 0, result, pos, typeNameLength);
            pos += typeNameLength;
            result[pos++] = 47;
            if (this.enclosingTypeNames != null) {
                int i = 0;
                int length = this.enclosingTypeNames.length;
                while (i < length) {
                    int enclosingTypeNameLength = this.enclosingTypeNames[i].length;
                    System.arraycopy(this.enclosingTypeNames[i], 0, result, pos, enclosingTypeNameLength);
                    pos += enclosingTypeNameLength;
                    result[pos++] = 47;
                    ++i;
                }
            }
        }
        if (pos != resultLength) {
            char[] cArray2 = result;
            result = new char[pos];
            System.arraycopy(cArray2, 0, result, 0, pos);
        }
        return result;
    }

    public SearchPattern getIndexRecord() {
        return TypeDeclarationPattern.getTypeDeclarationRecord();
    }

    public char[][] getMatchCategories() {
        return new char[][]{IIndexConstants.TYPE_DECL};
    }

    public boolean isMatchingIndexRecord() {
        TypeDeclarationPattern record = TypeDeclarationPattern.getTypeDeclarationRecord();
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == record.classOrInterface) break;
                return false;
            }
        }
        if (this.pkg != null && !CharOperation.equals(this.pkg, record.pkg, this.isCaseSensitive())) {
            return false;
        }
        if (this.enclosingTypeNames != null && (this.enclosingTypeNames.length == 0 ? record.enclosingTypeNames != CharOperation.NO_CHAR_CHAR : !CharOperation.equals(this.enclosingTypeNames, record.enclosingTypeNames, this.isCaseSensitive()) && !CharOperation.equals(record.enclosingTypeNames, IIndexConstants.ONE_ZERO_CHAR))) {
            return false;
        }
        return this.matchesName(this.simpleName, record.simpleName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: pkg<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: pkg<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: pkg<");
            }
        }
        if (this.pkg != null) {
            buffer.append(this.pkg);
        } else {
            buffer.append("*");
        }
        buffer.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int i = 0;
            while (i < this.enclosingTypeNames.length) {
                buffer.append(this.enclosingTypeNames[i]);
                if (i < this.enclosingTypeNames.length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

