/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    protected DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());

    public SourceIndexer(SearchDocument document, String indexPath) {
        super(document, indexPath);
    }

    public void indexDocument() {
        block5: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            Path path = new Path(documentPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            SourceElementParser parser = new SourceElementParser(requestor, this.problemFactory, new CompilerOptions(JavaCore.create(project).getOptions(true)), true);
            parser.javadocParser.checkJavadoc = true;
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null || name == null) {
                return;
            }
            CompilationUnit compilationUnit = new CompilationUnit(source, name);
            try {
                parser.parseCompilationUnit(compilationUnit, true);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block5;
                e.printStackTrace();
            }
        }
    }
}

