/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static INameEnvironment getNameEnvironment(ICompilationUnit sourceUnit) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)sourceUnit.getJavaProject()).getSearchableNameEnvironment();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, ICompilationUnit unitElement, Parser parser, IProblemRequestor problemRequestor, IProblemFactory problemFactory, IProgressMonitor monitor) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        IJavaProject project = unitElement.getJavaProject();
        CompilationUnitProblemFinder problemFinder = new CompilationUnitProblemFinder(CompilationUnitProblemFinder.getNameEnvironment(unitElement), CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), problemFactory);
        if (parser != null) {
            problemFinder.parser = parser;
        }
        try {
            CompilationUnitDeclaration compilationUnitDeclaration;
            block9: {
                try {
                    String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
                    IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
                    char[][] expectedPackageName = null;
                    if (packageFragment != null) {
                        expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
                    }
                    if (unit == null) {
                        unit = problemFinder.resolve(new BasicCompilationUnit(unitElement.getSource().toCharArray(), expectedPackageName, new String(fileName), encoding), true, true, true);
                    } else {
                        problemFinder.resolve(unit, null, true, true, true);
                    }
                    CompilationUnitProblemFinder.reportProblems(unit, problemRequestor, monitor);
                    compilationUnitDeclaration = unit;
                    Object var12_14 = null;
                    if (unit == null) break block9;
                }
                catch (RuntimeException e) {
                    Util.log(e, "Exception occurred during problem detection: ");
                    throw new JavaModelException(e, 1005);
                }
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, null, problemRequestor, new DefaultProblemFactory(), monitor);
    }

    private static void reportProblems(CompilationUnitDeclaration unit, IProblemRequestor problemRequestor, IProgressMonitor monitor) {
        CompilationResult unitResult = unit.compilationResult;
        IProblem[] problems = unitResult.getAllProblems();
        int i = 0;
        int problemLength = problems == null ? 0 : problems.length;
        while (i < problemLength) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("PROBLEM FOUND while reconciling : " + problems[i].getMessage());
            }
            if (monitor != null && monitor.isCanceled()) break;
            problemRequestor.acceptProblem(problems[i]);
            ++i;
        }
    }
}

