/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, String encoding) {
        int end;
        this.contents = contents;
        this.fileName = fileName.toCharArray();
        this.packageName = packageName;
        int start = fileName.lastIndexOf("/") + 1;
        if (start == 0 || start < fileName.lastIndexOf("\\")) {
            start = fileName.lastIndexOf("\\") + 1;
        }
        if ((end = fileName.lastIndexOf(".")) == -1) {
            end = fileName.length();
        }
        this.mainTypeName = fileName.substring(start, end).toCharArray();
        this.encoding = encoding;
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "CompilationUnit: " + new String(this.fileName);
    }
}

