/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class MethodPattern
extends SearchPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new MethodPattern(false, false, null, null, null, null, null, null, null, null, 4);
        }
    };
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] selector;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[] returnQualification;
    public char[] returnSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    protected IType declaringType;

    public static char[] createIndexKey(char[] selector, int argCount) {
        MethodPattern record = MethodPattern.getMethodRecord();
        record.selector = selector;
        record.parameterCount = argCount;
        return record.encodeIndexKey();
    }

    public static MethodPattern getMethodRecord() {
        return (MethodPattern)indexRecord.get();
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, char[] returnQualification, char[] returnSimpleName, char[][] parameterQualifications, char[][] parameterSimpleNames, IType declaringType, int matchRule) {
        super(128, matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        boolean isCaseSensitive = this.isCaseSensitive();
        this.selector = isCaseSensitive ? selector : CharOperation.toLowerCase(selector);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.returnQualification = isCaseSensitive ? returnQualification : CharOperation.toLowerCase(returnQualification);
        char[] cArray = this.returnSimpleName = isCaseSensitive ? returnSimpleName : CharOperation.toLowerCase(returnSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterCount = parameterSimpleNames.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterQualifications[i] = isCaseSensitive ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = isCaseSensitive ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.declaringType = declaringType;
        this.mustResolve = this.mustResolve();
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', key);
        this.parameterCount = Integer.parseInt(new String(key, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.selector = CharOperation.subarray(key, 0, lastSeparatorIndex);
    }

    public char[] encodeIndexKey() {
        if (this.isCaseSensitive() && this.selector != null) {
            switch (this.matchMode()) {
                case 0: {
                    int arity = this.parameterCount;
                    if (arity >= 0) {
                        char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : ("/" + String.valueOf(arity)).toCharArray();
                        return CharOperation.concat(this.selector, countChars);
                    }
                }
                case 1: {
                    return this.selector;
                }
                case 2: {
                    int starPos = CharOperation.indexOf('*', this.selector);
                    switch (starPos) {
                        case -1: {
                            return this.selector;
                        }
                        default: {
                            char[] result = new char[starPos];
                            System.arraycopy(this.selector, 0, result, 0, starPos);
                            return result;
                        }
                        case 0: 
                    }
                }
            }
        }
        return CharOperation.NO_CHAR;
    }

    public SearchPattern getIndexRecord() {
        return MethodPattern.getMethodRecord();
    }

    public char[][] getMatchCategories() {
        if (this.findReferences) {
            if (this.findDeclarations) {
                return new char[][]{IIndexConstants.METHOD_REF, IIndexConstants.METHOD_DECL};
            }
            return new char[][]{IIndexConstants.METHOD_REF};
        }
        if (this.findDeclarations) {
            return new char[][]{IIndexConstants.METHOD_DECL};
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    public boolean isMatchingIndexRecord() {
        MethodPattern record = MethodPattern.getMethodRecord();
        if (this.parameterCount != -1 && this.parameterCount != record.parameterCount) {
            return false;
        }
        return this.matchesName(this.selector, record.selector);
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.returnSimpleName != null || this.returnQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (this.parameterQualifications[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            buffer.append("MethodReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.selector != null) {
            buffer.append(this.selector);
        } else {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnQualification != null) {
            buffer.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            buffer.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

