/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class FieldPattern
extends VariablePattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new FieldPattern(false, false, false, null, null, null, null, null, 4);
        }
    };
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] typeQualification;
    protected char[] typeSimpleName;
    protected static char[][] REF_CATEGORIES = new char[][]{IIndexConstants.FIELD_REF, IIndexConstants.REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{IIndexConstants.FIELD_REF, IIndexConstants.REF, IIndexConstants.FIELD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{IIndexConstants.FIELD_DECL};

    public static char[] createIndexKey(char[] fieldName) {
        FieldPattern record = FieldPattern.getFieldRecord();
        record.name = fieldName;
        return record.encodeIndexKey();
    }

    public static FieldPattern getFieldRecord() {
        return (FieldPattern)indexRecord.get();
    }

    public FieldPattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, char[] name, char[] declaringQualification, char[] declaringSimpleName, char[] typeQualification, char[] typeSimpleName, int matchRule) {
        super(64, findDeclarations, readAccess, writeAccess, name, matchRule);
        boolean isCaseSensitive = this.isCaseSensitive();
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.typeQualification = isCaseSensitive ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = isCaseSensitive ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.mustResolve = this.mustResolve();
    }

    public void decodeIndexKey(char[] key) {
        this.name = key;
    }

    public char[] encodeIndexKey() {
        return this.encodeIndexKey(this.name);
    }

    public SearchPattern getIndexRecord() {
        return FieldPattern.getFieldRecord();
    }

    public char[][] getMatchCategories() {
        return this.findReferences ? (this.findDeclarations || this.writeAccess ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES) : DECL_CATEGORIES;
    }

    public boolean isMatchingIndexRecord() {
        return this.matchesName(this.name, FieldPattern.getFieldRecord().name);
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.typeSimpleName != null || this.typeQualification != null) {
            return true;
        }
        return super.mustResolve();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "FieldCombinedPattern: " : "FieldDeclarationPattern: ");
        } else {
            buffer.append("FieldReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.name == null) {
            buffer.append("*");
        } else {
            buffer.append(this.name);
        }
        if (this.typeQualification != null) {
            buffer.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            buffer.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

