/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class Name
extends Expression {
    static final int BASE_NAME_NODE_SIZE = 44;
    int index;

    Name(AST ast) {
        super(ast);
    }

    public final boolean isSimpleName() {
        return this instanceof SimpleName;
    }

    public final boolean isQualifiedName() {
        return this instanceof QualifiedName;
    }

    public final IBinding resolveBinding() {
        return this.getAST().getBindingResolver().resolveName(this);
    }

    BlockScope lookupScope() {
        ASTNode currentNode = this;
        while (!(currentNode == null || currentNode instanceof MethodDeclaration || currentNode instanceof Initializer || currentNode instanceof FieldDeclaration)) {
            currentNode = currentNode.getParent();
        }
        if (currentNode == null) {
            return null;
        }
        if (currentNode instanceof Initializer) {
            Initializer initializer = (Initializer)currentNode;
            while (!(currentNode instanceof TypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.getAST().getBindingResolver().getCorrespondingNode(currentNode);
            if ((initializer.getModifiers() & 8) != 0) {
                return typeDecl.staticInitializerScope;
            }
            return typeDecl.initializerScope;
        }
        if (currentNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)currentNode;
            while (!(currentNode instanceof TypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.getAST().getBindingResolver().getCorrespondingNode(currentNode);
            if ((fieldDeclaration.getModifiers() & 8) != 0) {
                return typeDecl.staticInitializerScope;
            }
            return typeDecl.initializerScope;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.getAST().getBindingResolver().getCorrespondingNode(currentNode);
        return abstractMethodDeclaration.scope;
    }
}

