/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.impl.JndiRefDataSourceBase;
import com.mchange.v2.sql.SqlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;

final class JndiRefForwardingDataSource
extends JndiRefDataSourceBase
implements DataSource {
    transient DataSource cachedInner;

    JndiRefForwardingDataSource() {
        VetoableChangeListener l = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Object val = evt.getNewValue();
                if ("jndiName".equals(evt.getPropertyName()) && !(val instanceof Name) && !(val instanceof String)) {
                    throw new PropertyVetoException("jndiName must be a String or a javax.naming.Name", evt);
                }
            }
        };
        this.addVetoableChangeListener(l);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JndiRefForwardingDataSource.this.cachedInner = null;
            }
        };
        this.addPropertyChangeListener(pcl);
    }

    private DataSource dereference() throws SQLException {
        Object jndiName = this.getJndiName();
        Hashtable jndiEnv = this.getJndiEnv();
        try {
            InitialContext ctx = jndiEnv != null ? new InitialContext(jndiEnv) : new InitialContext();
            if (jndiName instanceof String) {
                return (DataSource)ctx.lookup((String)jndiName);
            }
            if (jndiName instanceof Name) {
                return (DataSource)ctx.lookup((Name)jndiName);
            }
            throw new SQLException("Could not find ConnectionPoolDataSource with JNDI name: " + jndiName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    private synchronized DataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        DataSource out = this.dereference();
        if (this.isCaching()) {
            this.cachedInner = out;
        }
        return out;
    }

    public Connection getConnection() throws SQLException {
        return this.inner().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.inner().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.inner().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.inner().setLoginTimeout(seconds);
    }
}

