/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;

public class PrivilegedProxy
implements InvocationHandler,
PrivilegedExceptionAction {
    private Object target;
    private Method method;
    private Object[] args;

    public Object run() throws Exception {
        Object value = null;
        try {
            value = this.method.invoke(this.target, this.args);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        return value;
    }

    PrivilegedProxy(Object target) {
        this.target = target;
    }

    Object getProxy() throws Exception {
        BuildProxyAction action = new BuildProxyAction(this.target, this);
        Object proxy = null;
        try {
            proxy = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.method = method;
        this.args = args;
        Object value = null;
        try {
            value = AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return value;
    }

    private static class BuildProxyAction
    implements PrivilegedExceptionAction {
        Object target;
        InvocationHandler handler;

        BuildProxyAction(Object target, InvocationHandler handler) {
            this.target = target;
            this.handler = handler;
        }

        public Object run() throws Exception {
            Class<?>[] ifaces;
            HashSet tmp = new HashSet();
            Class<?> c = this.target.getClass();
            do {
                ifaces = c.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    Class<?> iface = ifaces[i];
                    int modifiers = iface.getModifiers();
                    if (!Modifier.isPublic(modifiers)) continue;
                    tmp.add(iface);
                }
            } while ((c = c.getSuperclass()) != null);
            ifaces = new Class[tmp.size()];
            tmp.toArray(ifaces);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Proxy.newProxyInstance(loader, ifaces, this.handler);
        }
    }
}

