/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Util;
import com.mysql.jdbc.trace.Tracer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class Security {
    private static final char PVERSION41_CHAR = '*';
    private static final int SHA1_HASH_SIZE = 20;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    private static int charVal(char c) {
        char c2;
        char c3 = c;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.charObject((char)c3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 + 10 : c2 - 97 + 10);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    static byte[] createKeyFromOldPassword(String string) throws NoSuchAlgorithmException {
        String passwd;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        passwd = Security.makeScrambledPassword(passwd);
        int[] salt = Security.getSaltFromPassword(passwd);
        byte[] byArray = Security.getBinaryPassword(salt, false);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] getBinaryPassword(int[] nArray, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray;
        int[] salt;
        void usingNewPasswords;
        int[] nArray2 = nArray;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)nArray2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int val = 0;
        byte[] binaryPassword = new byte[20];
        if (usingNewPasswords != false) {
            int pos = 0;
            int i = 0;
            while (i < 4) {
                val = salt[i];
                int t = 3;
                while (t >= 0) {
                    binaryPassword[pos++] = (byte)(val & 0xFF);
                    val >>= 8;
                    --t;
                }
                ++i;
            }
            byArray = binaryPassword;
        } else {
            int offset = 0;
            int i = 0;
            while (i < 2) {
                val = salt[i];
                int t = 3;
                while (t >= 0) {
                    binaryPassword[t + offset] = (byte)(val % 256);
                    val >>= 8;
                    --t;
                }
                offset += 4;
                ++i;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(binaryPassword, 0, 8);
            byArray = md.digest();
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    private static int[] getSaltFromPassword(String string) {
        int[] nArray;
        String password;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int[] result = new int[6];
        if (password == null || password.length() == 0) {
            nArray = result;
        } else if (password.charAt(0) == '*') {
            String saltInHex = password.substring(1, 5);
            int val = 0;
            int i = 0;
            while (i < 4) {
                val = (val << 4) + Security.charVal(saltInHex.charAt(i));
                ++i;
            }
            nArray = result;
        } else {
            int resultPos = 0;
            int pos = 0;
            int length = password.length();
            while (pos < length) {
                int val = 0;
                int i = 0;
                while (i < 8) {
                    val = (val << 4) + Security.charVal(password.charAt(pos++));
                    ++i;
                }
                result[resultPos++] = val;
            }
            nArray = result;
        }
        int[] nArray2 = nArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(nArray2, joinPoint);
        return nArray;
    }

    private static String longToHex(long l) {
        String string;
        long val;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String longHex = Long.toHexString(val);
        int length = longHex.length();
        if (length < 8) {
            int padding = 8 - length;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < padding) {
                buf.append("0");
                ++i;
            }
            buf.append(longHex);
            string = buf.toString();
        } else {
            string = longHex.substring(0, 8);
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    static String makeScrambledPassword(String string) throws NoSuchAlgorithmException {
        String password;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long[] passwordHash = Util.newHash(password);
        StringBuffer scramble = new StringBuffer();
        scramble.append(Security.longToHex(passwordHash[0]));
        scramble.append(Security.longToHex(passwordHash[1]));
        String string3 = scramble.toString();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    static void passwordCrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        void length;
        byte[] from;
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray2;
        byte[] byArray6 = byArray3;
        int n2 = n;
        Object[] objectArray = new Object[]{byArray4, byArray5, byArray6, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int pos = 0;
        while (pos < from.length && pos < length) {
            void password;
            to[pos] = (byte)(from[pos] ^ password[pos]);
            ++pos;
        }
        Object var11_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var11_11, joinPoint);
    }

    static byte[] passwordHashStage1(String string) throws NoSuchAlgorithmException {
        String password;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        StringBuffer cleansedPassword = new StringBuffer();
        int passwordLength = password.length();
        int i = 0;
        while (i < passwordLength) {
            char c = password.charAt(i);
            if (c != ' ' && c != '\t') {
                cleansedPassword.append(c);
            }
            ++i;
        }
        byte[] byArray = md.digest(cleansedPassword.toString().getBytes());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] passwordHashStage2(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        byte[] hashedPassword;
        void salt;
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)byArray3, (Object)byArray4);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update((byte[])salt, 0, 4);
        md.update(hashedPassword, 0, 20);
        byte[] byArray5 = md.digest();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray5, joinPoint);
        return byArray5;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] scramble411(String string, String string2) throws NoSuchAlgorithmException {
        void seed;
        String password;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string3, (Object)string4);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] passwordHashStage1 = md.digest(password.getBytes());
        md.reset();
        byte[] passwordHashStage2 = md.digest(passwordHashStage1);
        md.reset();
        byte[] seedAsBytes = seed.getBytes();
        md.update(seedAsBytes);
        md.update(passwordHashStage2);
        byte[] toBeXord = md.digest();
        int numToXor = toBeXord.length;
        int i = 0;
        while (i < numToXor) {
            toBeXord[i] = (byte)(toBeXord[i] ^ passwordHashStage1[i]);
            ++i;
        }
        byte[] byArray = toBeXord;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return toBeXord;
    }

    private Security() {
    }

    static {
        Factory factory = new Factory("Security.java", Class.forName("com.mysql.jdbc.Security"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-charVal-com.mysql.jdbc.Security-char:-c:--int-"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-createKeyFromOldPassword-com.mysql.jdbc.Security-java.lang.String:-passwd:-java.security.NoSuchAlgorithmException:-[B-"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-getBinaryPassword-com.mysql.jdbc.Security-[I:boolean:-salt:usingNewPasswords:-java.security.NoSuchAlgorithmException:-[B-"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getSaltFromPassword-com.mysql.jdbc.Security-java.lang.String:-password:--[I-"), 144);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-longToHex-com.mysql.jdbc.Security-long:-val:--java.lang.String-"), 181);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-makeScrambledPassword-com.mysql.jdbc.Security-java.lang.String:-password:-java.security.NoSuchAlgorithmException:-java.lang.String-"), 216);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-passwordCrypt-com.mysql.jdbc.Security-[B:[B:[B:int:-from:to:password:length:--void-"), 241);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-passwordHashStage1-com.mysql.jdbc.Security-java.lang.String:-password:-java.security.NoSuchAlgorithmException:-[B-"), 262);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-passwordHashStage2-com.mysql.jdbc.Security-[B:[B:-hashedPassword:salt:-java.security.NoSuchAlgorithmException:-[B-"), 295);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-scramble411-com.mysql.jdbc.Security-java.lang.String:java.lang.String:-password:seed:-java.security.NoSuchAlgorithmException:-[B-"), 324);
    }
}

