/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.eval.CodeSnippetCodeStream;
import org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetAllocationExpression
extends AllocationExpression
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetAllocationExpression(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (this.binding.canBeSeenBy(allocatedType, this, currentScope)) {
            codeStream.new_(allocatedType);
            if (valueRequired) {
                codeStream.dup();
            }
            codeStream.recordPositionsFrom(pc, this.type.sourceStart);
            if (allocatedType.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
            }
            if (this.arguments != null) {
                int i = 0;
                int count = this.arguments.length;
                while (i < count) {
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    ++i;
                }
            }
            if (allocatedType.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
            }
            codeStream.invokespecial(this.binding);
        } else {
            ((CodeSnippetCodeStream)codeStream).generateEmulationForConstructor(currentScope, this.binding);
            if (this.arguments != null) {
                int argsLength = this.arguments.length;
                codeStream.generateInlinedValue(argsLength);
                codeStream.newArray(currentScope, new ArrayBinding(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT), 1));
                codeStream.dup();
                int i = 0;
                while (i < argsLength) {
                    codeStream.generateInlinedValue(i);
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    TypeBinding parameterBinding = this.binding.parameters[i];
                    if (parameterBinding.isBaseType() && parameterBinding != BaseTypes.NullBinding) {
                        ((CodeSnippetCodeStream)codeStream).generateObjectWrapperForType(this.binding.parameters[i]);
                    }
                    codeStream.aastore();
                    if (i < argsLength - 1) {
                        codeStream.dup();
                    }
                    ++i;
                }
            } else {
                codeStream.generateInlinedValue(0);
                codeStream.newArray(currentScope, new ArrayBinding(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT), 1));
            }
            ((CodeSnippetCodeStream)codeStream).invokeJavaLangReflectConstructorNewInstance();
            codeStream.checkcast(allocatedType);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = ASTNode.NotAConstant;
        this.resolvedType = this.type.resolveType(scope);
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.canBeInstantiated()) {
            scope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding allocatedType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocatedType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemMethodBinding && ((ProblemMethodBinding)this.binding).problemId() == 2) {
                if (this.evaluationContext.declaringTypeName != null) {
                    this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
                    if (this.delegateThis == null) {
                        if (this.binding.declaringClass == null) {
                            this.binding.declaringClass = allocatedType;
                        }
                        scope.problemReporter().invalidConstructor(this, this.binding);
                        return this.resolvedType;
                    }
                } else {
                    if (this.binding.declaringClass == null) {
                        this.binding.declaringClass = allocatedType;
                    }
                    scope.problemReporter().invalidConstructor(this, this.binding);
                    return this.resolvedType;
                }
                CodeSnippetScope localScope = new CodeSnippetScope(scope);
                MethodBinding privateBinding = localScope.getConstructor((ReferenceBinding)this.delegateThis.type, argumentTypes, this);
                if (!privateBinding.isValidBinding()) {
                    if (this.binding.declaringClass == null) {
                        this.binding.declaringClass = allocatedType;
                    }
                    scope.problemReporter().invalidConstructor(this, this.binding);
                    return this.resolvedType;
                }
                this.binding = privateBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocatedType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                return this.resolvedType;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        return allocatedType;
    }
}

