/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.PrivilegedAccessMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class CrosscuttingMembers {
    private ResolvedTypeX inAspect;
    private World world;
    private PerClause perClause;
    private List shadowMungers = new ArrayList(4);
    private List typeMungers = new ArrayList(4);
    private List declareParents = new ArrayList(4);
    private List declareSofts = new ArrayList(0);
    private List declareDominates = new ArrayList(4);

    public CrosscuttingMembers(ResolvedTypeX inAspect) {
        this.inAspect = inAspect;
        this.world = inAspect.getWorld();
    }

    public void addConcreteShadowMunger(ShadowMunger m) {
        this.shadowMungers.add(m);
    }

    public void addShadowMungers(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addShadowMunger((ShadowMunger)i.next());
        }
    }

    private void addShadowMunger(ShadowMunger m) {
        if (this.inAspect.isAbstract()) {
            return;
        }
        this.addConcreteShadowMunger(m.concretize(this.inAspect, this.world, this.perClause));
    }

    public void addTypeMungers(Collection c) {
        this.typeMungers.addAll(c);
    }

    public void addTypeMunger(ConcreteTypeMunger m) {
        if (m == null) {
            return;
        }
        this.typeMungers.add(m);
    }

    public void addDeclares(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addDeclare((Declare)i.next());
        }
    }

    public void addDeclare(Declare declare) {
        if (declare instanceof DeclareErrorOrWarning) {
            Checker m = new Checker((DeclareErrorOrWarning)declare);
            this.addShadowMunger(m);
        } else if (declare instanceof DeclarePrecedence) {
            this.declareDominates.add(declare);
        } else if (declare instanceof DeclareParents) {
            DeclareParents dp = (DeclareParents)declare;
            this.exposeTypes(dp.getParents().getExactTypes());
            this.declareParents.add(dp);
        } else if (declare instanceof DeclareSoft) {
            Pointcut concretePointcut;
            DeclareSoft d = (DeclareSoft)declare;
            Advice m = Advice.makeSoftener(this.world, d.getPointcut(), d.getException(), this.inAspect);
            m.pointcut = concretePointcut = d.getPointcut().concretize(this.inAspect, 0, m);
            this.declareSofts.add(new DeclareSoft(d.getException(), concretePointcut));
            this.addConcreteShadowMunger(m);
        } else {
            throw new RuntimeException("unimplemented");
        }
    }

    public void exposeTypes(Collection typesToExpose) {
        Iterator i = typesToExpose.iterator();
        while (i.hasNext()) {
            this.exposeType((TypeX)i.next());
        }
    }

    public void exposeType(TypeX typeToExpose) {
        if (typeToExpose == ResolvedTypeX.MISSING) {
            return;
        }
        ResolvedMember member = new ResolvedMember(Member.STATIC_INITIALIZATION, typeToExpose, 0, ResolvedTypeX.VOID, "", TypeX.NONE);
        this.addTypeMunger(this.world.concreteTypeMunger(new PrivilegedAccessMunger(member), this.inAspect));
    }

    public void addPrivilegedAccesses(Collection accessedMembers) {
        Iterator i = accessedMembers.iterator();
        while (i.hasNext()) {
            this.addPrivilegedAccess((ResolvedMember)i.next());
        }
    }

    private void addPrivilegedAccess(ResolvedMember member) {
        this.addTypeMunger(this.world.concreteTypeMunger(new PrivilegedAccessMunger(member), this.inAspect));
    }

    public Collection getCflowEntries() {
        ArrayList<Advice> ret = new ArrayList<Advice>();
        Iterator i = this.shadowMungers.iterator();
        while (i.hasNext()) {
            Advice a;
            ShadowMunger m = (ShadowMunger)i.next();
            if (!(m instanceof Advice) || !(a = (Advice)m).getKind().isCflow()) continue;
            ret.add(a);
        }
        return ret;
    }

    public boolean replaceWith(CrosscuttingMembers other) {
        boolean changed = false;
        if (this.perClause == null || !this.perClause.equals(other.perClause)) {
            changed = true;
            this.perClause = other.perClause;
        }
        if (!this.shadowMungers.equals(other.shadowMungers)) {
            changed = true;
            this.shadowMungers = other.shadowMungers;
        }
        if (!this.typeMungers.equals(other.typeMungers)) {
            changed = true;
            this.typeMungers = other.typeMungers;
        }
        if (!this.declareDominates.equals(other.declareDominates)) {
            changed = true;
            this.declareDominates = other.declareDominates;
        }
        if (!this.declareParents.equals(other.declareParents)) {
            changed = true;
            this.declareParents = other.declareParents;
        }
        if (!this.declareSofts.equals(other.declareSofts)) {
            changed = true;
            this.declareSofts = other.declareSofts;
        }
        return changed;
    }

    public PerClause getPerClause() {
        return this.perClause;
    }

    public void setPerClause(PerClause perClause) {
        this.perClause = perClause.concretize(this.inAspect);
    }

    public List getDeclareDominates() {
        return this.declareDominates;
    }

    public List getDeclareParents() {
        return this.declareParents;
    }

    public List getDeclareSofts() {
        return this.declareSofts;
    }

    public List getShadowMungers() {
        return this.shadowMungers;
    }

    public List getTypeMungers() {
        return this.typeMungers;
    }
}

