/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BetaException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ArgsPointcut
extends NameBindingPointcut {
    TypePatternList arguments;

    public ArgsPointcut(TypePatternList arguments) {
        this.arguments = arguments;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        FuzzyBoolean ret = this.arguments.matches(shadow.getIWorld().resolve(shadow.getArgTypes()), TypePattern.DYNAMIC);
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(4);
        this.arguments.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        ArgsPointcut ret = new ArgsPointcut(TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArgsPointcut)) {
            return false;
        }
        ArgsPointcut o = (ArgsPointcut)other;
        return o.arguments.equals(this.arguments);
    }

    public int hashCode() {
        return this.arguments.hashCode();
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.arguments.resolveBindings(scope, bindings, true, true);
        if (this.arguments.ellipsisCount > 1) {
            scope.message(IMessage.ERROR, this, "uses more than one .. in args (compiler limitation)");
        }
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.arguments.postRead(enclosingType);
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, "args() pointcut designator cannot be used in declare statement", bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        TypePatternList args = this.arguments.resolveReferences(bindings);
        if (inAspect.crosscuttingMembers != null) {
            inAspect.crosscuttingMembers.exposeTypes(args.getExactTypes());
        }
        return new ArgsPointcut(args);
    }

    private Test findResidueNoEllipsis(Shadow shadow, ExposedState state, TypePattern[] patterns) {
        int len = shadow.getArgCount();
        if (patterns.length != len) {
            return Literal.FALSE;
        }
        Test ret = Literal.TRUE;
        int i = 0;
        while (i < len) {
            block5: {
                TypePattern type;
                block4: {
                    block3: {
                        TypeX argType = shadow.getArgType(i);
                        type = patterns[i];
                        if (type instanceof BindingTypePattern) break block3;
                        if (!type.matchesInstanceof(shadow.getIWorld().resolve(argType)).alwaysTrue()) break block4;
                        break block5;
                    }
                    BindingTypePattern btp = (BindingTypePattern)type;
                    if (state.get(btp.getFormalIndex()) != null) {
                        ISourceLocation isl = this.getSourceLocation();
                        Message errorMessage = new Message("Ambiguous binding of type " + type.getExactType().toString() + " using args(..) at this line.  Use one args(..) per matched join point," + "" + " see secondary source location for location of extraneous args(..)", shadow.getSourceLocation(), true, new ISourceLocation[]{this.getSourceLocation()});
                        shadow.getIWorld().getMessageHandler().handleMessage(errorMessage);
                    }
                }
                ret = Test.makeAnd(ret, this.exposeStateForVar(shadow.getArgVar(i), type, state, shadow.getIWorld()));
            }
            ++i;
        }
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (this.arguments.matches(shadow.getIWorld().resolve(shadow.getArgTypes()), TypePattern.DYNAMIC).alwaysFalse()) {
            return Literal.FALSE;
        }
        int ellipsisCount = this.arguments.ellipsisCount;
        if (ellipsisCount == 0) {
            return this.findResidueNoEllipsis(shadow, state, this.arguments.getTypePatterns());
        }
        if (ellipsisCount == 1) {
            TypePattern[] patternsWithEllipsis = this.arguments.getTypePatterns();
            TypePattern[] patternsWithoutEllipsis = new TypePattern[shadow.getArgCount()];
            int lenWithEllipsis = patternsWithEllipsis.length;
            int lenWithoutEllipsis = patternsWithoutEllipsis.length;
            int indexWithEllipsis = 0;
            int indexWithoutEllipsis = 0;
            while (indexWithoutEllipsis < lenWithoutEllipsis) {
                TypePattern p;
                if ((p = patternsWithEllipsis[indexWithEllipsis++]) == TypePattern.ELLIPSIS) {
                    int newLenWithoutEllipsis = lenWithoutEllipsis - (lenWithEllipsis - indexWithEllipsis);
                    while (indexWithoutEllipsis < newLenWithoutEllipsis) {
                        patternsWithoutEllipsis[indexWithoutEllipsis++] = TypePattern.ANY;
                    }
                    continue;
                }
                patternsWithoutEllipsis[indexWithoutEllipsis++] = p;
            }
            return this.findResidueNoEllipsis(shadow, state, patternsWithoutEllipsis);
        }
        throw new BetaException("unimplemented");
    }

    public String toString() {
        return "args" + this.arguments.toString() + "";
    }
}

