/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Field;
import java.sql.SQLException;
import java.util.Vector;

public class ResultSetMetaData {
    Vector Rows;
    Field[] Fields;

    public ResultSetMetaData(Vector vector, Field[] fieldArray) {
        this.Rows = vector;
        this.Fields = fieldArray;
    }

    public int getColumnCount() throws SQLException {
        return this.Fields.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        if (!this.getField(n).isNotNull()) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getSQLType();
        switch (n2) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return !field.isUnsigned();
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getField(n).getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.getField(n).getName();
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        Field field = this.getField(n);
        if (ResultSetMetaData.isDecimalType(field.getSQLType())) {
            if (field.getDecimals() > 0) {
                return field.getLength() - 1;
            }
            return field.getLength();
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        Field field = this.getField(n);
        if (ResultSetMetaData.isDecimalType(field.getSQLType())) {
            return field.getDecimals();
        }
        return 0;
    }

    public String getCatalogName(int n) throws SQLException {
        Field field = this.getField(n);
        return "";
    }

    public String getTableName(int n) throws SQLException {
        return this.getField(n).getTableName();
    }

    public int getColumnType(int n) throws SQLException {
        return this.getField(n).getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getField(n).getMysqlType();
        switch (n2) {
            case 0: {
                return "DECIMAL";
            }
            case 1: {
                return "TINY";
            }
            case 2: {
                return "SHORT";
            }
            case 3: {
                return "LONG";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "DOUBLE";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "LONGLONG";
            }
            case 9: {
                return "INT";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "DATETIME";
            }
            case 249: {
                return "TINYBLOB";
            }
            case 250: {
                return "MEDIUMBLOB";
            }
            case 251: {
                return "LONGBLOB";
            }
            case 252: {
                if (this.getField(n).isBinary()) {
                    return "TEXT";
                }
                return "BLOB";
            }
            case 253: {
                return "VARCHAR";
            }
            case 254: {
                return "CHAR";
            }
            case 247: {
                return "ENUM";
            }
            case 248: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.isWritable(n);
    }

    protected Field getField(int n) throws SQLException {
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column index out of range.", "S1002");
        }
        return this.Fields[n - 1];
    }

    private static final boolean isDecimalType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

