untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8ohq1juhsEEIAWAzoEJkCagrNs0yF78fiAWO/FM6HK2VQtSx5M1HcUcYTaQgnSlqIlwTIFGOnltXaUZATw2mVnwk=

OpenBSD 7.6 errata 016, May 5, 2025:

Kernel of NFS server could crash if nfsd(8) is enabled and an evil
NFS request is sent to it.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 016_nfs.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/nfs/nfs_serv.c
===================================================================
RCS file: /cvs/src/sys/nfs/nfs_serv.c,v
diff -u -p -r1.130 nfs_serv.c
--- sys/nfs/nfs_serv.c	18 Sep 2024 05:21:19 -0000	1.130
+++ sys/nfs/nfs_serv.c	2 May 2025 10:52:02 -0000
@@ -2435,6 +2435,10 @@ nfsrv_readdir(struct nfsrv_descript *nfs
 		siz = xfer;
 	fullsiz = siz;
 	error = nfsrv_fhtovp(fhp, 1, &vp, cred, slp, nam, &rdonly);
+	if (!error && vp->v_type != VDIR) {
+		error = ENOTDIR;
+		vput(vp);
+	}
 	if (error) {
 		if (nfsm_reply(&info, nfsd, slp, mrq, error,
 		    NFSX_UNSIGNED) != 0)
@@ -2653,6 +2657,10 @@ nfsrv_readdirplus(struct nfsrv_descript 
 		siz = xfer;
 	fullsiz = siz;
 	error = nfsrv_fhtovp(fhp, 1, &vp, cred, slp, nam, &rdonly);
+	if (!error && vp->v_type != VDIR) {
+		error = ENOTDIR;
+		vput(vp);
+	}
 	if (error) {
 		if (nfsm_reply(&info, nfsd, slp, mrq, error,
 		    NFSX_UNSIGNED) != 0)
