untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8DrhMHIhO/tbSr4mxLcr2QEBRfDAOfTXcgSHjEGsg/3Y5NsQ7+25uZi8A9IQmcdi5aHPcSFrXz0t1YPkJPxSOgg=

OpenBSD 7.2 errata 023, March 23, 2023:

Incorrect length checks allow an out-of-bounds read in bgpd(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 023_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/rde.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde.c,v
diff -u -p -r1.578 rde.c
--- usr.sbin/bgpd/rde.c	23 Sep 2022 15:49:20 -0000	1.578
+++ usr.sbin/bgpd/rde.c	21 Mar 2023 12:25:59 -0000
@@ -2014,7 +2014,7 @@ bad_flags:
 			goto bad_flags;
 		goto optattr;
 	case ATTR_MP_REACH_NLRI:
-		if (attr_len < 4)
+		if (attr_len < 5)
 			goto bad_len;
 		if (!CHECK_FLAGS(flags, ATTR_OPTIONAL, 0))
 			goto bad_flags;
@@ -2208,7 +2208,7 @@ rde_get_mp_nexthop(u_char *data, uint16_
 	totlen = 1;
 	len--;
 
-	if (nhlen > len)
+	if (nhlen + 1 > len)
 		return (-1);
 
 	memset(&nexthop, 0, sizeof(nexthop));
