untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8KnMj8/Da3AUwSujO8qkpQpDvqziaw1cr8oe7X/gpP2CuBvapHi2aff5i5g4GsCWqlfPEb4jycamMnWJoPYCEQU=

OpenBSD 7.2 errata 008, November 26, 2022:

Fix a assertion crash during pfsync state update.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 008_pfsync.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
diff -u -p -u -r1.1140 pf.c
--- sys/net/pf.c	3 Sep 2022 19:22:19 -0000	1.1140
+++ sys/net/pf.c	24 Nov 2022 16:55:33 -0000
@@ -1023,10 +1023,10 @@ pf_state_insert(struct pfi_kif *kif, str
 	pf_status.fcounters[FCNT_STATE_INSERT]++;
 	pf_status.states++;
 	pfi_kif_ref(kif, PFI_KIF_REF_STATE);
-	PF_STATE_EXIT_WRITE();
 #if NPFSYNC > 0
 	pfsync_insert_state(s);
 #endif	/* NPFSYNC > 0 */
+	PF_STATE_EXIT_WRITE();
 	return (0);
 }
