untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTWM/33Xm16jI5aUA39RftbJHCAj5QCd7hGjClCJlGYAbshlU/LBcZFHELpT3Di5cxQgQnZud+b8QFl9R5XVsUQI=

OpenBSD 7.1 errata 011, September 26, 2022:

In smtpd(8), possible use-after-free if TLS handshake fails for
outbound connections.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 011_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mta_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mta_session.c,v
retrieving revision 1.146
diff -u -p -r1.146 mta_session.c
--- usr.sbin/smtpd/mta_session.c	18 Feb 2022 17:02:06 -0000	1.146
+++ usr.sbin/smtpd/mta_session.c	22 Sep 2022 20:44:35 -0000
@@ -1212,6 +1212,8 @@ mta_io(struct io *io, int evt, void *arg
 		if (s->use_smtps) {
 			io_set_write(io);
 			mta_tls_init(s);
+			if (s->flags & MTA_FREE)
+				mta_free(s);
 		}
 		else {
 			mta_enter_state(s, MTA_BANNER);
@@ -1568,7 +1570,7 @@ mta_tls_init(struct mta_session *s)
 
 	if ((tls = tls_client()) == NULL) {
 		log_info("%016"PRIx64" mta closing reason=tls-failure", s->id);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 		return;
 	}
 
@@ -1582,14 +1584,14 @@ mta_tls_init(struct mta_session *s)
 	if (tls_configure(tls, remote->tls_config) == -1) {
 		log_info("%016"PRIx64" mta closing reason=tls-failure", s->id);
 		tls_free(tls);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 		return;
 	}
 
 	if (io_connect_tls(s->io, tls, s->mxname) == -1) {
 		log_info("%016"PRIx64" mta closing reason=tls-connect-failed", s->id);
 		tls_free(tls);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 	}
 }
 
