untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46NWSNXwG1tvAH0kn7RFo6gooqplplXILn9guTexrWRW/WtBEkZQ0Ia4/1X1uN7NQqlE7Sk7M9okub6xjq8S99wQ=

OpenBSD 6.9 errata 016, Sep 27, 2021:

sshd(8) failed to clear supplemental groups when executing an
AuthorizedUsersCommand or AuthorizedPrincipalsCommand helper program.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 016_sshd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sshd(8)
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/misc.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/misc.c,v
diff -u -p -u -r1.164 misc.c
--- usr.bin/ssh/misc.c	3 Apr 2021 06:18:40 -0000	1.164
+++ usr.bin/ssh/misc.c	16 Sep 2021 16:27:05 -0000
@@ -2525,6 +2525,12 @@ subprocess(const char *tag, const char *
 		}
 		closefrom(STDERR_FILENO + 1);
 
+		if (geteuid() == 0 &&
+		    initgroups(pw->pw_name, pw->pw_gid) == -1) {
+			error("%s: initgroups(%s, %u): %s", tag,
+			    pw->pw_name, (u_int)pw->pw_gid, strerror(errno));
+			_exit(1);
+		}
 		if (setresgid(pw->pw_gid, pw->pw_gid, pw->pw_gid) == -1) {
 			error("%s: setresgid %u: %s", tag, (u_int)pw->pw_gid,
 			    strerror(errno));
