/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.health;

import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.HealthChecker;
import org.jitsi.health.Result;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.health.HealthConfig;
import org.jitsi.jicofo.health.JicofoHealthCheckerKt;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.metrics.BooleanMetric;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/jicofo/health/JicofoHealthChecker;", "Lorg/jitsi/health/HealthCheckService;", "config", "Lorg/jitsi/jicofo/health/HealthConfig;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "xmppProviders", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "(Lorg/jitsi/jicofo/health/HealthConfig;Lorg/jitsi/jicofo/FocusManager;Lorg/jitsi/jicofo/bridge/BridgeSelector;Ljava/util/Collection;)V", "healthChecker", "Lorg/jitsi/health/HealthChecker;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "result", "Lorg/jitsi/health/Result;", "getResult", "()Lorg/jitsi/health/Result;", "<set-?>", "", "totalSlowHealthChecks", "getTotalSlowHealthChecks", "()J", "check", "performCheck", "pingXmppProvider", "", "xmppProvider", "shutdown", "start", "Companion", "jicofo"})
@SourceDebugExtension(value={"SMAP\nJicofoHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JicofoHealthChecker.kt\norg/jitsi/jicofo/health/JicofoHealthChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1855#2,2:189\n*S KotlinDebug\n*F\n+ 1 JicofoHealthChecker.kt\norg/jitsi/jicofo/health/JicofoHealthChecker\n*L\n139#1:189,2\n*E\n"})
public final class JicofoHealthChecker
implements HealthCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FocusManager focusManager;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @NotNull
    private final Collection<XmppProvider> xmppProviders;
    @NotNull
    private final Logger logger;
    private long totalSlowHealthChecks;
    @NotNull
    private final HealthChecker healthChecker;
    @NotNull
    private static final BooleanMetric healthyMetric = JicofoMetricsContainer.Companion.getInstance().registerBooleanMetric("healthy", "Whether jicofo is healthy or not.", true);

    public JicofoHealthChecker(@NotNull HealthConfig config, @NotNull FocusManager focusManager, @NotNull BridgeSelector bridgeSelector, @NotNull Collection<XmppProvider> xmppProviders) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(focusManager, "focusManager");
        Intrinsics.checkNotNullParameter(bridgeSelector, "bridgeSelector");
        Intrinsics.checkNotNullParameter(xmppProviders, "xmppProviders");
        this.focusManager = focusManager;
        this.bridgeSelector = bridgeSelector;
        this.xmppProviders = xmppProviders;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        Duration duration = config.getInterval();
        Duration duration2 = config.getTimeout();
        Duration duration3 = config.getMaxCheckDuration();
        Duration duration4 = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue(duration4, "ofMinutes(...)");
        Function0 function0 = new Function0<Result>(this){
            final /* synthetic */ JicofoHealthChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Result invoke() {
                return JicofoHealthChecker.access$performCheck(this.this$0);
            }
        };
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue(clock, "systemUTC(...)");
        this.healthChecker = new HealthChecker(duration, duration2, duration3, false, duration4, function0, clock);
    }

    public final long getTotalSlowHealthChecks() {
        return this.totalSlowHealthChecks;
    }

    public final void start() {
        this.healthChecker.start();
    }

    public final void shutdown() {
        try {
            this.healthChecker.stop();
        }
        catch (Exception e) {
            this.logger.warn("Failed to stop.", e);
        }
    }

    private final Result performCheck() {
        Result result;
        long start2 = System.currentTimeMillis();
        Result it = result = this.check();
        boolean bl = false;
        long duration = System.currentTimeMillis() - start2;
        if (duration > HealthConfig.config.getMaxCheckDuration().toMillis()) {
            this.logger.error("Health check took too long: " + duration + " ms");
            long l = this.totalSlowHealthChecks;
            this.totalSlowHealthChecks = l + 1L;
        }
        healthyMetric.set(it.getSuccess());
        return result;
    }

    @Override
    @NotNull
    public Result getResult() {
        return this.healthChecker.getResult();
    }

    private final Result check() {
        if (this.bridgeSelector.getOperationalBridgeCount() <= 0) {
            return new Result(false, true, null, false, "No operational bridges available (total bridge count: " + BridgeSelector.bridgeCount.get() + ")", 12, null);
        }
        EntityBareJid roomName = null;
        do {
            Intrinsics.checkNotNullExpressionValue(JidCreate.entityBareFrom(JicofoHealthCheckerKt.access$generateRoomName(), XmppConfig.client.getConferenceMucJid()), "entityBareFrom(...)");
        } while (this.focusManager.getConference(roomName) != null);
        try {
            Map<String, String> map = MapsKt.emptyMap();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue(level, "WARNING");
            if (!this.focusManager.conferenceRequest(roomName, map, level, false)) {
                return new Result(false, true, null, false, "Test conference failed to start.", 12, null);
            }
        }
        catch (SmackException.NoResponseException e) {
            return new Result(false, false, null, false, "Test conference failed to start due to timeout.", 12, null);
        }
        try {
            Iterable $this$forEach$iv = this.xmppProviders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmppProvider it = (XmppProvider)element$iv;
                boolean bl = false;
                this.pingXmppProvider(it);
            }
        }
        catch (Exception e) {
            return new Result(false, false, null, false, "XMPP ping failed: " + e.getMessage(), 12, null);
        }
        return new Result(true, false, null, false, null, 30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pingXmppProvider(XmppProvider xmppProvider) throws Exception {
        CountDownLatch pingResponseWait = new CountDownLatch(1);
        DomainBareJid xmppDomain2 = xmppProvider.getConfig().getXmppDomain();
        if (xmppDomain2 == null) {
            this.logger.debug("Not pinging " + xmppProvider.getConfig().getName() + ", domain not configured.");
            return;
        }
        Ping p = new Ping(JidCreate.bareFrom(xmppDomain2));
        StanzaListener listener = arg_0 -> JicofoHealthChecker.pingXmppProvider$lambda$2(pingResponseWait, arg_0);
        try {
            xmppProvider.getXmppConnection().addSyncStanzaListener(listener, arg_0 -> JicofoHealthChecker.pingXmppProvider$lambda$3(p, arg_0));
            xmppProvider.getXmppConnection().sendStanza(p);
            if (!pingResponseWait.await(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("did not receive xmpp ping response for " + xmppProvider.getConfig().getName());
            }
        }
        finally {
            xmppProvider.getXmppConnection().removeSyncStanzaListener(listener);
        }
    }

    private static final void pingXmppProvider$lambda$2(CountDownLatch $pingResponseWait, Stanza stanza) {
        Intrinsics.checkNotNullParameter($pingResponseWait, "$pingResponseWait");
        $pingResponseWait.countDown();
    }

    private static final boolean pingXmppProvider$lambda$3(Ping $p, Stanza it) {
        Intrinsics.checkNotNullParameter($p, "$p");
        return Intrinsics.areEqual(it.getStanzaId(), $p.getStanzaId());
    }

    public static final /* synthetic */ Result access$performCheck(JicofoHealthChecker $this) {
        return $this.performCheck();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/jicofo/health/JicofoHealthChecker$Companion;", "", "()V", "healthyMetric", "Lorg/jitsi/metrics/BooleanMetric;", "getHealthyMetric", "()Lorg/jitsi/metrics/BooleanMetric;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanMetric getHealthyMetric() {
            return healthyMetric;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

