/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.irc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.i2ptunnel.irc.DCCHelper;
import net.i2p.i2ptunnel.irc.IRCFilter;
import net.i2p.util.Log;

public class IrcOutboundFilter
implements Runnable {
    private final Socket local;
    private final I2PSocket remote;
    private final StringBuffer expectedPong;
    private final Log _log;
    private final DCCHelper _dccHelper;

    public IrcOutboundFilter(Socket lcl, I2PSocket rem, StringBuffer pong, Log log) {
        this(lcl, rem, pong, log, null);
    }

    public IrcOutboundFilter(Socket lcl, I2PSocket rem, StringBuffer pong, Log log, DCCHelper helper) {
        this.local = lcl;
        this.remote = rem;
        this.expectedPong = pong;
        this._log = log;
        this._dccHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream output;
        BufferedReader in;
        try {
            in = new BufferedReader(new InputStreamReader(this.local.getInputStream(), "ISO-8859-1"));
            output = this.remote.getOutputStream();
        }
        catch (IOException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IrcOutboundFilter: no streams", e);
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("IrcOutboundFilter: Running.");
        }
        try {
            try {
                String inmsg;
                while ((inmsg = in.readLine()) != null) {
                    String outmsg;
                    if (inmsg.endsWith("\r")) {
                        inmsg = inmsg.substring(0, inmsg.length() - 1);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("out: [" + inmsg + "]");
                    }
                    if ((outmsg = IRCFilter.outboundFilter(inmsg, this.expectedPong, this._dccHelper)) != null) {
                        if (!inmsg.equals(outmsg)) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn("outbound FILTERED: " + outmsg);
                                this._log.warn(" - outbound was: " + inmsg);
                            }
                        } else if (this._log.shouldLog(20)) {
                            this._log.info("outbound: " + outmsg);
                        }
                        outmsg = outmsg + "\r\n";
                        output.write(outmsg.getBytes("ISO-8859-1"));
                        if (in.ready()) continue;
                        output.flush();
                        continue;
                    }
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("outbound BLOCKED: \"" + inmsg + "\"");
                }
            }
            catch (IOException e1) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("IrcOutboundFilter: disconnected", e1);
                }
            }
        }
        catch (RuntimeException re) {
            this._log.error("Error filtering outbound data", re);
        }
        finally {
            try {
                this.remote.close();
            }
            catch (IOException iOException) {}
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("IrcOutboundFilter: Done.");
        }
    }
}

