/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AttachClassicLinkVpc
extends BaseCmd {
    private static final String VPC_DESC = "The ID of the ClassicLink-enabled VPC.";
    private static final String INSTANCE_DESC = "The ID of the EC2-Classic instance to link the ClassicLink-enabled VPC.";
    private static final String GROUP_ID_DESC = "The ID of a VPC's security group. You cannot specify a security group from a different VPC. You can specify more than one group in the request.";
    private String vpcId;
    private String instanceId;
    private String[] groupIds;

    public AttachClassicLinkVpc(String[] args) {
        super("ec2attachcl", "ec2-attach-classic-link-vpc");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "-c VPC -g SECURITY_GROUP -i INSTANCE_ID";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)this.joinDescription(VPC_DESC));
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"INSTANCE");
        OptionBuilder.withDescription((String)this.joinDescription(INSTANCE_DESC));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"group-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"GROUP_ID");
        OptionBuilder.withDescription((String)this.joinDescription(GROUP_ID_DESC));
        options.addOption(OptionBuilder.create((String)"g"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You cannot link an EC2-Classic instance to more than one VPC at a time.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
        this.printOption("instance");
        this.printOption("group-id");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpcId = this.getOptionValue("vpc");
        this.instanceId = this.getOptionValue("instance");
        this.groupIds = this.getOptionValues("group-id");
        RequestResultPair rsp = jec2.attachClassicLinkVpc(this.vpcId, this.instanceId, this.groupIds);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("vpc");
        this.assertOptionSet("instance");
        this.assertOptionSet("group-id");
    }

    public static void main(String[] args) {
        new AttachClassicLinkVpc(args).invoke();
    }
}

