/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.Hashtable;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.trans.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepPlugin
extends Plugin<String[]> {
    private String category;
    private String errorHelpFile;
    public static final String[] typeDesc = new String[]{Messages.getString("StepPlugin.Type.All.Desc"), Messages.getString("StepPlugin.Type.Native.Desc"), Messages.getString("StepPlugin.Type.Plugin.Desc")};
    private boolean separateClassloaderNeeded;
    private Map<String, String> localizedCategories;
    private Map<String, String> localizedDescriptions;
    private Map<String, String> localizedTooltips;

    public StepPlugin(int type, String[] id, String description, String tooltip, String directory, String[] jarfiles, String icon_filename, String classname, String category, String errorHelpFile) {
        super(type, (Object)id, description, tooltip, directory, jarfiles, icon_filename, classname);
        this.category = category;
        this.errorHelpFile = errorHelpFile;
        this.separateClassloaderNeeded = false;
        this.localizedCategories = new Hashtable<String, String>();
        this.localizedDescriptions = new Hashtable<String, String>();
        this.localizedTooltips = new Hashtable<String, String>();
    }

    public String getDescription() {
        return this.getDescription(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getDescription(String locale) {
        String localizedDescription = this.localizedDescriptions.get(locale.toLowerCase());
        if (localizedDescription != null) {
            return localizedDescription;
        }
        return this.description;
    }

    public String getTooltip() {
        return this.getTooltip(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getTooltip(String locale) {
        String localizedTooltip = this.localizedTooltips.get(locale.toLowerCase());
        if (localizedTooltip != null) {
            return localizedTooltip;
        }
        return super.getTooltip();
    }

    public String getCategory() {
        return this.getCategory(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getCategory(String locale) {
        String localizedCategory = this.localizedCategories.get(locale.toLowerCase());
        if (localizedCategory != null) {
            return localizedCategory;
        }
        if (this.category == null) {
            return Messages.getString("StepPlugin.Label");
        }
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int hashCode() {
        return ((String[])this.getID()).hashCode();
    }

    public boolean equals(Object obj) {
        return this.handles((String[])((StepPlugin)((Object)obj)).getID());
    }

    public boolean handles(String pluginID) {
        String[] id = (String[])this.getID();
        for (int i = 0; i < id.length; ++i) {
            if (!id[i].equals(pluginID)) continue;
            return true;
        }
        return false;
    }

    public boolean handles(String[] pluginID) {
        String[] id = (String[])this.getID();
        for (int i = 0; i < id.length; ++i) {
            for (int j = 0; j < pluginID.length; ++j) {
                if (!id[i].equals(pluginID[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String getJarfilesList() {
        String list = "";
        String[] jarfiles = super.getJarfiles();
        if (jarfiles != null) {
            for (int i = 0; i < jarfiles.length; ++i) {
                if (i > 0) {
                    list = list + Const.PATH_SEPARATOR;
                }
                list = list + jarfiles[i];
            }
        }
        return list;
    }

    public void setErrorHelpFile(String errorHelpText) {
        this.errorHelpFile = errorHelpText;
    }

    public String getErrorHelpFile() {
        return this.errorHelpFile;
    }

    public boolean isSeparateClassloaderNeeded() {
        return this.separateClassloaderNeeded;
    }

    public void setSeparateClassloaderNeeded(boolean separateClassloaderNeeded) {
        this.separateClassloaderNeeded = separateClassloaderNeeded;
    }

    public void setLocalizedCategories(Map<String, String> localizedCategories) {
        this.localizedCategories = localizedCategories;
    }

    public Map<String, String> getLocalizedCategories() {
        return this.localizedCategories;
    }

    public void setLocalizedDescriptions(Map<String, String> localizedDescriptions) {
        this.localizedDescriptions = localizedDescriptions;
    }

    public Map<String, String> getLocalizedDescriptions() {
        return this.localizedDescriptions;
    }

    public Map<String, String> getLocalizedTooltips() {
        return this.localizedTooltips;
    }

    public void setLocalizedTooltips(Map<String, String> localizedTooltips) {
        this.localizedTooltips = localizedTooltips;
    }

    public String getTypeDesc() {
        return typeDesc[super.getType()];
    }

    public static RowMetaInterface getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Type.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ID.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Description.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ToolTip.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Directory.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.JarFiles.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.IconFile.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ClassName.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Category.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ErrorHelpFile.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.SeparateClassloader.Label"), 4));
        return row;
    }

    public Object[] getPluginInformation() {
        Object[] row = new Object[StepPlugin.getPluginInformationRowMeta().size()];
        int rowIndex = 0;
        row[rowIndex++] = this.getTypeDesc();
        row[rowIndex++] = ((String[])this.getID())[0];
        row[rowIndex++] = this.getDescription();
        row[rowIndex++] = this.getTooltip();
        row[rowIndex++] = this.getDirectory();
        row[rowIndex++] = this.getJarfilesList();
        row[rowIndex++] = this.getIconFilename();
        row[rowIndex++] = this.getClassname();
        row[rowIndex++] = this.getCategory();
        row[rowIndex++] = this.getErrorHelpFile();
        row[rowIndex++] = this.isSeparateClassloaderNeeded();
        return row;
    }
}

