
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was mapnikConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

set_and_check(MAPNIK_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/mapnik" CACHE STRING "")
set_and_check(MAPNIK_FONTS_DIR "${PACKAGE_PREFIX_DIR}/lib/mapnik/fonts" CACHE STRING "")

set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} "${CMAKE_CURRENT_LIST_DIR}/Modules/")

include(CMakeFindDependencyMacro)

find_dependency(Threads REQUIRED)

# PkgConfig used with version 
find_dependency(PkgConfig REQUIRED)
# ICU used with version 76.1
find_dependency(ICU REQUIRED COMPONENTS uc i18n data)
# Boost used with version 1.87.0
find_dependency(Boost 1.73 REQUIRED COMPONENTS regex)
# Freetype used with version 2.13.3
find_dependency(Freetype REQUIRED)
# harfbuzz used with version 11.0.0
find_dependency(harfbuzz CONFIG QUIET)
# LibXml2 used with version 2.13.7
find_dependency(LibXml2 REQUIRED)
# PNG used with version 1.6.47
find_dependency(PNG REQUIRED)
# JPEG used with version 62
find_dependency(JPEG REQUIRED)
# TIFF used with version 4.7.0
find_dependency(TIFF REQUIRED)
# WebP used with version 1.4.0
pkg_check_modules(WebP REQUIRED IMPORTED_TARGET libwebp)
# Cairo used with version 1.18.4
pkg_check_modules(Cairo REQUIRED IMPORTED_TARGET cairo)
# PROJ used with version 9.6.0
find_dependency(PROJ QUIET)

include("${CMAKE_CURRENT_LIST_DIR}/mapnikTargets.cmake")

set(_supported_components geometry_to_wkb;mapnik-index;mapnik-render;pgsql2sqlite;shapeindex;svg2png)
foreach(_comp ${mapnik_FIND_COMPONENTS})
  if (NOT _comp IN_LIST _supported_components)
    set(mapnik_FOUND False)
    set(mapnik_NOT_FOUND_MESSAGE "Unsupported component: ${_comp}")
  endif()
  include("${CMAKE_CURRENT_LIST_DIR}/mapnikUtilityTargets_${_comp}.cmake")
endforeach()


get_filename_component(_plugin_dir "${CMAKE_CURRENT_LIST_FILE}" PATH)
file(GLOB CONFIG_FILES "${_plugin_dir}/mapnikPlugins-*.cmake")
foreach(f ${CONFIG_FILES})
  include(${f})
endforeach()

function(mapnik_find_plugin_dir PLUGIN_DIR)
    string(TOUPPER "${CMAKE_BUILD_TYPE}" _build_type_l)
    set(_plugin_dir "${MAPNIK_PLUGINS_DIR_${_build_type_l}}")
    # only release has more then one configuration
    if(NOT _plugin_dir)
        set(_all_rel_cfgs RELEASE RELWITHDEBINFO MINSIZEREL)
        list(FIND _all_rel_cfgs ${_build_type_l} _is_rel_cfg)
        # check if the current configuration is a known release configuration
        if(${_is_rel_cfg} GREATER_EQUAL 0)
            foreach(_rel_cfg IN LISTS _all_rel_cfgs)
                set(_plugin_dir "${MAPNIK_PLUGINS_DIR_${_rel_cfg}}")
                if(_plugin_dir)
                    break()
                endif()
            endforeach()
        endif()
    endif()
    if(NOT _plugin_dir)
        message(WARNING "Could not find a plugin install dir for configuration ${_build_type_l}")
    endif()
    set(${PLUGIN_DIR} ${_plugin_dir} PARENT_SCOPE)
endfunction()
