/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfField;
import com.lowagie.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOCEntry
extends Chunk
implements RtfField {
    private boolean hideText = false;
    private boolean hidePageNumber = false;
    private String entryName;
    private Font entryFont;
    private Font contentFont;

    public RtfTOCEntry(String string, Font font) {
        this(string, font, string, font);
    }

    public RtfTOCEntry(String string, Font font, String string2, Font font2) {
        super(string, font);
        this.entryName = string2;
        this.entryFont = font2;
        this.contentFont = font;
    }

    public void write(RtfWriter rtfWriter, OutputStream outputStream) throws IOException {
        if (!this.hideText) {
            rtfWriter.writeInitialFontSignature(outputStream, new Chunk("", this.contentFont));
            outputStream.write(RtfWriter.filterSpecialChar(this.getContent(), true).getBytes());
            rtfWriter.writeFinishingFontSignature(outputStream, new Chunk("", this.contentFont));
        }
        if (!this.entryFont.equals(this.contentFont)) {
            rtfWriter.writeInitialFontSignature(outputStream, new Chunk("", this.entryFont));
            this.writeField(outputStream);
            rtfWriter.writeFinishingFontSignature(outputStream, new Chunk("", this.entryFont));
        } else {
            rtfWriter.writeInitialFontSignature(outputStream, new Chunk("", this.contentFont));
            this.writeField(outputStream);
            rtfWriter.writeFinishingFontSignature(outputStream, new Chunk("", this.contentFont));
        }
    }

    private void writeField(OutputStream outputStream) throws IOException {
        outputStream.write(123);
        outputStream.write(92);
        outputStream.write("v".getBytes());
        outputStream.write(123);
        outputStream.write(92);
        if (!this.hidePageNumber) {
            outputStream.write("tc".getBytes());
        } else {
            outputStream.write("tcn".getBytes());
        }
        outputStream.write(32);
        outputStream.write(RtfWriter.filterSpecialChar(this.entryName, true).getBytes());
        outputStream.write(32);
        outputStream.write(125);
        outputStream.write(125);
    }

    public void hideText() {
        this.hideText = true;
    }

    public void hidePageNumber() {
        this.hidePageNumber = true;
    }
}

