"""Generated message classes for datastore version v1.

Accesses the schemaless NoSQL database to provide fully managed, robust,
scalable storage for your application.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datastore'


class Aggregation(_messages.Message):
  r"""Defines an aggregation that produces a single result.

  Fields:
    alias: Optional. Optional name of the property to store the result of the
      aggregation. If not provided, Datastore will pick a default name
      following the format `property_`. For example: ``` AGGREGATE
      COUNT_UP_TO(1) AS count_up_to_1, COUNT_UP_TO(2), COUNT_UP_TO(3) AS
      count_up_to_3, COUNT(*) OVER ( ... ); ``` becomes: ``` AGGREGATE
      COUNT_UP_TO(1) AS count_up_to_1, COUNT_UP_TO(2) AS property_1,
      COUNT_UP_TO(3) AS count_up_to_3, COUNT(*) AS property_2 OVER ( ... );
      ``` Requires: * Must be unique across all aggregation aliases. * Conform
      to entity property name limitations.
    avg: Average aggregator.
    count: Count aggregator.
    sum: Sum aggregator.
  """

  alias = _messages.StringField(1)
  avg = _messages.MessageField('Avg', 2)
  count = _messages.MessageField('Count', 3)
  sum = _messages.MessageField('Sum', 4)


class AggregationQuery(_messages.Message):
  r"""Datastore query for running an aggregation over a Query.

  Fields:
    aggregations: Optional. Series of aggregations to apply over the results
      of the `nested_query`. Requires: * A minimum of one and maximum of five
      aggregations per query.
    nestedQuery: Nested query for aggregation
  """

  aggregations = _messages.MessageField('Aggregation', 1, repeated=True)
  nestedQuery = _messages.MessageField('Query', 2)


class AggregationResult(_messages.Message):
  r"""The result of a single bucket from a Datastore aggregation query. The
  keys of `aggregate_properties` are the same for all results in an
  aggregation query, unlike entity queries which can have different fields
  present for each result.

  Messages:
    AggregatePropertiesValue: The result of the aggregation functions, ex:
      `COUNT(*) AS total_entities`. The key is the alias assigned to the
      aggregation function on input and the size of this map equals the number
      of aggregation functions in the query.

  Fields:
    aggregateProperties: The result of the aggregation functions, ex:
      `COUNT(*) AS total_entities`. The key is the alias assigned to the
      aggregation function on input and the size of this map equals the number
      of aggregation functions in the query.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AggregatePropertiesValue(_messages.Message):
    r"""The result of the aggregation functions, ex: `COUNT(*) AS
    total_entities`. The key is the alias assigned to the aggregation function
    on input and the size of this map equals the number of aggregation
    functions in the query.

    Messages:
      AdditionalProperty: An additional property for a
        AggregatePropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type
        AggregatePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AggregatePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A Value attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Value', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aggregateProperties = _messages.MessageField('AggregatePropertiesValue', 1)


class AggregationResultBatch(_messages.Message):
  r"""A batch of aggregation results produced by an aggregation query.

  Enums:
    MoreResultsValueValuesEnum: The state of the query after the current
      batch. Only COUNT(*) aggregations are supported in the initial launch.
      Therefore, expected result type is limited to `NO_MORE_RESULTS`.

  Fields:
    aggregationResults: The aggregation results for this batch.
    moreResults: The state of the query after the current batch. Only COUNT(*)
      aggregations are supported in the initial launch. Therefore, expected
      result type is limited to `NO_MORE_RESULTS`.
    readTime: Read timestamp this batch was returned from. In a single
      transaction, subsequent query result batches for the same query can have
      a greater timestamp. Each batch's read timestamp is valid for all
      preceding batches.
  """

  class MoreResultsValueValuesEnum(_messages.Enum):
    r"""The state of the query after the current batch. Only COUNT(*)
    aggregations are supported in the initial launch. Therefore, expected
    result type is limited to `NO_MORE_RESULTS`.

    Values:
      MORE_RESULTS_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      NOT_FINISHED: There may be additional batches to fetch from this query.
      MORE_RESULTS_AFTER_LIMIT: The query is finished, but there may be more
        results after the limit.
      MORE_RESULTS_AFTER_CURSOR: The query is finished, but there may be more
        results after the end cursor.
      NO_MORE_RESULTS: The query is finished, and there are no more results.
    """
    MORE_RESULTS_TYPE_UNSPECIFIED = 0
    NOT_FINISHED = 1
    MORE_RESULTS_AFTER_LIMIT = 2
    MORE_RESULTS_AFTER_CURSOR = 3
    NO_MORE_RESULTS = 4

  aggregationResults = _messages.MessageField('AggregationResult', 1, repeated=True)
  moreResults = _messages.EnumField('MoreResultsValueValuesEnum', 2)
  readTime = _messages.StringField(3)


class AllocateIdsRequest(_messages.Message):
  r"""The request for Datastore.AllocateIds.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    keys: Required. A list of keys with incomplete key paths for which to
      allocate IDs. No key may be reserved/read-only.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)


class AllocateIdsResponse(_messages.Message):
  r"""The response for Datastore.AllocateIds.

  Fields:
    keys: The keys specified in the request (in the same order), each with its
      key path completed with a newly allocated ID.
  """

  keys = _messages.MessageField('Key', 1, repeated=True)


class ArrayValue(_messages.Message):
  r"""An array value.

  Fields:
    values: Values in the array. The order of values in an array is preserved
      as long as all values have identical settings for
      'exclude_from_indexes'.
  """

  values = _messages.MessageField('Value', 1, repeated=True)


class Avg(_messages.Message):
  r"""Average of the values of the requested property. * Only numeric values
  will be aggregated. All non-numeric values including `NULL` are skipped. *
  If the aggregated values contain `NaN`, returns `NaN`. Infinity math follows
  IEEE-754 standards. * If the aggregated value set is empty, returns `NULL`.
  * Always returns the result as a double.

  Fields:
    property: The property to aggregate on.
  """

  property = _messages.MessageField('PropertyReference', 1)


class BeginTransactionRequest(_messages.Message):
  r"""The request for Datastore.BeginTransaction.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    transactionOptions: Options for a new transaction.
  """

  databaseId = _messages.StringField(1)
  transactionOptions = _messages.MessageField('TransactionOptions', 2)


class BeginTransactionResponse(_messages.Message):
  r"""The response for Datastore.BeginTransaction.

  Fields:
    transaction: The transaction identifier (always present).
  """

  transaction = _messages.BytesField(1)


class CommitRequest(_messages.Message):
  r"""The request for Datastore.Commit.

  Enums:
    ModeValueValuesEnum: The type of commit to perform. Defaults to
      `TRANSACTIONAL`.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    mode: The type of commit to perform. Defaults to `TRANSACTIONAL`.
    mutations: The mutations to perform. When mode is `TRANSACTIONAL`,
      mutations affecting a single entity are applied in order. The following
      sequences of mutations affecting a single entity are not permitted in a
      single `Commit` request: - `insert` followed by `insert` - `update`
      followed by `insert` - `upsert` followed by `insert` - `delete` followed
      by `update` When mode is `NON_TRANSACTIONAL`, no two mutations may
      affect a single entity.
    singleUseTransaction: Options for beginning a new transaction for this
      request. The transaction is committed when the request completes. If
      specified, TransactionOptions.mode must be TransactionOptions.ReadWrite.
    transaction: The identifier of the transaction associated with the commit.
      A transaction identifier is returned by a call to
      Datastore.BeginTransaction.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The type of commit to perform. Defaults to `TRANSACTIONAL`.

    Values:
      MODE_UNSPECIFIED: Unspecified. This value must not be used.
      TRANSACTIONAL: Transactional: The mutations are either all applied, or
        none are applied. Learn about transactions
        [here](https://cloud.google.com/datastore/docs/concepts/transactions).
      NON_TRANSACTIONAL: Non-transactional: The mutations may not apply as all
        or none.
    """
    MODE_UNSPECIFIED = 0
    TRANSACTIONAL = 1
    NON_TRANSACTIONAL = 2

  databaseId = _messages.StringField(1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  mutations = _messages.MessageField('Mutation', 3, repeated=True)
  singleUseTransaction = _messages.MessageField('TransactionOptions', 4)
  transaction = _messages.BytesField(5)


class CommitResponse(_messages.Message):
  r"""The response for Datastore.Commit.

  Fields:
    commitTime: The transaction commit timestamp. Not set for non-
      transactional commits.
    indexUpdates: The number of index entries updated during the commit, or
      zero if none were updated.
    mutationResults: The result of performing the mutations. The i-th mutation
      result corresponds to the i-th mutation in the request.
  """

  commitTime = _messages.StringField(1)
  indexUpdates = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  mutationResults = _messages.MessageField('MutationResult', 3, repeated=True)


class CompositeFilter(_messages.Message):
  r"""A filter that merges multiple other filters using the given operator.

  Enums:
    OpValueValuesEnum: The operator for combining multiple filters.

  Fields:
    filters: The list of filters to combine. Requires: * At least one filter
      is present.
    op: The operator for combining multiple filters.
  """

  class OpValueValuesEnum(_messages.Enum):
    r"""The operator for combining multiple filters.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      AND: The results are required to satisfy each of the combined filters.
      OR: Documents are required to satisfy at least one of the combined
        filters.
    """
    OPERATOR_UNSPECIFIED = 0
    AND = 1
    OR = 2

  filters = _messages.MessageField('Filter', 1, repeated=True)
  op = _messages.EnumField('OpValueValuesEnum', 2)


class Count(_messages.Message):
  r"""Count of entities that match the query. The `COUNT(*)` aggregation
  function operates on the entire entity so it does not require a field
  reference.

  Fields:
    upTo: Optional. Optional constraint on the maximum number of entities to
      count. This provides a way to set an upper bound on the number of
      entities to scan, limiting latency, and cost. Unspecified is interpreted
      as no bound. If a zero value is provided, a count result of zero should
      always be expected. High-Level Example: ``` AGGREGATE COUNT_UP_TO(1000)
      OVER ( SELECT * FROM k ); ``` Requires: * Must be non-negative when
      present.
  """

  upTo = _messages.IntegerField(1)


class DatastoreProjectsAllocateIdsRequest(_messages.Message):
  r"""A DatastoreProjectsAllocateIdsRequest object.

  Fields:
    allocateIdsRequest: A AllocateIdsRequest resource to be passed as the
      request body.
    projectId: Required. The ID of the project against which to make the
      request.
  """

  allocateIdsRequest = _messages.MessageField('AllocateIdsRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsBeginTransactionRequest(_messages.Message):
  r"""A DatastoreProjectsBeginTransactionRequest object.

  Fields:
    beginTransactionRequest: A BeginTransactionRequest resource to be passed
      as the request body.
    projectId: Required. The ID of the project against which to make the
      request.
  """

  beginTransactionRequest = _messages.MessageField('BeginTransactionRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsCommitRequest(_messages.Message):
  r"""A DatastoreProjectsCommitRequest object.

  Fields:
    commitRequest: A CommitRequest resource to be passed as the request body.
    projectId: Required. The ID of the project against which to make the
      request.
  """

  commitRequest = _messages.MessageField('CommitRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsExportRequest(_messages.Message):
  r"""A DatastoreProjectsExportRequest object.

  Fields:
    googleDatastoreAdminV1ExportEntitiesRequest: A
      GoogleDatastoreAdminV1ExportEntitiesRequest resource to be passed as the
      request body.
    projectId: Required. Project ID against which to make the request.
  """

  googleDatastoreAdminV1ExportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1ExportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsImportRequest(_messages.Message):
  r"""A DatastoreProjectsImportRequest object.

  Fields:
    googleDatastoreAdminV1ImportEntitiesRequest: A
      GoogleDatastoreAdminV1ImportEntitiesRequest resource to be passed as the
      request body.
    projectId: Required. Project ID against which to make the request.
  """

  googleDatastoreAdminV1ImportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1ImportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesDeleteRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesDeleteRequest object.

  Fields:
    indexId: The resource ID of the index to delete.
    projectId: Project ID against which to make the request.
  """

  indexId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesGetRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesGetRequest object.

  Fields:
    indexId: The resource ID of the index to get.
    projectId: Project ID against which to make the request.
  """

  indexId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesListRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesListRequest object.

  Fields:
    filter: A string attribute.
    pageSize: The maximum number of items to return. If zero, then all results
      will be returned.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    projectId: Project ID against which to make the request.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class DatastoreProjectsLookupRequest(_messages.Message):
  r"""A DatastoreProjectsLookupRequest object.

  Fields:
    lookupRequest: A LookupRequest resource to be passed as the request body.
    projectId: Required. The ID of the project against which to make the
      request.
  """

  lookupRequest = _messages.MessageField('LookupRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsOperationsCancelRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsDeleteRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsGetRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsListRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DatastoreProjectsReserveIdsRequest(_messages.Message):
  r"""A DatastoreProjectsReserveIdsRequest object.

  Fields:
    projectId: Required. The ID of the project against which to make the
      request.
    reserveIdsRequest: A ReserveIdsRequest resource to be passed as the
      request body.
  """

  projectId = _messages.StringField(1, required=True)
  reserveIdsRequest = _messages.MessageField('ReserveIdsRequest', 2)


class DatastoreProjectsRollbackRequest(_messages.Message):
  r"""A DatastoreProjectsRollbackRequest object.

  Fields:
    projectId: Required. The ID of the project against which to make the
      request.
    rollbackRequest: A RollbackRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  rollbackRequest = _messages.MessageField('RollbackRequest', 2)


class DatastoreProjectsRunAggregationQueryRequest(_messages.Message):
  r"""A DatastoreProjectsRunAggregationQueryRequest object.

  Fields:
    projectId: Required. The ID of the project against which to make the
      request.
    runAggregationQueryRequest: A RunAggregationQueryRequest resource to be
      passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  runAggregationQueryRequest = _messages.MessageField('RunAggregationQueryRequest', 2)


class DatastoreProjectsRunQueryRequest(_messages.Message):
  r"""A DatastoreProjectsRunQueryRequest object.

  Fields:
    projectId: Required. The ID of the project against which to make the
      request.
    runQueryRequest: A RunQueryRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  runQueryRequest = _messages.MessageField('RunQueryRequest', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Entity(_messages.Message):
  r"""A Datastore data object. Must not exceed 1 MiB - 4 bytes.

  Messages:
    PropertiesValue: The entity's properties. The map's keys are property
      names. A property name matching regex `__.*__` is reserved. A reserved
      property name is forbidden in certain documented contexts. The map keys,
      represented as UTF-8, must not exceed 1,500 bytes and cannot be empty.

  Fields:
    key: The entity's key. An entity must have a key, unless otherwise
      documented (for example, an entity in `Value.entity_value` may have no
      key). An entity's kind is its key path's last element's kind, or null if
      it has no key.
    properties: The entity's properties. The map's keys are property names. A
      property name matching regex `__.*__` is reserved. A reserved property
      name is forbidden in certain documented contexts. The map keys,
      represented as UTF-8, must not exceed 1,500 bytes and cannot be empty.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""The entity's properties. The map's keys are property names. A property
    name matching regex `__.*__` is reserved. A reserved property name is
    forbidden in certain documented contexts. The map keys, represented as
    UTF-8, must not exceed 1,500 bytes and cannot be empty.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A Value attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Value', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  key = _messages.MessageField('Key', 1)
  properties = _messages.MessageField('PropertiesValue', 2)


class EntityResult(_messages.Message):
  r"""The result of fetching an entity from Datastore.

  Fields:
    createTime: The time at which the entity was created. This field is set
      for `FULL` entity results. If this entity is missing, this field will
      not be set.
    cursor: A cursor that points to the position after the result entity. Set
      only when the `EntityResult` is part of a `QueryResultBatch` message.
    entity: The resulting entity.
    updateTime: The time at which the entity was last changed. This field is
      set for `FULL` entity results. If this entity is missing, this field
      will not be set.
    version: The version of the entity, a strictly positive number that
      monotonically increases with changes to the entity. This field is set
      for `FULL` entity results. For missing entities in `LookupResponse`,
      this is the version of the snapshot that was used to look up the entity,
      and it is always set except for eventually consistent reads.
  """

  createTime = _messages.StringField(1)
  cursor = _messages.BytesField(2)
  entity = _messages.MessageField('Entity', 3)
  updateTime = _messages.StringField(4)
  version = _messages.IntegerField(5)


class ExecutionStats(_messages.Message):
  r"""Execution statistics for the query.

  Messages:
    DebugStatsValue: Debugging statistics from the execution of the query.
      Note that the debugging stats are subject to change as Firestore
      evolves. It could include: { "indexes_entries_scanned": "1000",
      "documents_scanned": "20", "billing_details" : { "documents_billable":
      "20", "index_entries_billable": "1000", "min_query_cost": "0" } }

  Fields:
    debugStats: Debugging statistics from the execution of the query. Note
      that the debugging stats are subject to change as Firestore evolves. It
      could include: { "indexes_entries_scanned": "1000", "documents_scanned":
      "20", "billing_details" : { "documents_billable": "20",
      "index_entries_billable": "1000", "min_query_cost": "0" } }
    executionDuration: Total time to execute the query in the backend.
    readOperations: Total billable read operations.
    resultsReturned: Total number of results returned, including documents,
      projections, aggregation results, keys.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DebugStatsValue(_messages.Message):
    r"""Debugging statistics from the execution of the query. Note that the
    debugging stats are subject to change as Firestore evolves. It could
    include: { "indexes_entries_scanned": "1000", "documents_scanned": "20",
    "billing_details" : { "documents_billable": "20",
    "index_entries_billable": "1000", "min_query_cost": "0" } }

    Messages:
      AdditionalProperty: An additional property for a DebugStatsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DebugStatsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  debugStats = _messages.MessageField('DebugStatsValue', 1)
  executionDuration = _messages.StringField(2)
  readOperations = _messages.IntegerField(3)
  resultsReturned = _messages.IntegerField(4)


class ExplainMetrics(_messages.Message):
  r"""Explain metrics for the query.

  Fields:
    executionStats: Aggregated stats from the execution of the query. Only
      present when ExplainOptions.analyze is set to true.
    planSummary: Planning phase information for the query.
  """

  executionStats = _messages.MessageField('ExecutionStats', 1)
  planSummary = _messages.MessageField('PlanSummary', 2)


class ExplainOptions(_messages.Message):
  r"""Explain options for the query.

  Fields:
    analyze: Optional. Whether to execute this query. When false (the
      default), the query will be planned, returning only metrics from the
      planning stages. When true, the query will be planned and executed,
      returning the full query results along with both planning and execution
      stage metrics.
  """

  analyze = _messages.BooleanField(1)


class Filter(_messages.Message):
  r"""A holder for any type of filter.

  Fields:
    compositeFilter: A composite filter.
    propertyFilter: A filter on a property.
  """

  compositeFilter = _messages.MessageField('CompositeFilter', 1)
  propertyFilter = _messages.MessageField('PropertyFilter', 2)


class FindNearest(_messages.Message):
  r"""Nearest Neighbors search config. The ordering provided by FindNearest
  supersedes the order_by stage. If multiple documents have the same vector
  distance, the returned document order is not guaranteed to be stable between
  queries.

  Enums:
    DistanceMeasureValueValuesEnum: Required. The Distance Measure to use,
      required.

  Fields:
    distanceMeasure: Required. The Distance Measure to use, required.
    distanceResultProperty: Optional. Optional name of the field to output the
      result of the vector distance calculation. Must conform to entity
      property limitations.
    distanceThreshold: Optional. Option to specify a threshold for which no
      less similar documents will be returned. The behavior of the specified
      `distance_measure` will affect the meaning of the distance threshold.
      Since DOT_PRODUCT distances increase when the vectors are more similar,
      the comparison is inverted. * For EUCLIDEAN, COSINE: WHERE distance <=
      distance_threshold * For DOT_PRODUCT: WHERE distance >=
      distance_threshold
    limit: Required. The number of nearest neighbors to return. Must be a
      positive integer of no more than 100.
    queryVector: Required. The query vector that we are searching on. Must be
      a vector of no more than 2048 dimensions.
    vectorProperty: Required. An indexed vector property to search upon. Only
      documents which contain vectors whose dimensionality match the
      query_vector can be returned.
  """

  class DistanceMeasureValueValuesEnum(_messages.Enum):
    r"""Required. The Distance Measure to use, required.

    Values:
      DISTANCE_MEASURE_UNSPECIFIED: Should not be set.
      EUCLIDEAN: Measures the EUCLIDEAN distance between the vectors. See
        [Euclidean](https://en.wikipedia.org/wiki/Euclidean_distance) to learn
        more. The resulting distance decreases the more similar two vectors
        are.
      COSINE: COSINE distance compares vectors based on the angle between
        them, which allows you to measure similarity that isn't based on the
        vectors magnitude. We recommend using DOT_PRODUCT with unit normalized
        vectors instead of COSINE distance, which is mathematically equivalent
        with better performance. See [Cosine
        Similarity](https://en.wikipedia.org/wiki/Cosine_similarity) to learn
        more about COSINE similarity and COSINE distance. The resulting COSINE
        distance decreases the more similar two vectors are.
      DOT_PRODUCT: Similar to cosine but is affected by the magnitude of the
        vectors. See [Dot Product](https://en.wikipedia.org/wiki/Dot_product)
        to learn more. The resulting distance increases the more similar two
        vectors are.
    """
    DISTANCE_MEASURE_UNSPECIFIED = 0
    EUCLIDEAN = 1
    COSINE = 2
    DOT_PRODUCT = 3

  distanceMeasure = _messages.EnumField('DistanceMeasureValueValuesEnum', 1)
  distanceResultProperty = _messages.StringField(2)
  distanceThreshold = _messages.FloatField(3)
  limit = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  queryVector = _messages.MessageField('Value', 5)
  vectorProperty = _messages.MessageField('PropertyReference', 6)


class GoogleDatastoreAdminV1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
      CREATE_INDEX: CreateIndex.
      DELETE_INDEX: DeleteIndex.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2
    CREATE_INDEX = 3
    DELETE_INDEX = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1DatastoreFirestoreMigrationMetadata(_messages.Message):
  r"""Metadata for Datastore to Firestore migration operations. The
  DatastoreFirestoreMigration operation is not started by the end-user via an
  explicit "creation" method. This is an intentional deviation from the LRO
  design pattern. This singleton resource can be accessed at:
  "projects/{project_id}/operations/datastore-firestore-migration"

  Enums:
    MigrationStateValueValuesEnum: The current state of migration from Cloud
      Datastore to Cloud Firestore in Datastore mode.
    MigrationStepValueValuesEnum: The current step of migration from Cloud
      Datastore to Cloud Firestore in Datastore mode.

  Fields:
    migrationState: The current state of migration from Cloud Datastore to
      Cloud Firestore in Datastore mode.
    migrationStep: The current step of migration from Cloud Datastore to Cloud
      Firestore in Datastore mode.
  """

  class MigrationStateValueValuesEnum(_messages.Enum):
    r"""The current state of migration from Cloud Datastore to Cloud Firestore
    in Datastore mode.

    Values:
      MIGRATION_STATE_UNSPECIFIED: Unspecified.
      RUNNING: The migration is running.
      PAUSED: The migration is paused.
      COMPLETE: The migration is complete.
    """
    MIGRATION_STATE_UNSPECIFIED = 0
    RUNNING = 1
    PAUSED = 2
    COMPLETE = 3

  class MigrationStepValueValuesEnum(_messages.Enum):
    r"""The current step of migration from Cloud Datastore to Cloud Firestore
    in Datastore mode.

    Values:
      MIGRATION_STEP_UNSPECIFIED: Unspecified.
      PREPARE: Pre-migration: the database is prepared for migration.
      START: Start of migration.
      APPLY_WRITES_SYNCHRONOUSLY: Writes are applied synchronously to at least
        one replica.
      COPY_AND_VERIFY: Data is copied to Cloud Firestore and then verified to
        match the data in Cloud Datastore.
      REDIRECT_EVENTUALLY_CONSISTENT_READS: Eventually-consistent reads are
        redirected to Cloud Firestore.
      REDIRECT_STRONGLY_CONSISTENT_READS: Strongly-consistent reads are
        redirected to Cloud Firestore.
      REDIRECT_WRITES: Writes are redirected to Cloud Firestore.
    """
    MIGRATION_STEP_UNSPECIFIED = 0
    PREPARE = 1
    START = 2
    APPLY_WRITES_SYNCHRONOUSLY = 3
    COPY_AND_VERIFY = 4
    REDIRECT_EVENTUALLY_CONSISTENT_READS = 5
    REDIRECT_STRONGLY_CONSISTENT_READS = 6
    REDIRECT_WRITES = 7

  migrationState = _messages.EnumField('MigrationStateValueValuesEnum', 1)
  migrationStep = _messages.EnumField('MigrationStepValueValuesEnum', 2)


class GoogleDatastoreAdminV1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage: Entire project:
  kinds=[], namespace_ids=[] Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar only in the default
  namespace: kinds=['Foo', 'Bar'], namespace_ids=[''] Kinds Foo and Bar in
  both the default and Baz namespaces: kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz'] The entire Baz namespace: kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces. An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix field.
      The final output location is provided in
      google.datastore.admin.v1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1ExportEntitiesRequest(_messages.Message):
  r"""The request for google.datastore.admin.v1.DatastoreAdmin.ExportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Description of what data from the project is included in the
      export.
    labels: Client-assigned labels.
    outputUrlPrefix: Required. Location for the export metadata and data
      files. The full resource URL of the external storage location.
      Currently, only Google Cloud Storage is supported. So output_url_prefix
      should be of the form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where
      `BUCKET_NAME` is the name of the Cloud Storage bucket and
      `NAMESPACE_PATH` is an optional Cloud Storage namespace path (this is
      not a Cloud Datastore namespace). For more information about Cloud
      Storage namespace paths, see [Object name
      considerations](https://cloud.google.com/storage/docs/naming#object-
      considerations). The resulting files will be nested deeper than the
      specified URL prefix. The final output URL will be provided in the
      google.datastore.admin.v1.ExportEntitiesResponse.output_url field. That
      value should be used for subsequent ImportEntities operations. By
      nesting the data files deeper, the same Cloud Storage bucket can be used
      in multiple ExportEntities operations without conflict.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  outputUrlPrefix = _messages.StringField(3)


class GoogleDatastoreAdminV1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1.ImportEntitiesRequest.input_url. Only present
      if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the google.datastore.admin.v1.ExportEntitiesResponse.output_url
      field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1ImportEntitiesRequest(_messages.Message):
  r"""The request for google.datastore.admin.v1.DatastoreAdmin.ImportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Optionally specify which kinds/namespaces are to be
      imported. If provided, the list must be a subset of the EntityFilter
      used in creating the export, otherwise a FAILED_PRECONDITION error will
      be returned. If no filter is specified then all entities from the export
      are imported.
    inputUrl: Required. The full resource URL of the external storage
      location. Currently, only Google Cloud Storage is supported. So
      input_url should be of the form:
      `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
      `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH`
      is an optional Cloud Storage namespace path (this is not a Cloud
      Datastore namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata
      file written by the ExportEntities operation. For more information about
      Cloud Storage namespace paths, see [Object name
      considerations](https://cloud.google.com/storage/docs/naming#object-
      considerations). For more information, see
      google.datastore.admin.v1.ExportEntitiesResponse.output_url.
    labels: Client-assigned labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 1)
  inputUrl = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)


class GoogleDatastoreAdminV1Index(_messages.Message):
  r"""Datastore composite index definition.

  Enums:
    AncestorValueValuesEnum: Required. The index's ancestor mode. Must not be
      ANCESTOR_MODE_UNSPECIFIED.
    StateValueValuesEnum: Output only. The state of the index.

  Fields:
    ancestor: Required. The index's ancestor mode. Must not be
      ANCESTOR_MODE_UNSPECIFIED.
    indexId: Output only. The resource ID of the index.
    kind: Required. The entity kind to which this index applies.
    projectId: Output only. Project ID.
    properties: Required. An ordered sequence of property names and their
      index attributes. Requires: * A maximum of 100 properties.
    state: Output only. The state of the index.
  """

  class AncestorValueValuesEnum(_messages.Enum):
    r"""Required. The index's ancestor mode. Must not be
    ANCESTOR_MODE_UNSPECIFIED.

    Values:
      ANCESTOR_MODE_UNSPECIFIED: The ancestor mode is unspecified.
      NONE: Do not include the entity's ancestors in the index.
      ALL_ANCESTORS: Include all the entity's ancestors in the index.
    """
    ANCESTOR_MODE_UNSPECIFIED = 0
    NONE = 1
    ALL_ANCESTORS = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the index.

    Values:
      STATE_UNSPECIFIED: The state is unspecified.
      CREATING: The index is being created, and cannot be used by queries.
        There is an active long-running operation for the index. The index is
        updated when writing an entity. Some index data may exist.
      READY: The index is ready to be used. The index is updated when writing
        an entity. The index is fully populated from all stored entities it
        applies to.
      DELETING: The index is being deleted, and cannot be used by queries.
        There is an active long-running operation for the index. The index is
        not updated when writing an entity. Some index data may exist.
      ERROR: The index was being created or deleted, but something went wrong.
        The index cannot by used by queries. There is no active long-running
        operation for the index, and the most recently finished long-running
        operation failed. The index is not updated when writing an entity.
        Some index data may exist.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    ERROR = 4

  ancestor = _messages.EnumField('AncestorValueValuesEnum', 1)
  indexId = _messages.StringField(2)
  kind = _messages.StringField(3)
  projectId = _messages.StringField(4)
  properties = _messages.MessageField('GoogleDatastoreAdminV1IndexedProperty', 5, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleDatastoreAdminV1IndexOperationMetadata(_messages.Message):
  r"""Metadata for Index operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    indexId: The index resource ID that this operation is acting on.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  indexId = _messages.StringField(2)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 3)


class GoogleDatastoreAdminV1IndexedProperty(_messages.Message):
  r"""A property of an index.

  Enums:
    DirectionValueValuesEnum: Required. The indexed property's direction. Must
      not be DIRECTION_UNSPECIFIED.

  Fields:
    direction: Required. The indexed property's direction. Must not be
      DIRECTION_UNSPECIFIED.
    name: Required. The property name to index.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""Required. The indexed property's direction. Must not be
    DIRECTION_UNSPECIFIED.

    Values:
      DIRECTION_UNSPECIFIED: The direction is unspecified.
      ASCENDING: The property's values are indexed so as to support sequencing
        in ascending order and also query by <, >, <=, >=, and =.
      DESCENDING: The property's values are indexed so as to support
        sequencing in descending order and also query by <, >, <=, >=, and =.
    """
    DIRECTION_UNSPECIFIED = 0
    ASCENDING = 1
    DESCENDING = 2

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  name = _messages.StringField(2)


class GoogleDatastoreAdminV1ListIndexesResponse(_messages.Message):
  r"""The response for google.datastore.admin.v1.DatastoreAdmin.ListIndexes.

  Fields:
    indexes: The indexes.
    nextPageToken: The standard List next-page token.
  """

  indexes = _messages.MessageField('GoogleDatastoreAdminV1Index', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleDatastoreAdminV1MigrationProgressEvent(_messages.Message):
  r"""An event signifying the start of a new step in a [migration from Cloud
  Datastore to Cloud Firestore in Datastore
  mode](https://cloud.google.com/datastore/docs/upgrade-to-firestore).

  Enums:
    StepValueValuesEnum: The step that is starting. An event with step set to
      `START` indicates that the migration has been reverted back to the
      initial pre-migration state.

  Fields:
    prepareStepDetails: Details for the `PREPARE` step.
    redirectWritesStepDetails: Details for the `REDIRECT_WRITES` step.
    step: The step that is starting. An event with step set to `START`
      indicates that the migration has been reverted back to the initial pre-
      migration state.
  """

  class StepValueValuesEnum(_messages.Enum):
    r"""The step that is starting. An event with step set to `START` indicates
    that the migration has been reverted back to the initial pre-migration
    state.

    Values:
      MIGRATION_STEP_UNSPECIFIED: Unspecified.
      PREPARE: Pre-migration: the database is prepared for migration.
      START: Start of migration.
      APPLY_WRITES_SYNCHRONOUSLY: Writes are applied synchronously to at least
        one replica.
      COPY_AND_VERIFY: Data is copied to Cloud Firestore and then verified to
        match the data in Cloud Datastore.
      REDIRECT_EVENTUALLY_CONSISTENT_READS: Eventually-consistent reads are
        redirected to Cloud Firestore.
      REDIRECT_STRONGLY_CONSISTENT_READS: Strongly-consistent reads are
        redirected to Cloud Firestore.
      REDIRECT_WRITES: Writes are redirected to Cloud Firestore.
    """
    MIGRATION_STEP_UNSPECIFIED = 0
    PREPARE = 1
    START = 2
    APPLY_WRITES_SYNCHRONOUSLY = 3
    COPY_AND_VERIFY = 4
    REDIRECT_EVENTUALLY_CONSISTENT_READS = 5
    REDIRECT_STRONGLY_CONSISTENT_READS = 6
    REDIRECT_WRITES = 7

  prepareStepDetails = _messages.MessageField('GoogleDatastoreAdminV1PrepareStepDetails', 1)
  redirectWritesStepDetails = _messages.MessageField('GoogleDatastoreAdminV1RedirectWritesStepDetails', 2)
  step = _messages.EnumField('StepValueValuesEnum', 3)


class GoogleDatastoreAdminV1MigrationStateEvent(_messages.Message):
  r"""An event signifying a change in state of a [migration from Cloud
  Datastore to Cloud Firestore in Datastore
  mode](https://cloud.google.com/datastore/docs/upgrade-to-firestore).

  Enums:
    StateValueValuesEnum: The new state of the migration.

  Fields:
    state: The new state of the migration.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The new state of the migration.

    Values:
      MIGRATION_STATE_UNSPECIFIED: Unspecified.
      RUNNING: The migration is running.
      PAUSED: The migration is paused.
      COMPLETE: The migration is complete.
    """
    MIGRATION_STATE_UNSPECIFIED = 0
    RUNNING = 1
    PAUSED = 2
    COMPLETE = 3

  state = _messages.EnumField('StateValueValuesEnum', 1)


class GoogleDatastoreAdminV1PrepareStepDetails(_messages.Message):
  r"""Details for the `PREPARE` step.

  Enums:
    ConcurrencyModeValueValuesEnum: The concurrency mode this database will
      use when it reaches the `REDIRECT_WRITES` step.

  Fields:
    concurrencyMode: The concurrency mode this database will use when it
      reaches the `REDIRECT_WRITES` step.
  """

  class ConcurrencyModeValueValuesEnum(_messages.Enum):
    r"""The concurrency mode this database will use when it reaches the
    `REDIRECT_WRITES` step.

    Values:
      CONCURRENCY_MODE_UNSPECIFIED: Unspecified.
      PESSIMISTIC: Pessimistic concurrency.
      OPTIMISTIC: Optimistic concurrency.
      OPTIMISTIC_WITH_ENTITY_GROUPS: Optimistic concurrency with entity
        groups.
    """
    CONCURRENCY_MODE_UNSPECIFIED = 0
    PESSIMISTIC = 1
    OPTIMISTIC = 2
    OPTIMISTIC_WITH_ENTITY_GROUPS = 3

  concurrencyMode = _messages.EnumField('ConcurrencyModeValueValuesEnum', 1)


class GoogleDatastoreAdminV1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleDatastoreAdminV1RedirectWritesStepDetails(_messages.Message):
  r"""Details for the `REDIRECT_WRITES` step.

  Enums:
    ConcurrencyModeValueValuesEnum: Ths concurrency mode for this database.

  Fields:
    concurrencyMode: Ths concurrency mode for this database.
  """

  class ConcurrencyModeValueValuesEnum(_messages.Enum):
    r"""Ths concurrency mode for this database.

    Values:
      CONCURRENCY_MODE_UNSPECIFIED: Unspecified.
      PESSIMISTIC: Pessimistic concurrency.
      OPTIMISTIC: Optimistic concurrency.
      OPTIMISTIC_WITH_ENTITY_GROUPS: Optimistic concurrency with entity
        groups.
    """
    CONCURRENCY_MODE_UNSPECIFIED = 0
    PESSIMISTIC = 1
    OPTIMISTIC = 2
    OPTIMISTIC_WITH_ENTITY_GROUPS = 3

  concurrencyMode = _messages.EnumField('ConcurrencyModeValueValuesEnum', 1)


class GoogleDatastoreAdminV1beta1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1beta1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage: Entire project:
  kinds=[], namespace_ids=[] Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar only in the default
  namespace: kinds=['Foo', 'Bar'], namespace_ids=[''] Kinds Foo and Bar in
  both the default and Baz namespaces: kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz'] The entire Baz namespace: kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces. An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1beta1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1beta1.ExportEntitiesRequest.output_url_prefix
      field. The final output location is provided in
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1beta1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1beta1.ImportEntitiesRequest.input_url. Only
      present if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1beta1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GqlQuery(_messages.Message):
  r"""A [GQL
  query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).

  Messages:
    NamedBindingsValue: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse. Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.

  Fields:
    allowLiterals: When false, the query string must not contain any literals
      and instead must bind all values. For example, `SELECT * FROM Kind WHERE
      a = 'string literal'` is not allowed, while `SELECT * FROM Kind WHERE a
      = @value` is.
    namedBindings: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse. Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.
    positionalBindings: Numbered binding site @1 references the first numbered
      parameter, effectively using 1-based indexing, rather than the usual 0.
      For each binding site numbered i in `query_string`, there must be an
      i-th numbered parameter. The inverse must also be true.
    queryString: A string of the format described
      [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NamedBindingsValue(_messages.Message):
    r"""For each non-reserved named binding site in the query string, there
    must be a named parameter with that name, but not necessarily the inverse.
    Key must match regex `A-Za-z_$*`, must not match regex `__.*__`, and must
    not be `""`.

    Messages:
      AdditionalProperty: An additional property for a NamedBindingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type NamedBindingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NamedBindingsValue object.

      Fields:
        key: Name of the additional property.
        value: A GqlQueryParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GqlQueryParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowLiterals = _messages.BooleanField(1)
  namedBindings = _messages.MessageField('NamedBindingsValue', 2)
  positionalBindings = _messages.MessageField('GqlQueryParameter', 3, repeated=True)
  queryString = _messages.StringField(4)


class GqlQueryParameter(_messages.Message):
  r"""A binding parameter for a GQL query.

  Fields:
    cursor: A query cursor. Query cursors are returned in query result
      batches.
    value: A value parameter.
  """

  cursor = _messages.BytesField(1)
  value = _messages.MessageField('Value', 2)


class Key(_messages.Message):
  r"""A unique identifier for an entity. If a key's partition ID or any of its
  path kinds or names are reserved/read-only, the key is reserved/read-only. A
  reserved/read-only key is forbidden in certain documented contexts.

  Fields:
    partitionId: Entities are partitioned into subsets, currently identified
      by a project ID and namespace ID. Queries are scoped to a single
      partition.
    path: The entity path. An entity path consists of one or more elements
      composed of a kind and a string or numerical identifier, which identify
      entities. The first element identifies a _root entity_, the second
      element identifies a _child_ of the root entity, the third element
      identifies a child of the second entity, and so forth. The entities
      identified by all prefixes of the path are called the element's
      _ancestors_. An entity path is always fully complete: *all* of the
      entity's ancestors are required to be in the path along with the entity
      identifier itself. The only exception is that in some documented cases,
      the identifier in the last path element (for the entity) itself may be
      omitted. For example, the last path element of the key of
      `Mutation.insert` may have no identifier. A path can never be empty, and
      a path can have at most 100 elements.
  """

  partitionId = _messages.MessageField('PartitionId', 1)
  path = _messages.MessageField('PathElement', 2, repeated=True)


class KindExpression(_messages.Message):
  r"""A representation of a kind.

  Fields:
    name: The name of the kind.
  """

  name = _messages.StringField(1)


class LatLng(_messages.Message):
  r"""An object that represents a latitude/longitude pair. This is expressed
  as a pair of doubles to represent degrees latitude and degrees longitude.
  Unless specified otherwise, this object must conform to the WGS84 standard.
  Values must be within normalized ranges.

  Fields:
    latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
    longitude: The longitude in degrees. It must be in the range [-180.0,
      +180.0].
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class LookupRequest(_messages.Message):
  r"""The request for Datastore.Lookup.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    keys: Required. Keys of entities to look up.
    propertyMask: The properties to return. Defaults to returning all
      properties. If this field is set and an entity has a property not
      referenced in the mask, it will be absent from
      LookupResponse.found.entity.properties. The entity's key is always
      returned.
    readOptions: The options for this lookup request.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)
  propertyMask = _messages.MessageField('PropertyMask', 3)
  readOptions = _messages.MessageField('ReadOptions', 4)


class LookupResponse(_messages.Message):
  r"""The response for Datastore.Lookup.

  Fields:
    deferred: A list of keys that were not looked up due to resource
      constraints. The order of results in this field is undefined and has no
      relation to the order of the keys in the input.
    found: Entities found as `ResultType.FULL` entities. The order of results
      in this field is undefined and has no relation to the order of the keys
      in the input.
    missing: Entities not found as `ResultType.KEY_ONLY` entities. The order
      of results in this field is undefined and has no relation to the order
      of the keys in the input.
    readTime: The time at which these entities were read or found missing.
    transaction: The identifier of the transaction that was started as part of
      this Lookup request. Set only when ReadOptions.new_transaction was set
      in LookupRequest.read_options.
  """

  deferred = _messages.MessageField('Key', 1, repeated=True)
  found = _messages.MessageField('EntityResult', 2, repeated=True)
  missing = _messages.MessageField('EntityResult', 3, repeated=True)
  readTime = _messages.StringField(4)
  transaction = _messages.BytesField(5)


class Mutation(_messages.Message):
  r"""A mutation to apply to an entity.

  Enums:
    ConflictResolutionStrategyValueValuesEnum: The strategy to use when a
      conflict is detected. Defaults to `SERVER_VALUE`. If this is set, then
      `conflict_detection_strategy` must also be set.

  Fields:
    baseVersion: The version of the entity that this mutation is being applied
      to. If this does not match the current version on the server, the
      mutation conflicts.
    conflictResolutionStrategy: The strategy to use when a conflict is
      detected. Defaults to `SERVER_VALUE`. If this is set, then
      `conflict_detection_strategy` must also be set.
    delete: The key of the entity to delete. The entity may or may not already
      exist. Must have a complete key path and must not be reserved/read-only.
    insert: The entity to insert. The entity must not already exist. The
      entity key's final path element may be incomplete.
    propertyMask: The properties to write in this mutation. None of the
      properties in the mask may have a reserved name, except for `__key__`.
      This field is ignored for `delete`. If the entity already exists, only
      properties referenced in the mask are updated, others are left
      untouched. Properties referenced in the mask but not in the entity are
      deleted.
    propertyTransforms: Optional. The transforms to perform on the entity.
      This field can be set only when the operation is `insert`, `update`, or
      `upsert`. If present, the transforms are be applied to the entity
      regardless of the property mask, in order, after the operation.
    update: The entity to update. The entity must already exist. Must have a
      complete key path.
    updateTime: The update time of the entity that this mutation is being
      applied to. If this does not match the current update time on the
      server, the mutation conflicts.
    upsert: The entity to upsert. The entity may or may not already exist. The
      entity key's final path element may be incomplete.
  """

  class ConflictResolutionStrategyValueValuesEnum(_messages.Enum):
    r"""The strategy to use when a conflict is detected. Defaults to
    `SERVER_VALUE`. If this is set, then `conflict_detection_strategy` must
    also be set.

    Values:
      STRATEGY_UNSPECIFIED: Unspecified. Defaults to `SERVER_VALUE`.
      SERVER_VALUE: The server entity is kept.
      FAIL: The whole commit request fails.
    """
    STRATEGY_UNSPECIFIED = 0
    SERVER_VALUE = 1
    FAIL = 2

  baseVersion = _messages.IntegerField(1)
  conflictResolutionStrategy = _messages.EnumField('ConflictResolutionStrategyValueValuesEnum', 2)
  delete = _messages.MessageField('Key', 3)
  insert = _messages.MessageField('Entity', 4)
  propertyMask = _messages.MessageField('PropertyMask', 5)
  propertyTransforms = _messages.MessageField('PropertyTransform', 6, repeated=True)
  update = _messages.MessageField('Entity', 7)
  updateTime = _messages.StringField(8)
  upsert = _messages.MessageField('Entity', 9)


class MutationResult(_messages.Message):
  r"""The result of applying a mutation.

  Fields:
    conflictDetected: Whether a conflict was detected for this mutation.
      Always false when a conflict detection strategy field is not set in the
      mutation.
    createTime: The create time of the entity. This field will not be set
      after a 'delete'.
    key: The automatically allocated key. Set only when the mutation allocated
      a key.
    transformResults: The results of applying each PropertyTransform, in the
      same order of the request.
    updateTime: The update time of the entity on the server after processing
      the mutation. If the mutation doesn't change anything on the server,
      then the timestamp will be the update timestamp of the current entity.
      This field will not be set after a 'delete'.
    version: The version of the entity on the server after processing the
      mutation. If the mutation doesn't change anything on the server, then
      the version will be the version of the current entity or, if no entity
      is present, a version that is strictly greater than the version of any
      previous entity and less than the version of any possible future entity.
  """

  conflictDetected = _messages.BooleanField(1)
  createTime = _messages.StringField(2)
  key = _messages.MessageField('Key', 3)
  transformResults = _messages.MessageField('Value', 4, repeated=True)
  updateTime = _messages.StringField(5)
  version = _messages.IntegerField(6)


class PartitionId(_messages.Message):
  r"""A partition ID identifies a grouping of entities. The grouping is always
  by project and namespace, however the namespace ID may be empty. A partition
  ID contains several dimensions: project ID and namespace ID. Partition
  dimensions: - May be `""`. - Must be valid UTF-8 bytes. - Must have values
  that match regex `[A-Za-z\d\.\-_]{1,100}` If the value of any dimension
  matches regex `__.*__`, the partition is reserved/read-only. A
  reserved/read-only partition ID is forbidden in certain documented contexts.
  Foreign partition IDs (in which the project ID does not match the context
  project ID ) are discouraged. Reads and writes of foreign partition IDs may
  fail if the project is not in an active state.

  Fields:
    databaseId: If not empty, the ID of the database to which the entities
      belong.
    namespaceId: If not empty, the ID of the namespace to which the entities
      belong.
    projectId: The ID of the project to which the entities belong.
  """

  databaseId = _messages.StringField(1)
  namespaceId = _messages.StringField(2)
  projectId = _messages.StringField(3)


class PathElement(_messages.Message):
  r"""A (kind, ID/name) pair used to construct a key path. If either name or
  ID is set, the element is complete. If neither is set, the element is
  incomplete.

  Fields:
    id: The auto-allocated ID of the entity. Never equal to zero. Values less
      than zero are discouraged and may not be supported in the future.
    kind: The kind of the entity. A kind matching regex `__.*__` is
      reserved/read-only. A kind must not contain more than 1500 bytes when
      UTF-8 encoded. Cannot be `""`. Must be valid UTF-8 bytes. Legacy values
      that are not valid UTF-8 are encoded as `__bytes__` where `` is the
      base-64 encoding of the bytes.
    name: The name of the entity. A name matching regex `__.*__` is
      reserved/read-only. A name must not be more than 1500 bytes when UTF-8
      encoded. Cannot be `""`. Must be valid UTF-8 bytes. Legacy values that
      are not valid UTF-8 are encoded as `__bytes__` where `` is the base-64
      encoding of the bytes.
  """

  id = _messages.IntegerField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class PlanSummary(_messages.Message):
  r"""Planning phase information for the query.

  Messages:
    IndexesUsedValueListEntry: A IndexesUsedValueListEntry object.

  Fields:
    indexesUsed: The indexes selected for the query. For example: [
      {"query_scope": "Collection", "properties": "(foo ASC, __name__ ASC)"},
      {"query_scope": "Collection", "properties": "(bar ASC, __name__ ASC)"} ]
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class IndexesUsedValueListEntry(_messages.Message):
    r"""A IndexesUsedValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        IndexesUsedValueListEntry object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a IndexesUsedValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  indexesUsed = _messages.MessageField('IndexesUsedValueListEntry', 1, repeated=True)


class Projection(_messages.Message):
  r"""A representation of a property in a projection.

  Fields:
    property: The property to project.
  """

  property = _messages.MessageField('PropertyReference', 1)


class PropertyFilter(_messages.Message):
  r"""A filter on a specific property.

  Enums:
    OpValueValuesEnum: The operator to filter by.

  Fields:
    op: The operator to filter by.
    property: The property to filter by.
    value: The value to compare the property to.
  """

  class OpValueValuesEnum(_messages.Enum):
    r"""The operator to filter by.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      LESS_THAN: The given `property` is less than the given `value`.
        Requires: * That `property` comes first in `order_by`.
      LESS_THAN_OR_EQUAL: The given `property` is less than or equal to the
        given `value`. Requires: * That `property` comes first in `order_by`.
      GREATER_THAN: The given `property` is greater than the given `value`.
        Requires: * That `property` comes first in `order_by`.
      GREATER_THAN_OR_EQUAL: The given `property` is greater than or equal to
        the given `value`. Requires: * That `property` comes first in
        `order_by`.
      EQUAL: The given `property` is equal to the given `value`.
      IN: The given `property` is equal to at least one value in the given
        array. Requires: * That `value` is a non-empty `ArrayValue`, subject
        to disjunction limits. * No `NOT_IN` is in the same query.
      NOT_EQUAL: The given `property` is not equal to the given `value`.
        Requires: * No other `NOT_EQUAL` or `NOT_IN` is in the same query. *
        That `property` comes first in the `order_by`.
      HAS_ANCESTOR: Limit the result set to the given entity and its
        descendants. Requires: * That `value` is an entity key. * All
        evaluated disjunctions must have the same `HAS_ANCESTOR` filter.
      NOT_IN: The value of the `property` is not in the given array. Requires:
        * That `value` is a non-empty `ArrayValue` with at most 10 values. *
        No other `OR`, `IN`, `NOT_IN`, `NOT_EQUAL` is in the same query. *
        That `field` comes first in the `order_by`.
    """
    OPERATOR_UNSPECIFIED = 0
    LESS_THAN = 1
    LESS_THAN_OR_EQUAL = 2
    GREATER_THAN = 3
    GREATER_THAN_OR_EQUAL = 4
    EQUAL = 5
    IN = 6
    NOT_EQUAL = 7
    HAS_ANCESTOR = 8
    NOT_IN = 9

  op = _messages.EnumField('OpValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)
  value = _messages.MessageField('Value', 3)


class PropertyMask(_messages.Message):
  r"""The set of arbitrarily nested property paths used to restrict an
  operation to only a subset of properties in an entity.

  Fields:
    paths: The paths to the properties covered by this mask. A path is a list
      of property names separated by dots (`.`), for example `foo.bar` means
      the property `bar` inside the entity property `foo` inside the entity
      associated with this path. If a property name contains a dot `.` or a
      backslash `\`, then that name must be escaped. A path must not be empty,
      and may not reference a value inside an array value.
  """

  paths = _messages.StringField(1, repeated=True)


class PropertyOrder(_messages.Message):
  r"""The desired order for a specific property.

  Enums:
    DirectionValueValuesEnum: The direction to order by. Defaults to
      `ASCENDING`.

  Fields:
    direction: The direction to order by. Defaults to `ASCENDING`.
    property: The property to order by.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""The direction to order by. Defaults to `ASCENDING`.

    Values:
      DIRECTION_UNSPECIFIED: Unspecified. This value must not be used.
      ASCENDING: Ascending.
      DESCENDING: Descending.
    """
    DIRECTION_UNSPECIFIED = 0
    ASCENDING = 1
    DESCENDING = 2

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)


class PropertyReference(_messages.Message):
  r"""A reference to a property relative to the kind expressions.

  Fields:
    name: A reference to a property. Requires: * MUST be a dot-delimited (`.`)
      string of segments, where each segment conforms to entity property name
      limitations.
  """

  name = _messages.StringField(1)


class PropertyTransform(_messages.Message):
  r"""A transformation of an entity property.

  Enums:
    SetToServerValueValueValuesEnum: Sets the property to the given server
      value.

  Fields:
    appendMissingElements: Appends the given elements in order if they are not
      already present in the current property value. If the property is not an
      array, or if the property does not yet exist, it is first set to the
      empty array. Equivalent numbers of different types (e.g. 3L and 3.0) are
      considered equal when checking if a value is missing. NaN is equal to
      NaN, and the null value is equal to the null value. If the input
      contains multiple equivalent values, only the first will be considered.
      The corresponding transform result will be the null value.
    increment: Adds the given value to the property's current value. This must
      be an integer or a double value. If the property is not an integer or
      double, or if the property does not yet exist, the transformation will
      set the property to the given value. If either of the given value or the
      current property value are doubles, both values will be interpreted as
      doubles. Double arithmetic and representation of double values follows
      IEEE 754 semantics. If there is positive/negative integer overflow, the
      property is resolved to the largest magnitude positive/negative integer.
    maximum: Sets the property to the maximum of its current value and the
      given value. This must be an integer or a double value. If the property
      is not an integer or double, or if the property does not yet exist, the
      transformation will set the property to the given value. If a maximum
      operation is applied where the property and the input value are of mixed
      types (that is - one is an integer and one is a double) the property
      takes on the type of the larger operand. If the operands are equivalent
      (e.g. 3 and 3.0), the property does not change. 0, 0.0, and -0.0 are all
      zero. The maximum of a zero stored value and zero input value is always
      the stored value. The maximum of any numeric value x and NaN is NaN.
    minimum: Sets the property to the minimum of its current value and the
      given value. This must be an integer or a double value. If the property
      is not an integer or double, or if the property does not yet exist, the
      transformation will set the property to the input value. If a minimum
      operation is applied where the property and the input value are of mixed
      types (that is - one is an integer and one is a double) the property
      takes on the type of the smaller operand. If the operands are equivalent
      (e.g. 3 and 3.0), the property does not change. 0, 0.0, and -0.0 are all
      zero. The minimum of a zero stored value and zero input value is always
      the stored value. The minimum of any numeric value x and NaN is NaN.
    property: Optional. The name of the property. Property paths (a list of
      property names separated by dots (`.`)) may be used to refer to
      properties inside entity values. For example `foo.bar` means the
      property `bar` inside the entity property `foo`. If a property name
      contains a dot `.` or a backlslash `\`, then that name must be escaped.
    removeAllFromArray: Removes all of the given elements from the array in
      the property. If the property is not an array, or if the property does
      not yet exist, it is set to the empty array. Equivalent numbers of
      different types (e.g. 3L and 3.0) are considered equal when deciding
      whether an element should be removed. NaN is equal to NaN, and the null
      value is equal to the null value. This will remove all equivalent values
      if there are duplicates. The corresponding transform result will be the
      null value.
    setToServerValue: Sets the property to the given server value.
  """

  class SetToServerValueValueValuesEnum(_messages.Enum):
    r"""Sets the property to the given server value.

    Values:
      SERVER_VALUE_UNSPECIFIED: Unspecified. This value must not be used.
      REQUEST_TIME: The time at which the server processed the request, with
        millisecond precision. If used on multiple properties (same or
        different entities) in a transaction, all the properties will get the
        same server timestamp.
    """
    SERVER_VALUE_UNSPECIFIED = 0
    REQUEST_TIME = 1

  appendMissingElements = _messages.MessageField('ArrayValue', 1)
  increment = _messages.MessageField('Value', 2)
  maximum = _messages.MessageField('Value', 3)
  minimum = _messages.MessageField('Value', 4)
  property = _messages.StringField(5)
  removeAllFromArray = _messages.MessageField('ArrayValue', 6)
  setToServerValue = _messages.EnumField('SetToServerValueValueValuesEnum', 7)


class Query(_messages.Message):
  r"""A query for entities. The query stages are executed in the following
  order: 1. kind 2. filter 3. projection 4. order + start_cursor + end_cursor
  5. offset 6. limit 7. find_nearest

  Fields:
    distinctOn: The properties to make distinct. The query results will
      contain the first result for each distinct combination of values for the
      given properties (if empty, all results are returned). Requires: * If
      `order` is specified, the set of distinct on properties must appear
      before the non-distinct on properties in `order`.
    endCursor: An ending point for the query results. Query cursors are
      returned in query result batches and [can only be used to limit the same
      query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_
      limits_and_offsets).
    filter: The filter to apply.
    findNearest: Optional. A potential Nearest Neighbors Search. Applies after
      all other filters and ordering. Finds the closest vector embeddings to
      the given query vector.
    kind: The kinds to query (if empty, returns entities of all kinds).
      Currently at most 1 kind may be specified.
    limit: The maximum number of results to return. Applies after all other
      constraints. Optional. Unspecified is interpreted as no limit. Must be
      >= 0 if specified.
    offset: The number of results to skip. Applies before limit, but after all
      other constraints. Optional. Must be >= 0 if specified.
    order: The order to apply to the query results (if empty, order is
      unspecified).
    projection: The projection to return. Defaults to returning all
      properties.
    startCursor: A starting point for the query results. Query cursors are
      returned in query result batches and [can only be used to continue the
      same query](https://cloud.google.com/datastore/docs/concepts/queries#cur
      sors_limits_and_offsets).
  """

  distinctOn = _messages.MessageField('PropertyReference', 1, repeated=True)
  endCursor = _messages.BytesField(2)
  filter = _messages.MessageField('Filter', 3)
  findNearest = _messages.MessageField('FindNearest', 4)
  kind = _messages.MessageField('KindExpression', 5, repeated=True)
  limit = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  offset = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  order = _messages.MessageField('PropertyOrder', 8, repeated=True)
  projection = _messages.MessageField('Projection', 9, repeated=True)
  startCursor = _messages.BytesField(10)


class QueryResultBatch(_messages.Message):
  r"""A batch of results produced by a query.

  Enums:
    EntityResultTypeValueValuesEnum: The result type for every entity in
      `entity_results`.
    MoreResultsValueValuesEnum: The state of the query after the current
      batch.

  Fields:
    endCursor: A cursor that points to the position after the last result in
      the batch.
    entityResultType: The result type for every entity in `entity_results`.
    entityResults: The results for this batch.
    moreResults: The state of the query after the current batch.
    readTime: Read timestamp this batch was returned from. This applies to the
      range of results from the query's `start_cursor` (or the beginning of
      the query if no cursor was given) to this batch's `end_cursor` (not the
      query's `end_cursor`). In a single transaction, subsequent query result
      batches for the same query can have a greater timestamp. Each batch's
      read timestamp is valid for all preceding batches. This value will not
      be set for eventually consistent queries in Cloud Datastore.
    skippedCursor: A cursor that points to the position after the last skipped
      result. Will be set when `skipped_results` != 0.
    skippedResults: The number of results skipped, typically because of an
      offset.
    snapshotVersion: The version number of the snapshot this batch was
      returned from. This applies to the range of results from the query's
      `start_cursor` (or the beginning of the query if no cursor was given) to
      this batch's `end_cursor` (not the query's `end_cursor`). In a single
      transaction, subsequent query result batches for the same query can have
      a greater snapshot version number. Each batch's snapshot version is
      valid for all preceding batches. The value will be zero for eventually
      consistent queries.
  """

  class EntityResultTypeValueValuesEnum(_messages.Enum):
    r"""The result type for every entity in `entity_results`.

    Values:
      RESULT_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      FULL: The key and properties.
      PROJECTION: A projected subset of properties. The entity may have no
        key.
      KEY_ONLY: Only the key.
    """
    RESULT_TYPE_UNSPECIFIED = 0
    FULL = 1
    PROJECTION = 2
    KEY_ONLY = 3

  class MoreResultsValueValuesEnum(_messages.Enum):
    r"""The state of the query after the current batch.

    Values:
      MORE_RESULTS_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      NOT_FINISHED: There may be additional batches to fetch from this query.
      MORE_RESULTS_AFTER_LIMIT: The query is finished, but there may be more
        results after the limit.
      MORE_RESULTS_AFTER_CURSOR: The query is finished, but there may be more
        results after the end cursor.
      NO_MORE_RESULTS: The query is finished, and there are no more results.
    """
    MORE_RESULTS_TYPE_UNSPECIFIED = 0
    NOT_FINISHED = 1
    MORE_RESULTS_AFTER_LIMIT = 2
    MORE_RESULTS_AFTER_CURSOR = 3
    NO_MORE_RESULTS = 4

  endCursor = _messages.BytesField(1)
  entityResultType = _messages.EnumField('EntityResultTypeValueValuesEnum', 2)
  entityResults = _messages.MessageField('EntityResult', 3, repeated=True)
  moreResults = _messages.EnumField('MoreResultsValueValuesEnum', 4)
  readTime = _messages.StringField(5)
  skippedCursor = _messages.BytesField(6)
  skippedResults = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  snapshotVersion = _messages.IntegerField(8)


class ReadOnly(_messages.Message):
  r"""Options specific to read-only transactions.

  Fields:
    readTime: Reads entities at the given time. This must be a microsecond
      precision timestamp within the past one hour, or if Point-in-Time
      Recovery is enabled, can additionally be a whole minute timestamp within
      the past 7 days.
  """

  readTime = _messages.StringField(1)


class ReadOptions(_messages.Message):
  r"""The options shared by read requests.

  Enums:
    ReadConsistencyValueValuesEnum: The non-transactional read consistency to
      use.

  Fields:
    newTransaction: Options for beginning a new transaction for this request.
      The new transaction identifier will be returned in the corresponding
      response as either LookupResponse.transaction or
      RunQueryResponse.transaction.
    readConsistency: The non-transactional read consistency to use.
    readTime: Reads entities as they were at the given time. This value is
      only supported for Cloud Firestore in Datastore mode. This must be a
      microsecond precision timestamp within the past one hour, or if Point-
      in-Time Recovery is enabled, can additionally be a whole minute
      timestamp within the past 7 days.
    transaction: The identifier of the transaction in which to read. A
      transaction identifier is returned by a call to
      Datastore.BeginTransaction.
  """

  class ReadConsistencyValueValuesEnum(_messages.Enum):
    r"""The non-transactional read consistency to use.

    Values:
      READ_CONSISTENCY_UNSPECIFIED: Unspecified. This value must not be used.
      STRONG: Strong consistency.
      EVENTUAL: Eventual consistency.
    """
    READ_CONSISTENCY_UNSPECIFIED = 0
    STRONG = 1
    EVENTUAL = 2

  newTransaction = _messages.MessageField('TransactionOptions', 1)
  readConsistency = _messages.EnumField('ReadConsistencyValueValuesEnum', 2)
  readTime = _messages.StringField(3)
  transaction = _messages.BytesField(4)


class ReadWrite(_messages.Message):
  r"""Options specific to read / write transactions.

  Fields:
    previousTransaction: The transaction identifier of the transaction being
      retried.
  """

  previousTransaction = _messages.BytesField(1)


class ReserveIdsRequest(_messages.Message):
  r"""The request for Datastore.ReserveIds.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    keys: Required. A list of keys with complete key paths whose numeric IDs
      should not be auto-allocated.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)


class ReserveIdsResponse(_messages.Message):
  r"""The response for Datastore.ReserveIds."""


class RollbackRequest(_messages.Message):
  r"""The request for Datastore.Rollback.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    transaction: Required. The transaction identifier, returned by a call to
      Datastore.BeginTransaction.
  """

  databaseId = _messages.StringField(1)
  transaction = _messages.BytesField(2)


class RollbackResponse(_messages.Message):
  r"""The response for Datastore.Rollback. (an empty message)."""


class RunAggregationQueryRequest(_messages.Message):
  r"""The request for Datastore.RunAggregationQuery.

  Fields:
    aggregationQuery: The query to run.
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    explainOptions: Optional. Explain options for the query. If set,
      additional query statistics will be returned. If not, only query results
      will be returned.
    gqlQuery: The GQL query to run. This query must be an aggregation query.
    partitionId: Entities are partitioned into subsets, identified by a
      partition ID. Queries are scoped to a single partition. This partition
      ID is normalized with the standard default context partition ID.
    readOptions: The options for this query.
  """

  aggregationQuery = _messages.MessageField('AggregationQuery', 1)
  databaseId = _messages.StringField(2)
  explainOptions = _messages.MessageField('ExplainOptions', 3)
  gqlQuery = _messages.MessageField('GqlQuery', 4)
  partitionId = _messages.MessageField('PartitionId', 5)
  readOptions = _messages.MessageField('ReadOptions', 6)


class RunAggregationQueryResponse(_messages.Message):
  r"""The response for Datastore.RunAggregationQuery.

  Fields:
    batch: A batch of aggregation results. Always present.
    explainMetrics: Query explain metrics. This is only present when the
      RunAggregationQueryRequest.explain_options is provided, and it is sent
      only once with the last response in the stream.
    query: The parsed form of the `GqlQuery` from the request, if it was set.
    transaction: The identifier of the transaction that was started as part of
      this RunAggregationQuery request. Set only when
      ReadOptions.new_transaction was set in
      RunAggregationQueryRequest.read_options.
  """

  batch = _messages.MessageField('AggregationResultBatch', 1)
  explainMetrics = _messages.MessageField('ExplainMetrics', 2)
  query = _messages.MessageField('AggregationQuery', 3)
  transaction = _messages.BytesField(4)


class RunQueryRequest(_messages.Message):
  r"""The request for Datastore.RunQuery.

  Fields:
    databaseId: The ID of the database against which to make the request.
      '(default)' is not allowed; please use empty string '' to refer the
      default database.
    explainOptions: Optional. Explain options for the query. If set,
      additional query statistics will be returned. If not, only query results
      will be returned.
    gqlQuery: The GQL query to run. This query must be a non-aggregation
      query.
    partitionId: Entities are partitioned into subsets, identified by a
      partition ID. Queries are scoped to a single partition. This partition
      ID is normalized with the standard default context partition ID.
    propertyMask: The properties to return. This field must not be set for a
      projection query. See LookupRequest.property_mask.
    query: The query to run.
    readOptions: The options for this query.
  """

  databaseId = _messages.StringField(1)
  explainOptions = _messages.MessageField('ExplainOptions', 2)
  gqlQuery = _messages.MessageField('GqlQuery', 3)
  partitionId = _messages.MessageField('PartitionId', 4)
  propertyMask = _messages.MessageField('PropertyMask', 5)
  query = _messages.MessageField('Query', 6)
  readOptions = _messages.MessageField('ReadOptions', 7)


class RunQueryResponse(_messages.Message):
  r"""The response for Datastore.RunQuery.

  Fields:
    batch: A batch of query results (always present).
    explainMetrics: Query explain metrics. This is only present when the
      RunQueryRequest.explain_options is provided, and it is sent only once
      with the last response in the stream.
    query: The parsed form of the `GqlQuery` from the request, if it was set.
    transaction: The identifier of the transaction that was started as part of
      this RunQuery request. Set only when ReadOptions.new_transaction was set
      in RunQueryRequest.read_options.
  """

  batch = _messages.MessageField('QueryResultBatch', 1)
  explainMetrics = _messages.MessageField('ExplainMetrics', 2)
  query = _messages.MessageField('Query', 3)
  transaction = _messages.BytesField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Sum(_messages.Message):
  r"""Sum of the values of the requested property. * Only numeric values will
  be aggregated. All non-numeric values including `NULL` are skipped. * If the
  aggregated values contain `NaN`, returns `NaN`. Infinity math follows
  IEEE-754 standards. * If the aggregated value set is empty, returns 0. *
  Returns a 64-bit integer if all aggregated numbers are integers and the sum
  result does not overflow. Otherwise, the result is returned as a double.
  Note that even if all the aggregated values are integers, the result is
  returned as a double if it cannot fit within a 64-bit signed integer. When
  this occurs, the returned value will lose precision. * When underflow
  occurs, floating-point aggregation is non-deterministic. This means that
  running the same query repeatedly without any changes to the underlying
  values could produce slightly different results each time. In those cases,
  values should be stored as integers over floating-point numbers.

  Fields:
    property: The property to aggregate on.
  """

  property = _messages.MessageField('PropertyReference', 1)


class TransactionOptions(_messages.Message):
  r"""Options for beginning a new transaction. Transactions can be created
  explicitly with calls to Datastore.BeginTransaction or implicitly by setting
  ReadOptions.new_transaction in read requests.

  Fields:
    readOnly: The transaction should only allow reads.
    readWrite: The transaction should allow both reads and writes.
  """

  readOnly = _messages.MessageField('ReadOnly', 1)
  readWrite = _messages.MessageField('ReadWrite', 2)


class Value(_messages.Message):
  r"""A message that can hold any of the supported value types and associated
  metadata.

  Enums:
    NullValueValueValuesEnum: A null value.

  Fields:
    arrayValue: An array value. Cannot contain another array value. A `Value`
      instance that sets field `array_value` must not set fields `meaning` or
      `exclude_from_indexes`.
    blobValue: A blob value. May have at most 1,000,000 bytes. When
      `exclude_from_indexes` is false, may have at most 1500 bytes. In JSON
      requests, must be base64-encoded.
    booleanValue: A boolean value.
    doubleValue: A double value.
    entityValue: An entity value. - May have no key. - May have a key with an
      incomplete key path. - May have a reserved/read-only key.
    excludeFromIndexes: If the value should be excluded from all indexes
      including those defined explicitly.
    geoPointValue: A geo point value representing a point on the surface of
      Earth.
    integerValue: An integer value.
    keyValue: A key value.
    meaning: The `meaning` field should only be populated for backwards
      compatibility.
    nullValue: A null value.
    stringValue: A UTF-8 encoded string value. When `exclude_from_indexes` is
      false (it is indexed) , may have at most 1500 bytes. Otherwise, may be
      set to at most 1,000,000 bytes.
    timestampValue: A timestamp value. When stored in the Datastore, precise
      only to microseconds; any additional precision is rounded down.
  """

  class NullValueValueValuesEnum(_messages.Enum):
    r"""A null value.

    Values:
      NULL_VALUE: Null value.
    """
    NULL_VALUE = 0

  arrayValue = _messages.MessageField('ArrayValue', 1)
  blobValue = _messages.BytesField(2)
  booleanValue = _messages.BooleanField(3)
  doubleValue = _messages.FloatField(4)
  entityValue = _messages.MessageField('Entity', 5)
  excludeFromIndexes = _messages.BooleanField(6)
  geoPointValue = _messages.MessageField('LatLng', 7)
  integerValue = _messages.IntegerField(8)
  keyValue = _messages.MessageField('Key', 9)
  meaning = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  nullValue = _messages.EnumField('NullValueValueValuesEnum', 11)
  stringValue = _messages.StringField(12)
  timestampValue = _messages.StringField(13)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
