/*****************************************************************************
 *
 * Copyright (C) 2010 Atmel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * * Neither the name of the copyright holders nor the names of
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Model        : UC3C0512C
 * Revision     : $Revision: 74772 $
 * Checkin Date : $Date: 2010-05-14 06:51:12 +0200 (Fri, 14 May 2010) $ 
 *
 ****************************************************************************/
#ifndef AVR32_HMATRIXB_130_H_INCLUDED
#define AVR32_HMATRIXB_130_H_INCLUDED

#define AVR32_HMATRIXB_H_VERSION 130

#include "avr32/abi.h"


/*
 Note to user:

 The following defines are always generated:
 - Register offset: AVR32_HMATRIXB_<register>
 - Bitfield mask:   AVR32_HMATRIXB_<register>_<bitfield>
 - Bitfield offset: AVR32_HMATRIXB_<register>_<bitfield>_OFFSET
 - Bitfield size:   AVR32_HMATRIXB_<register>_<bitfield>_SIZE
 - Bitfield values: AVR32_HMATRIXB_<register>_<bitfield>_<value name>

 The following defines are generated if they don't cause ambiguities,
 i.e. the name is unique, or all values with that name are the same.
 - Bitfield mask:   AVR32_HMATRIXB_<bitfield>
 - Bitfield offset: AVR32_HMATRIXB_<bitfield>_OFFSET
 - Bitfield size:   AVR32_HMATRIXB_<bitfield>_SIZE
 - Bitfield values: AVR32_HMATRIXB_<bitfield>_<value name>
 - Bitfield values: AVR32_HMATRIXB_<value name>

 All defines are sorted alphabetically.
*/


#define AVR32_HMATRIXB_ARBT                                             24
#define AVR32_HMATRIXB_ARBT_FIXED_PRIORITY                      0x00000001
#define AVR32_HMATRIXB_ARBT_MASK                                0x01000000
#define AVR32_HMATRIXB_ARBT_OFFSET                                      24
#define AVR32_HMATRIXB_ARBT_ROUND_ROBIN                         0x00000000
#define AVR32_HMATRIXB_ARBT_SIZE                                         1
#define AVR32_HMATRIXB_DEFMSTR_TYPE                                     16
#define AVR32_HMATRIXB_DEFMSTR_TYPE_FIXED_DEFAULT               0x00000002
#define AVR32_HMATRIXB_DEFMSTR_TYPE_LAST_DEFAULT                0x00000001
#define AVR32_HMATRIXB_DEFMSTR_TYPE_MASK                        0x00030000
#define AVR32_HMATRIXB_DEFMSTR_TYPE_NO_DEFAULT                  0x00000000
#define AVR32_HMATRIXB_DEFMSTR_TYPE_OFFSET                              16
#define AVR32_HMATRIXB_DEFMSTR_TYPE_SIZE                                 2
#define AVR32_HMATRIXB_EIGHT_BEAT                               0x00000003
#define AVR32_HMATRIXB_FIXED_DEFAULT                            0x00000002
#define AVR32_HMATRIXB_FIXED_DEFMSTR                                    18
#define AVR32_HMATRIXB_FIXED_DEFMSTR_MASK                       0x003c0000
#define AVR32_HMATRIXB_FIXED_DEFMSTR_OFFSET                             18
#define AVR32_HMATRIXB_FIXED_DEFMSTR_SIZE                                4
#define AVR32_HMATRIXB_FIXED_PRIORITY                           0x00000001
#define AVR32_HMATRIXB_FOUR_BEAT                                0x00000002
#define AVR32_HMATRIXB_INFINITE                                 0x00000000
#define AVR32_HMATRIXB_LAST_DEFAULT                             0x00000001
#define AVR32_HMATRIXB_M0PR                                              0
#define AVR32_HMATRIXB_M0PR_MASK                                0x0000000f
#define AVR32_HMATRIXB_M0PR_OFFSET                                       0
#define AVR32_HMATRIXB_M0PR_SIZE                                         4
#define AVR32_HMATRIXB_M10PR                                             8
#define AVR32_HMATRIXB_M10PR_MASK                               0x00000f00
#define AVR32_HMATRIXB_M10PR_OFFSET                                      8
#define AVR32_HMATRIXB_M10PR_SIZE                                        4
#define AVR32_HMATRIXB_M11PR                                            12
#define AVR32_HMATRIXB_M11PR_MASK                               0x0000f000
#define AVR32_HMATRIXB_M11PR_OFFSET                                     12
#define AVR32_HMATRIXB_M11PR_SIZE                                        4
#define AVR32_HMATRIXB_M12PR                                            16
#define AVR32_HMATRIXB_M12PR_MASK                               0x000f0000
#define AVR32_HMATRIXB_M12PR_OFFSET                                     16
#define AVR32_HMATRIXB_M12PR_SIZE                                        4
#define AVR32_HMATRIXB_M13PR                                            20
#define AVR32_HMATRIXB_M13PR_MASK                               0x00f00000
#define AVR32_HMATRIXB_M13PR_OFFSET                                     20
#define AVR32_HMATRIXB_M13PR_SIZE                                        4
#define AVR32_HMATRIXB_M14PR                                            24
#define AVR32_HMATRIXB_M14PR_MASK                               0x0f000000
#define AVR32_HMATRIXB_M14PR_OFFSET                                     24
#define AVR32_HMATRIXB_M14PR_SIZE                                        4
#define AVR32_HMATRIXB_M15PR                                            28
#define AVR32_HMATRIXB_M15PR_MASK                               0xf0000000
#define AVR32_HMATRIXB_M15PR_OFFSET                                     28
#define AVR32_HMATRIXB_M15PR_SIZE                                        4
#define AVR32_HMATRIXB_M1PR                                              4
#define AVR32_HMATRIXB_M1PR_MASK                                0x000000f0
#define AVR32_HMATRIXB_M1PR_OFFSET                                       4
#define AVR32_HMATRIXB_M1PR_SIZE                                         4
#define AVR32_HMATRIXB_M2PR                                              8
#define AVR32_HMATRIXB_M2PR_MASK                                0x00000f00
#define AVR32_HMATRIXB_M2PR_OFFSET                                       8
#define AVR32_HMATRIXB_M2PR_SIZE                                         4
#define AVR32_HMATRIXB_M3PR                                             12
#define AVR32_HMATRIXB_M3PR_MASK                                0x0000f000
#define AVR32_HMATRIXB_M3PR_OFFSET                                      12
#define AVR32_HMATRIXB_M3PR_SIZE                                         4
#define AVR32_HMATRIXB_M4PR                                             16
#define AVR32_HMATRIXB_M4PR_MASK                                0x000f0000
#define AVR32_HMATRIXB_M4PR_OFFSET                                      16
#define AVR32_HMATRIXB_M4PR_SIZE                                         4
#define AVR32_HMATRIXB_M5PR                                             20
#define AVR32_HMATRIXB_M5PR_MASK                                0x00f00000
#define AVR32_HMATRIXB_M5PR_OFFSET                                      20
#define AVR32_HMATRIXB_M5PR_SIZE                                         4
#define AVR32_HMATRIXB_M6PR                                             24
#define AVR32_HMATRIXB_M6PR_MASK                                0x0f000000
#define AVR32_HMATRIXB_M6PR_OFFSET                                      24
#define AVR32_HMATRIXB_M6PR_SIZE                                         4
#define AVR32_HMATRIXB_M7PR                                             28
#define AVR32_HMATRIXB_M7PR_MASK                                0xf0000000
#define AVR32_HMATRIXB_M7PR_OFFSET                                      28
#define AVR32_HMATRIXB_M7PR_SIZE                                         4
#define AVR32_HMATRIXB_M8PR                                              0
#define AVR32_HMATRIXB_M8PR_MASK                                0x0000000f
#define AVR32_HMATRIXB_M8PR_OFFSET                                       0
#define AVR32_HMATRIXB_M8PR_SIZE                                         4
#define AVR32_HMATRIXB_M9PR                                              4
#define AVR32_HMATRIXB_M9PR_MASK                                0x000000f0
#define AVR32_HMATRIXB_M9PR_OFFSET                                       4
#define AVR32_HMATRIXB_M9PR_SIZE                                         4
#define AVR32_HMATRIXB_MCFG0                                    0x00000000
#define AVR32_HMATRIXB_MCFG0_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG0_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG0_ULBT                                        0
#define AVR32_HMATRIXB_MCFG0_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG0_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG0_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG0_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG0_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG0_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG0_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG0_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG1                                    0x00000004
#define AVR32_HMATRIXB_MCFG10                                   0x00000028
#define AVR32_HMATRIXB_MCFG10_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG10_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG10_ULBT                                       0
#define AVR32_HMATRIXB_MCFG10_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG10_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG10_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG10_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG10_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG10_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG10_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG10_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG11                                   0x0000002c
#define AVR32_HMATRIXB_MCFG11_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG11_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG11_ULBT                                       0
#define AVR32_HMATRIXB_MCFG11_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG11_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG11_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG11_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG11_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG11_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG11_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG11_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG12                                   0x00000030
#define AVR32_HMATRIXB_MCFG12_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG12_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG12_ULBT                                       0
#define AVR32_HMATRIXB_MCFG12_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG12_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG12_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG12_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG12_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG12_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG12_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG12_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG13                                   0x00000034
#define AVR32_HMATRIXB_MCFG13_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG13_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG13_ULBT                                       0
#define AVR32_HMATRIXB_MCFG13_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG13_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG13_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG13_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG13_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG13_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG13_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG13_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG14                                   0x00000038
#define AVR32_HMATRIXB_MCFG14_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG14_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG14_ULBT                                       0
#define AVR32_HMATRIXB_MCFG14_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG14_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG14_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG14_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG14_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG14_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG14_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG14_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG15                                   0x0000003c
#define AVR32_HMATRIXB_MCFG15_MASK                              0x00000007
#define AVR32_HMATRIXB_MCFG15_RESETVALUE                        0x00000002
#define AVR32_HMATRIXB_MCFG15_ULBT                                       0
#define AVR32_HMATRIXB_MCFG15_ULBT_EIGHT_BEAT                   0x00000003
#define AVR32_HMATRIXB_MCFG15_ULBT_FOUR_BEAT                    0x00000002
#define AVR32_HMATRIXB_MCFG15_ULBT_INFINITE                     0x00000000
#define AVR32_HMATRIXB_MCFG15_ULBT_MASK                         0x00000007
#define AVR32_HMATRIXB_MCFG15_ULBT_OFFSET                                0
#define AVR32_HMATRIXB_MCFG15_ULBT_SINGLE                       0x00000001
#define AVR32_HMATRIXB_MCFG15_ULBT_SIXTEEN_BEAT                 0x00000004
#define AVR32_HMATRIXB_MCFG15_ULBT_SIZE                                  3
#define AVR32_HMATRIXB_MCFG1_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG1_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG1_ULBT                                        0
#define AVR32_HMATRIXB_MCFG1_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG1_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG1_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG1_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG1_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG1_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG1_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG1_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG2                                    0x00000008
#define AVR32_HMATRIXB_MCFG2_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG2_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG2_ULBT                                        0
#define AVR32_HMATRIXB_MCFG2_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG2_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG2_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG2_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG2_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG2_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG2_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG2_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG3                                    0x0000000c
#define AVR32_HMATRIXB_MCFG3_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG3_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG3_ULBT                                        0
#define AVR32_HMATRIXB_MCFG3_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG3_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG3_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG3_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG3_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG3_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG3_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG3_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG4                                    0x00000010
#define AVR32_HMATRIXB_MCFG4_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG4_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG4_ULBT                                        0
#define AVR32_HMATRIXB_MCFG4_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG4_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG4_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG4_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG4_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG4_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG4_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG4_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG5                                    0x00000014
#define AVR32_HMATRIXB_MCFG5_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG5_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG5_ULBT                                        0
#define AVR32_HMATRIXB_MCFG5_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG5_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG5_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG5_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG5_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG5_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG5_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG5_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG6                                    0x00000018
#define AVR32_HMATRIXB_MCFG6_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG6_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG6_ULBT                                        0
#define AVR32_HMATRIXB_MCFG6_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG6_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG6_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG6_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG6_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG6_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG6_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG6_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG7                                    0x0000001c
#define AVR32_HMATRIXB_MCFG7_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG7_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG7_ULBT                                        0
#define AVR32_HMATRIXB_MCFG7_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG7_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG7_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG7_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG7_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG7_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG7_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG7_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG8                                    0x00000020
#define AVR32_HMATRIXB_MCFG8_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG8_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG8_ULBT                                        0
#define AVR32_HMATRIXB_MCFG8_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG8_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG8_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG8_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG8_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG8_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG8_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG8_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MCFG9                                    0x00000024
#define AVR32_HMATRIXB_MCFG9_MASK                               0x00000007
#define AVR32_HMATRIXB_MCFG9_RESETVALUE                         0x00000002
#define AVR32_HMATRIXB_MCFG9_ULBT                                        0
#define AVR32_HMATRIXB_MCFG9_ULBT_EIGHT_BEAT                    0x00000003
#define AVR32_HMATRIXB_MCFG9_ULBT_FOUR_BEAT                     0x00000002
#define AVR32_HMATRIXB_MCFG9_ULBT_INFINITE                      0x00000000
#define AVR32_HMATRIXB_MCFG9_ULBT_MASK                          0x00000007
#define AVR32_HMATRIXB_MCFG9_ULBT_OFFSET                                 0
#define AVR32_HMATRIXB_MCFG9_ULBT_SINGLE                        0x00000001
#define AVR32_HMATRIXB_MCFG9_ULBT_SIXTEEN_BEAT                  0x00000004
#define AVR32_HMATRIXB_MCFG9_ULBT_SIZE                                   3
#define AVR32_HMATRIXB_MRCR                                     0x00000100
#define AVR32_HMATRIXB_MRCR_MASK                                0x0000ffff
#define AVR32_HMATRIXB_MRCR_RCB0                                         0
#define AVR32_HMATRIXB_MRCR_RCB0_MASK                           0x00000001
#define AVR32_HMATRIXB_MRCR_RCB0_OFFSET                                  0
#define AVR32_HMATRIXB_MRCR_RCB0_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB1                                         1
#define AVR32_HMATRIXB_MRCR_RCB10                                       10
#define AVR32_HMATRIXB_MRCR_RCB10_MASK                          0x00000400
#define AVR32_HMATRIXB_MRCR_RCB10_OFFSET                                10
#define AVR32_HMATRIXB_MRCR_RCB10_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB11                                       11
#define AVR32_HMATRIXB_MRCR_RCB11_MASK                          0x00000800
#define AVR32_HMATRIXB_MRCR_RCB11_OFFSET                                11
#define AVR32_HMATRIXB_MRCR_RCB11_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB12                                       12
#define AVR32_HMATRIXB_MRCR_RCB12_MASK                          0x00001000
#define AVR32_HMATRIXB_MRCR_RCB12_OFFSET                                12
#define AVR32_HMATRIXB_MRCR_RCB12_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB13                                       13
#define AVR32_HMATRIXB_MRCR_RCB13_MASK                          0x00002000
#define AVR32_HMATRIXB_MRCR_RCB13_OFFSET                                13
#define AVR32_HMATRIXB_MRCR_RCB13_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB14                                       14
#define AVR32_HMATRIXB_MRCR_RCB14_MASK                          0x00004000
#define AVR32_HMATRIXB_MRCR_RCB14_OFFSET                                14
#define AVR32_HMATRIXB_MRCR_RCB14_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB15                                       15
#define AVR32_HMATRIXB_MRCR_RCB15_MASK                          0x00008000
#define AVR32_HMATRIXB_MRCR_RCB15_OFFSET                                15
#define AVR32_HMATRIXB_MRCR_RCB15_SIZE                                   1
#define AVR32_HMATRIXB_MRCR_RCB1_MASK                           0x00000002
#define AVR32_HMATRIXB_MRCR_RCB1_OFFSET                                  1
#define AVR32_HMATRIXB_MRCR_RCB1_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB2                                         2
#define AVR32_HMATRIXB_MRCR_RCB2_MASK                           0x00000004
#define AVR32_HMATRIXB_MRCR_RCB2_OFFSET                                  2
#define AVR32_HMATRIXB_MRCR_RCB2_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB3                                         3
#define AVR32_HMATRIXB_MRCR_RCB3_MASK                           0x00000008
#define AVR32_HMATRIXB_MRCR_RCB3_OFFSET                                  3
#define AVR32_HMATRIXB_MRCR_RCB3_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB4                                         4
#define AVR32_HMATRIXB_MRCR_RCB4_MASK                           0x00000010
#define AVR32_HMATRIXB_MRCR_RCB4_OFFSET                                  4
#define AVR32_HMATRIXB_MRCR_RCB4_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB5                                         5
#define AVR32_HMATRIXB_MRCR_RCB5_MASK                           0x00000020
#define AVR32_HMATRIXB_MRCR_RCB5_OFFSET                                  5
#define AVR32_HMATRIXB_MRCR_RCB5_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB6                                         6
#define AVR32_HMATRIXB_MRCR_RCB6_MASK                           0x00000040
#define AVR32_HMATRIXB_MRCR_RCB6_OFFSET                                  6
#define AVR32_HMATRIXB_MRCR_RCB6_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB7                                         7
#define AVR32_HMATRIXB_MRCR_RCB7_MASK                           0x00000080
#define AVR32_HMATRIXB_MRCR_RCB7_OFFSET                                  7
#define AVR32_HMATRIXB_MRCR_RCB7_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB8                                         8
#define AVR32_HMATRIXB_MRCR_RCB8_MASK                           0x00000100
#define AVR32_HMATRIXB_MRCR_RCB8_OFFSET                                  8
#define AVR32_HMATRIXB_MRCR_RCB8_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RCB9                                         9
#define AVR32_HMATRIXB_MRCR_RCB9_MASK                           0x00000200
#define AVR32_HMATRIXB_MRCR_RCB9_OFFSET                                  9
#define AVR32_HMATRIXB_MRCR_RCB9_SIZE                                    1
#define AVR32_HMATRIXB_MRCR_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_NO_DEFAULT                               0x00000000
#define AVR32_HMATRIXB_PRAS0                                    0x00000080
#define AVR32_HMATRIXB_PRAS0_M0PR                                        0
#define AVR32_HMATRIXB_PRAS0_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS0_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS0_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M1PR                                        4
#define AVR32_HMATRIXB_PRAS0_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS0_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS0_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M2PR                                        8
#define AVR32_HMATRIXB_PRAS0_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS0_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS0_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M3PR                                       12
#define AVR32_HMATRIXB_PRAS0_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS0_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS0_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M4PR                                       16
#define AVR32_HMATRIXB_PRAS0_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS0_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS0_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M5PR                                       20
#define AVR32_HMATRIXB_PRAS0_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS0_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS0_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M6PR                                       24
#define AVR32_HMATRIXB_PRAS0_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS0_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS0_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_M7PR                                       28
#define AVR32_HMATRIXB_PRAS0_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS0_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS0_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS0_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS0_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS1                                    0x00000088
#define AVR32_HMATRIXB_PRAS10                                   0x000000d0
#define AVR32_HMATRIXB_PRAS10_M0PR                                       0
#define AVR32_HMATRIXB_PRAS10_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS10_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS10_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M1PR                                       4
#define AVR32_HMATRIXB_PRAS10_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS10_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS10_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M2PR                                       8
#define AVR32_HMATRIXB_PRAS10_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS10_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS10_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M3PR                                      12
#define AVR32_HMATRIXB_PRAS10_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS10_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS10_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M4PR                                      16
#define AVR32_HMATRIXB_PRAS10_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS10_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS10_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M5PR                                      20
#define AVR32_HMATRIXB_PRAS10_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS10_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS10_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M6PR                                      24
#define AVR32_HMATRIXB_PRAS10_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS10_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS10_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_M7PR                                      28
#define AVR32_HMATRIXB_PRAS10_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS10_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS10_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS10_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS10_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS11                                   0x000000d8
#define AVR32_HMATRIXB_PRAS11_M0PR                                       0
#define AVR32_HMATRIXB_PRAS11_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS11_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS11_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M1PR                                       4
#define AVR32_HMATRIXB_PRAS11_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS11_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS11_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M2PR                                       8
#define AVR32_HMATRIXB_PRAS11_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS11_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS11_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M3PR                                      12
#define AVR32_HMATRIXB_PRAS11_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS11_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS11_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M4PR                                      16
#define AVR32_HMATRIXB_PRAS11_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS11_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS11_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M5PR                                      20
#define AVR32_HMATRIXB_PRAS11_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS11_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS11_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M6PR                                      24
#define AVR32_HMATRIXB_PRAS11_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS11_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS11_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_M7PR                                      28
#define AVR32_HMATRIXB_PRAS11_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS11_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS11_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS11_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS11_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS12                                   0x000000e0
#define AVR32_HMATRIXB_PRAS12_M0PR                                       0
#define AVR32_HMATRIXB_PRAS12_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS12_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS12_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M1PR                                       4
#define AVR32_HMATRIXB_PRAS12_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS12_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS12_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M2PR                                       8
#define AVR32_HMATRIXB_PRAS12_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS12_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS12_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M3PR                                      12
#define AVR32_HMATRIXB_PRAS12_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS12_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS12_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M4PR                                      16
#define AVR32_HMATRIXB_PRAS12_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS12_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS12_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M5PR                                      20
#define AVR32_HMATRIXB_PRAS12_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS12_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS12_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M6PR                                      24
#define AVR32_HMATRIXB_PRAS12_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS12_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS12_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_M7PR                                      28
#define AVR32_HMATRIXB_PRAS12_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS12_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS12_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS12_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS12_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS13                                   0x000000e8
#define AVR32_HMATRIXB_PRAS13_M0PR                                       0
#define AVR32_HMATRIXB_PRAS13_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS13_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS13_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M1PR                                       4
#define AVR32_HMATRIXB_PRAS13_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS13_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS13_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M2PR                                       8
#define AVR32_HMATRIXB_PRAS13_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS13_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS13_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M3PR                                      12
#define AVR32_HMATRIXB_PRAS13_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS13_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS13_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M4PR                                      16
#define AVR32_HMATRIXB_PRAS13_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS13_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS13_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M5PR                                      20
#define AVR32_HMATRIXB_PRAS13_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS13_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS13_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M6PR                                      24
#define AVR32_HMATRIXB_PRAS13_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS13_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS13_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_M7PR                                      28
#define AVR32_HMATRIXB_PRAS13_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS13_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS13_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS13_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS13_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS14                                   0x000000f0
#define AVR32_HMATRIXB_PRAS14_M0PR                                       0
#define AVR32_HMATRIXB_PRAS14_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS14_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS14_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M1PR                                       4
#define AVR32_HMATRIXB_PRAS14_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS14_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS14_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M2PR                                       8
#define AVR32_HMATRIXB_PRAS14_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS14_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS14_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M3PR                                      12
#define AVR32_HMATRIXB_PRAS14_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS14_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS14_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M4PR                                      16
#define AVR32_HMATRIXB_PRAS14_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS14_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS14_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M5PR                                      20
#define AVR32_HMATRIXB_PRAS14_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS14_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS14_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M6PR                                      24
#define AVR32_HMATRIXB_PRAS14_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS14_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS14_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_M7PR                                      28
#define AVR32_HMATRIXB_PRAS14_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS14_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS14_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS14_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS14_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS15                                   0x000000f8
#define AVR32_HMATRIXB_PRAS15_M0PR                                       0
#define AVR32_HMATRIXB_PRAS15_M0PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRAS15_M0PR_OFFSET                                0
#define AVR32_HMATRIXB_PRAS15_M0PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M1PR                                       4
#define AVR32_HMATRIXB_PRAS15_M1PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRAS15_M1PR_OFFSET                                4
#define AVR32_HMATRIXB_PRAS15_M1PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M2PR                                       8
#define AVR32_HMATRIXB_PRAS15_M2PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRAS15_M2PR_OFFSET                                8
#define AVR32_HMATRIXB_PRAS15_M2PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M3PR                                      12
#define AVR32_HMATRIXB_PRAS15_M3PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRAS15_M3PR_OFFSET                               12
#define AVR32_HMATRIXB_PRAS15_M3PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M4PR                                      16
#define AVR32_HMATRIXB_PRAS15_M4PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRAS15_M4PR_OFFSET                               16
#define AVR32_HMATRIXB_PRAS15_M4PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M5PR                                      20
#define AVR32_HMATRIXB_PRAS15_M5PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRAS15_M5PR_OFFSET                               20
#define AVR32_HMATRIXB_PRAS15_M5PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M6PR                                      24
#define AVR32_HMATRIXB_PRAS15_M6PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRAS15_M6PR_OFFSET                               24
#define AVR32_HMATRIXB_PRAS15_M6PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_M7PR                                      28
#define AVR32_HMATRIXB_PRAS15_M7PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRAS15_M7PR_OFFSET                               28
#define AVR32_HMATRIXB_PRAS15_M7PR_SIZE                                  4
#define AVR32_HMATRIXB_PRAS15_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRAS15_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRAS1_M0PR                                        0
#define AVR32_HMATRIXB_PRAS1_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS1_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS1_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M1PR                                        4
#define AVR32_HMATRIXB_PRAS1_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS1_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS1_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M2PR                                        8
#define AVR32_HMATRIXB_PRAS1_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS1_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS1_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M3PR                                       12
#define AVR32_HMATRIXB_PRAS1_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS1_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS1_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M4PR                                       16
#define AVR32_HMATRIXB_PRAS1_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS1_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS1_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M5PR                                       20
#define AVR32_HMATRIXB_PRAS1_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS1_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS1_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M6PR                                       24
#define AVR32_HMATRIXB_PRAS1_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS1_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS1_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_M7PR                                       28
#define AVR32_HMATRIXB_PRAS1_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS1_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS1_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS1_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS1_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS2                                    0x00000090
#define AVR32_HMATRIXB_PRAS2_M0PR                                        0
#define AVR32_HMATRIXB_PRAS2_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS2_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS2_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M1PR                                        4
#define AVR32_HMATRIXB_PRAS2_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS2_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS2_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M2PR                                        8
#define AVR32_HMATRIXB_PRAS2_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS2_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS2_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M3PR                                       12
#define AVR32_HMATRIXB_PRAS2_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS2_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS2_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M4PR                                       16
#define AVR32_HMATRIXB_PRAS2_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS2_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS2_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M5PR                                       20
#define AVR32_HMATRIXB_PRAS2_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS2_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS2_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M6PR                                       24
#define AVR32_HMATRIXB_PRAS2_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS2_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS2_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_M7PR                                       28
#define AVR32_HMATRIXB_PRAS2_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS2_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS2_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS2_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS2_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS3                                    0x00000098
#define AVR32_HMATRIXB_PRAS3_M0PR                                        0
#define AVR32_HMATRIXB_PRAS3_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS3_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS3_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M1PR                                        4
#define AVR32_HMATRIXB_PRAS3_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS3_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS3_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M2PR                                        8
#define AVR32_HMATRIXB_PRAS3_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS3_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS3_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M3PR                                       12
#define AVR32_HMATRIXB_PRAS3_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS3_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS3_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M4PR                                       16
#define AVR32_HMATRIXB_PRAS3_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS3_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS3_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M5PR                                       20
#define AVR32_HMATRIXB_PRAS3_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS3_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS3_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M6PR                                       24
#define AVR32_HMATRIXB_PRAS3_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS3_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS3_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_M7PR                                       28
#define AVR32_HMATRIXB_PRAS3_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS3_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS3_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS3_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS3_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS4                                    0x000000a0
#define AVR32_HMATRIXB_PRAS4_M0PR                                        0
#define AVR32_HMATRIXB_PRAS4_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS4_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS4_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M1PR                                        4
#define AVR32_HMATRIXB_PRAS4_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS4_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS4_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M2PR                                        8
#define AVR32_HMATRIXB_PRAS4_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS4_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS4_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M3PR                                       12
#define AVR32_HMATRIXB_PRAS4_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS4_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS4_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M4PR                                       16
#define AVR32_HMATRIXB_PRAS4_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS4_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS4_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M5PR                                       20
#define AVR32_HMATRIXB_PRAS4_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS4_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS4_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M6PR                                       24
#define AVR32_HMATRIXB_PRAS4_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS4_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS4_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_M7PR                                       28
#define AVR32_HMATRIXB_PRAS4_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS4_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS4_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS4_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS4_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS5                                    0x000000a8
#define AVR32_HMATRIXB_PRAS5_M0PR                                        0
#define AVR32_HMATRIXB_PRAS5_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS5_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS5_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M1PR                                        4
#define AVR32_HMATRIXB_PRAS5_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS5_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS5_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M2PR                                        8
#define AVR32_HMATRIXB_PRAS5_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS5_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS5_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M3PR                                       12
#define AVR32_HMATRIXB_PRAS5_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS5_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS5_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M4PR                                       16
#define AVR32_HMATRIXB_PRAS5_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS5_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS5_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M5PR                                       20
#define AVR32_HMATRIXB_PRAS5_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS5_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS5_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M6PR                                       24
#define AVR32_HMATRIXB_PRAS5_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS5_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS5_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_M7PR                                       28
#define AVR32_HMATRIXB_PRAS5_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS5_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS5_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS5_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS5_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS6                                    0x000000b0
#define AVR32_HMATRIXB_PRAS6_M0PR                                        0
#define AVR32_HMATRIXB_PRAS6_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS6_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS6_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M1PR                                        4
#define AVR32_HMATRIXB_PRAS6_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS6_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS6_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M2PR                                        8
#define AVR32_HMATRIXB_PRAS6_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS6_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS6_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M3PR                                       12
#define AVR32_HMATRIXB_PRAS6_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS6_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS6_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M4PR                                       16
#define AVR32_HMATRIXB_PRAS6_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS6_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS6_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M5PR                                       20
#define AVR32_HMATRIXB_PRAS6_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS6_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS6_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M6PR                                       24
#define AVR32_HMATRIXB_PRAS6_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS6_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS6_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_M7PR                                       28
#define AVR32_HMATRIXB_PRAS6_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS6_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS6_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS6_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS6_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS7                                    0x000000b8
#define AVR32_HMATRIXB_PRAS7_M0PR                                        0
#define AVR32_HMATRIXB_PRAS7_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS7_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS7_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M1PR                                        4
#define AVR32_HMATRIXB_PRAS7_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS7_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS7_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M2PR                                        8
#define AVR32_HMATRIXB_PRAS7_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS7_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS7_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M3PR                                       12
#define AVR32_HMATRIXB_PRAS7_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS7_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS7_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M4PR                                       16
#define AVR32_HMATRIXB_PRAS7_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS7_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS7_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M5PR                                       20
#define AVR32_HMATRIXB_PRAS7_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS7_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS7_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M6PR                                       24
#define AVR32_HMATRIXB_PRAS7_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS7_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS7_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_M7PR                                       28
#define AVR32_HMATRIXB_PRAS7_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS7_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS7_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS7_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS7_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS8                                    0x000000c0
#define AVR32_HMATRIXB_PRAS8_M0PR                                        0
#define AVR32_HMATRIXB_PRAS8_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS8_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS8_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M1PR                                        4
#define AVR32_HMATRIXB_PRAS8_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS8_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS8_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M2PR                                        8
#define AVR32_HMATRIXB_PRAS8_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS8_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS8_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M3PR                                       12
#define AVR32_HMATRIXB_PRAS8_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS8_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS8_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M4PR                                       16
#define AVR32_HMATRIXB_PRAS8_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS8_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS8_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M5PR                                       20
#define AVR32_HMATRIXB_PRAS8_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS8_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS8_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M6PR                                       24
#define AVR32_HMATRIXB_PRAS8_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS8_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS8_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_M7PR                                       28
#define AVR32_HMATRIXB_PRAS8_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS8_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS8_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS8_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS8_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRAS9                                    0x000000c8
#define AVR32_HMATRIXB_PRAS9_M0PR                                        0
#define AVR32_HMATRIXB_PRAS9_M0PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRAS9_M0PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRAS9_M0PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M1PR                                        4
#define AVR32_HMATRIXB_PRAS9_M1PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRAS9_M1PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRAS9_M1PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M2PR                                        8
#define AVR32_HMATRIXB_PRAS9_M2PR_MASK                          0x00000f00
#define AVR32_HMATRIXB_PRAS9_M2PR_OFFSET                                 8
#define AVR32_HMATRIXB_PRAS9_M2PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M3PR                                       12
#define AVR32_HMATRIXB_PRAS9_M3PR_MASK                          0x0000f000
#define AVR32_HMATRIXB_PRAS9_M3PR_OFFSET                                12
#define AVR32_HMATRIXB_PRAS9_M3PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M4PR                                       16
#define AVR32_HMATRIXB_PRAS9_M4PR_MASK                          0x000f0000
#define AVR32_HMATRIXB_PRAS9_M4PR_OFFSET                                16
#define AVR32_HMATRIXB_PRAS9_M4PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M5PR                                       20
#define AVR32_HMATRIXB_PRAS9_M5PR_MASK                          0x00f00000
#define AVR32_HMATRIXB_PRAS9_M5PR_OFFSET                                20
#define AVR32_HMATRIXB_PRAS9_M5PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M6PR                                       24
#define AVR32_HMATRIXB_PRAS9_M6PR_MASK                          0x0f000000
#define AVR32_HMATRIXB_PRAS9_M6PR_OFFSET                                24
#define AVR32_HMATRIXB_PRAS9_M6PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_M7PR                                       28
#define AVR32_HMATRIXB_PRAS9_M7PR_MASK                          0xf0000000
#define AVR32_HMATRIXB_PRAS9_M7PR_OFFSET                                28
#define AVR32_HMATRIXB_PRAS9_M7PR_SIZE                                   4
#define AVR32_HMATRIXB_PRAS9_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRAS9_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS0                                    0x00000084
#define AVR32_HMATRIXB_PRBS0_M10PR                                       8
#define AVR32_HMATRIXB_PRBS0_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS0_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS0_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M11PR                                      12
#define AVR32_HMATRIXB_PRBS0_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS0_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS0_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M12PR                                      16
#define AVR32_HMATRIXB_PRBS0_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS0_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS0_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M13PR                                      20
#define AVR32_HMATRIXB_PRBS0_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS0_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS0_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M14PR                                      24
#define AVR32_HMATRIXB_PRBS0_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS0_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS0_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M15PR                                      28
#define AVR32_HMATRIXB_PRBS0_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS0_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS0_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS0_M8PR                                        0
#define AVR32_HMATRIXB_PRBS0_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS0_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS0_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS0_M9PR                                        4
#define AVR32_HMATRIXB_PRBS0_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS0_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS0_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS0_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS0_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS1                                    0x0000008c
#define AVR32_HMATRIXB_PRBS10                                   0x000000d4
#define AVR32_HMATRIXB_PRBS10_M10PR                                      8
#define AVR32_HMATRIXB_PRBS10_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS10_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS10_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M11PR                                     12
#define AVR32_HMATRIXB_PRBS10_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS10_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS10_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M12PR                                     16
#define AVR32_HMATRIXB_PRBS10_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS10_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS10_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M13PR                                     20
#define AVR32_HMATRIXB_PRBS10_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS10_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS10_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M14PR                                     24
#define AVR32_HMATRIXB_PRBS10_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS10_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS10_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M15PR                                     28
#define AVR32_HMATRIXB_PRBS10_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS10_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS10_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS10_M8PR                                       0
#define AVR32_HMATRIXB_PRBS10_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS10_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS10_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS10_M9PR                                       4
#define AVR32_HMATRIXB_PRBS10_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS10_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS10_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS10_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS10_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS11                                   0x000000dc
#define AVR32_HMATRIXB_PRBS11_M10PR                                      8
#define AVR32_HMATRIXB_PRBS11_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS11_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS11_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M11PR                                     12
#define AVR32_HMATRIXB_PRBS11_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS11_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS11_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M12PR                                     16
#define AVR32_HMATRIXB_PRBS11_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS11_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS11_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M13PR                                     20
#define AVR32_HMATRIXB_PRBS11_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS11_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS11_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M14PR                                     24
#define AVR32_HMATRIXB_PRBS11_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS11_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS11_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M15PR                                     28
#define AVR32_HMATRIXB_PRBS11_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS11_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS11_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS11_M8PR                                       0
#define AVR32_HMATRIXB_PRBS11_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS11_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS11_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS11_M9PR                                       4
#define AVR32_HMATRIXB_PRBS11_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS11_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS11_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS11_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS11_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS12                                   0x000000e4
#define AVR32_HMATRIXB_PRBS12_M10PR                                      8
#define AVR32_HMATRIXB_PRBS12_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS12_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS12_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M11PR                                     12
#define AVR32_HMATRIXB_PRBS12_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS12_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS12_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M12PR                                     16
#define AVR32_HMATRIXB_PRBS12_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS12_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS12_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M13PR                                     20
#define AVR32_HMATRIXB_PRBS12_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS12_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS12_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M14PR                                     24
#define AVR32_HMATRIXB_PRBS12_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS12_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS12_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M15PR                                     28
#define AVR32_HMATRIXB_PRBS12_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS12_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS12_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS12_M8PR                                       0
#define AVR32_HMATRIXB_PRBS12_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS12_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS12_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS12_M9PR                                       4
#define AVR32_HMATRIXB_PRBS12_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS12_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS12_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS12_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS12_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS13                                   0x000000ec
#define AVR32_HMATRIXB_PRBS13_M10PR                                      8
#define AVR32_HMATRIXB_PRBS13_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS13_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS13_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M11PR                                     12
#define AVR32_HMATRIXB_PRBS13_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS13_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS13_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M12PR                                     16
#define AVR32_HMATRIXB_PRBS13_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS13_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS13_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M13PR                                     20
#define AVR32_HMATRIXB_PRBS13_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS13_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS13_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M14PR                                     24
#define AVR32_HMATRIXB_PRBS13_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS13_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS13_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M15PR                                     28
#define AVR32_HMATRIXB_PRBS13_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS13_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS13_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS13_M8PR                                       0
#define AVR32_HMATRIXB_PRBS13_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS13_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS13_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS13_M9PR                                       4
#define AVR32_HMATRIXB_PRBS13_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS13_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS13_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS13_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS13_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS14                                   0x000000f4
#define AVR32_HMATRIXB_PRBS14_M10PR                                      8
#define AVR32_HMATRIXB_PRBS14_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS14_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS14_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M11PR                                     12
#define AVR32_HMATRIXB_PRBS14_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS14_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS14_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M12PR                                     16
#define AVR32_HMATRIXB_PRBS14_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS14_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS14_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M13PR                                     20
#define AVR32_HMATRIXB_PRBS14_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS14_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS14_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M14PR                                     24
#define AVR32_HMATRIXB_PRBS14_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS14_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS14_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M15PR                                     28
#define AVR32_HMATRIXB_PRBS14_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS14_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS14_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS14_M8PR                                       0
#define AVR32_HMATRIXB_PRBS14_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS14_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS14_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS14_M9PR                                       4
#define AVR32_HMATRIXB_PRBS14_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS14_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS14_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS14_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS14_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS15                                   0x000000fc
#define AVR32_HMATRIXB_PRBS15_M10PR                                      8
#define AVR32_HMATRIXB_PRBS15_M10PR_MASK                        0x00000f00
#define AVR32_HMATRIXB_PRBS15_M10PR_OFFSET                               8
#define AVR32_HMATRIXB_PRBS15_M10PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M11PR                                     12
#define AVR32_HMATRIXB_PRBS15_M11PR_MASK                        0x0000f000
#define AVR32_HMATRIXB_PRBS15_M11PR_OFFSET                              12
#define AVR32_HMATRIXB_PRBS15_M11PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M12PR                                     16
#define AVR32_HMATRIXB_PRBS15_M12PR_MASK                        0x000f0000
#define AVR32_HMATRIXB_PRBS15_M12PR_OFFSET                              16
#define AVR32_HMATRIXB_PRBS15_M12PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M13PR                                     20
#define AVR32_HMATRIXB_PRBS15_M13PR_MASK                        0x00f00000
#define AVR32_HMATRIXB_PRBS15_M13PR_OFFSET                              20
#define AVR32_HMATRIXB_PRBS15_M13PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M14PR                                     24
#define AVR32_HMATRIXB_PRBS15_M14PR_MASK                        0x0f000000
#define AVR32_HMATRIXB_PRBS15_M14PR_OFFSET                              24
#define AVR32_HMATRIXB_PRBS15_M14PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M15PR                                     28
#define AVR32_HMATRIXB_PRBS15_M15PR_MASK                        0xf0000000
#define AVR32_HMATRIXB_PRBS15_M15PR_OFFSET                              28
#define AVR32_HMATRIXB_PRBS15_M15PR_SIZE                                 4
#define AVR32_HMATRIXB_PRBS15_M8PR                                       0
#define AVR32_HMATRIXB_PRBS15_M8PR_MASK                         0x0000000f
#define AVR32_HMATRIXB_PRBS15_M8PR_OFFSET                                0
#define AVR32_HMATRIXB_PRBS15_M8PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS15_M9PR                                       4
#define AVR32_HMATRIXB_PRBS15_M9PR_MASK                         0x000000f0
#define AVR32_HMATRIXB_PRBS15_M9PR_OFFSET                                4
#define AVR32_HMATRIXB_PRBS15_M9PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS15_MASK                              0xffffffff
#define AVR32_HMATRIXB_PRBS15_RESETVALUE                        0x00000000
#define AVR32_HMATRIXB_PRBS1_M10PR                                       8
#define AVR32_HMATRIXB_PRBS1_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS1_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS1_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M11PR                                      12
#define AVR32_HMATRIXB_PRBS1_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS1_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS1_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M12PR                                      16
#define AVR32_HMATRIXB_PRBS1_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS1_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS1_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M13PR                                      20
#define AVR32_HMATRIXB_PRBS1_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS1_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS1_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M14PR                                      24
#define AVR32_HMATRIXB_PRBS1_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS1_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS1_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M15PR                                      28
#define AVR32_HMATRIXB_PRBS1_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS1_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS1_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS1_M8PR                                        0
#define AVR32_HMATRIXB_PRBS1_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS1_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS1_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS1_M9PR                                        4
#define AVR32_HMATRIXB_PRBS1_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS1_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS1_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS1_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS1_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS2                                    0x00000094
#define AVR32_HMATRIXB_PRBS2_M10PR                                       8
#define AVR32_HMATRIXB_PRBS2_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS2_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS2_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M11PR                                      12
#define AVR32_HMATRIXB_PRBS2_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS2_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS2_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M12PR                                      16
#define AVR32_HMATRIXB_PRBS2_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS2_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS2_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M13PR                                      20
#define AVR32_HMATRIXB_PRBS2_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS2_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS2_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M14PR                                      24
#define AVR32_HMATRIXB_PRBS2_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS2_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS2_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M15PR                                      28
#define AVR32_HMATRIXB_PRBS2_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS2_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS2_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS2_M8PR                                        0
#define AVR32_HMATRIXB_PRBS2_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS2_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS2_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS2_M9PR                                        4
#define AVR32_HMATRIXB_PRBS2_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS2_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS2_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS2_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS2_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS3                                    0x0000009c
#define AVR32_HMATRIXB_PRBS3_M10PR                                       8
#define AVR32_HMATRIXB_PRBS3_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS3_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS3_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M11PR                                      12
#define AVR32_HMATRIXB_PRBS3_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS3_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS3_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M12PR                                      16
#define AVR32_HMATRIXB_PRBS3_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS3_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS3_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M13PR                                      20
#define AVR32_HMATRIXB_PRBS3_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS3_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS3_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M14PR                                      24
#define AVR32_HMATRIXB_PRBS3_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS3_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS3_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M15PR                                      28
#define AVR32_HMATRIXB_PRBS3_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS3_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS3_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS3_M8PR                                        0
#define AVR32_HMATRIXB_PRBS3_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS3_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS3_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS3_M9PR                                        4
#define AVR32_HMATRIXB_PRBS3_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS3_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS3_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS3_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS3_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS4                                    0x000000a4
#define AVR32_HMATRIXB_PRBS4_M10PR                                       8
#define AVR32_HMATRIXB_PRBS4_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS4_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS4_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M11PR                                      12
#define AVR32_HMATRIXB_PRBS4_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS4_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS4_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M12PR                                      16
#define AVR32_HMATRIXB_PRBS4_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS4_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS4_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M13PR                                      20
#define AVR32_HMATRIXB_PRBS4_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS4_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS4_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M14PR                                      24
#define AVR32_HMATRIXB_PRBS4_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS4_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS4_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M15PR                                      28
#define AVR32_HMATRIXB_PRBS4_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS4_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS4_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS4_M8PR                                        0
#define AVR32_HMATRIXB_PRBS4_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS4_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS4_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS4_M9PR                                        4
#define AVR32_HMATRIXB_PRBS4_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS4_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS4_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS4_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS4_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS5                                    0x000000ac
#define AVR32_HMATRIXB_PRBS5_M10PR                                       8
#define AVR32_HMATRIXB_PRBS5_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS5_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS5_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M11PR                                      12
#define AVR32_HMATRIXB_PRBS5_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS5_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS5_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M12PR                                      16
#define AVR32_HMATRIXB_PRBS5_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS5_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS5_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M13PR                                      20
#define AVR32_HMATRIXB_PRBS5_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS5_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS5_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M14PR                                      24
#define AVR32_HMATRIXB_PRBS5_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS5_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS5_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M15PR                                      28
#define AVR32_HMATRIXB_PRBS5_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS5_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS5_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS5_M8PR                                        0
#define AVR32_HMATRIXB_PRBS5_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS5_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS5_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS5_M9PR                                        4
#define AVR32_HMATRIXB_PRBS5_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS5_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS5_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS5_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS5_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS6                                    0x000000b4
#define AVR32_HMATRIXB_PRBS6_M10PR                                       8
#define AVR32_HMATRIXB_PRBS6_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS6_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS6_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M11PR                                      12
#define AVR32_HMATRIXB_PRBS6_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS6_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS6_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M12PR                                      16
#define AVR32_HMATRIXB_PRBS6_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS6_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS6_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M13PR                                      20
#define AVR32_HMATRIXB_PRBS6_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS6_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS6_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M14PR                                      24
#define AVR32_HMATRIXB_PRBS6_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS6_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS6_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M15PR                                      28
#define AVR32_HMATRIXB_PRBS6_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS6_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS6_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS6_M8PR                                        0
#define AVR32_HMATRIXB_PRBS6_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS6_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS6_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS6_M9PR                                        4
#define AVR32_HMATRIXB_PRBS6_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS6_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS6_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS6_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS6_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS7                                    0x000000bc
#define AVR32_HMATRIXB_PRBS7_M10PR                                       8
#define AVR32_HMATRIXB_PRBS7_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS7_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS7_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M11PR                                      12
#define AVR32_HMATRIXB_PRBS7_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS7_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS7_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M12PR                                      16
#define AVR32_HMATRIXB_PRBS7_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS7_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS7_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M13PR                                      20
#define AVR32_HMATRIXB_PRBS7_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS7_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS7_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M14PR                                      24
#define AVR32_HMATRIXB_PRBS7_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS7_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS7_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M15PR                                      28
#define AVR32_HMATRIXB_PRBS7_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS7_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS7_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS7_M8PR                                        0
#define AVR32_HMATRIXB_PRBS7_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS7_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS7_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS7_M9PR                                        4
#define AVR32_HMATRIXB_PRBS7_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS7_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS7_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS7_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS7_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS8                                    0x000000c4
#define AVR32_HMATRIXB_PRBS8_M10PR                                       8
#define AVR32_HMATRIXB_PRBS8_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS8_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS8_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M11PR                                      12
#define AVR32_HMATRIXB_PRBS8_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS8_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS8_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M12PR                                      16
#define AVR32_HMATRIXB_PRBS8_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS8_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS8_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M13PR                                      20
#define AVR32_HMATRIXB_PRBS8_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS8_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS8_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M14PR                                      24
#define AVR32_HMATRIXB_PRBS8_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS8_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS8_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M15PR                                      28
#define AVR32_HMATRIXB_PRBS8_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS8_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS8_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS8_M8PR                                        0
#define AVR32_HMATRIXB_PRBS8_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS8_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS8_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS8_M9PR                                        4
#define AVR32_HMATRIXB_PRBS8_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS8_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS8_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS8_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS8_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_PRBS9                                    0x000000cc
#define AVR32_HMATRIXB_PRBS9_M10PR                                       8
#define AVR32_HMATRIXB_PRBS9_M10PR_MASK                         0x00000f00
#define AVR32_HMATRIXB_PRBS9_M10PR_OFFSET                                8
#define AVR32_HMATRIXB_PRBS9_M10PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M11PR                                      12
#define AVR32_HMATRIXB_PRBS9_M11PR_MASK                         0x0000f000
#define AVR32_HMATRIXB_PRBS9_M11PR_OFFSET                               12
#define AVR32_HMATRIXB_PRBS9_M11PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M12PR                                      16
#define AVR32_HMATRIXB_PRBS9_M12PR_MASK                         0x000f0000
#define AVR32_HMATRIXB_PRBS9_M12PR_OFFSET                               16
#define AVR32_HMATRIXB_PRBS9_M12PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M13PR                                      20
#define AVR32_HMATRIXB_PRBS9_M13PR_MASK                         0x00f00000
#define AVR32_HMATRIXB_PRBS9_M13PR_OFFSET                               20
#define AVR32_HMATRIXB_PRBS9_M13PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M14PR                                      24
#define AVR32_HMATRIXB_PRBS9_M14PR_MASK                         0x0f000000
#define AVR32_HMATRIXB_PRBS9_M14PR_OFFSET                               24
#define AVR32_HMATRIXB_PRBS9_M14PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M15PR                                      28
#define AVR32_HMATRIXB_PRBS9_M15PR_MASK                         0xf0000000
#define AVR32_HMATRIXB_PRBS9_M15PR_OFFSET                               28
#define AVR32_HMATRIXB_PRBS9_M15PR_SIZE                                  4
#define AVR32_HMATRIXB_PRBS9_M8PR                                        0
#define AVR32_HMATRIXB_PRBS9_M8PR_MASK                          0x0000000f
#define AVR32_HMATRIXB_PRBS9_M8PR_OFFSET                                 0
#define AVR32_HMATRIXB_PRBS9_M8PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS9_M9PR                                        4
#define AVR32_HMATRIXB_PRBS9_M9PR_MASK                          0x000000f0
#define AVR32_HMATRIXB_PRBS9_M9PR_OFFSET                                 4
#define AVR32_HMATRIXB_PRBS9_M9PR_SIZE                                   4
#define AVR32_HMATRIXB_PRBS9_MASK                               0xffffffff
#define AVR32_HMATRIXB_PRBS9_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_RCB0                                              0
#define AVR32_HMATRIXB_RCB0_MASK                                0x00000001
#define AVR32_HMATRIXB_RCB0_OFFSET                                       0
#define AVR32_HMATRIXB_RCB0_SIZE                                         1
#define AVR32_HMATRIXB_RCB1                                              1
#define AVR32_HMATRIXB_RCB10                                            10
#define AVR32_HMATRIXB_RCB10_MASK                               0x00000400
#define AVR32_HMATRIXB_RCB10_OFFSET                                     10
#define AVR32_HMATRIXB_RCB10_SIZE                                        1
#define AVR32_HMATRIXB_RCB11                                            11
#define AVR32_HMATRIXB_RCB11_MASK                               0x00000800
#define AVR32_HMATRIXB_RCB11_OFFSET                                     11
#define AVR32_HMATRIXB_RCB11_SIZE                                        1
#define AVR32_HMATRIXB_RCB12                                            12
#define AVR32_HMATRIXB_RCB12_MASK                               0x00001000
#define AVR32_HMATRIXB_RCB12_OFFSET                                     12
#define AVR32_HMATRIXB_RCB12_SIZE                                        1
#define AVR32_HMATRIXB_RCB13                                            13
#define AVR32_HMATRIXB_RCB13_MASK                               0x00002000
#define AVR32_HMATRIXB_RCB13_OFFSET                                     13
#define AVR32_HMATRIXB_RCB13_SIZE                                        1
#define AVR32_HMATRIXB_RCB14                                            14
#define AVR32_HMATRIXB_RCB14_MASK                               0x00004000
#define AVR32_HMATRIXB_RCB14_OFFSET                                     14
#define AVR32_HMATRIXB_RCB14_SIZE                                        1
#define AVR32_HMATRIXB_RCB15                                            15
#define AVR32_HMATRIXB_RCB15_MASK                               0x00008000
#define AVR32_HMATRIXB_RCB15_OFFSET                                     15
#define AVR32_HMATRIXB_RCB15_SIZE                                        1
#define AVR32_HMATRIXB_RCB1_MASK                                0x00000002
#define AVR32_HMATRIXB_RCB1_OFFSET                                       1
#define AVR32_HMATRIXB_RCB1_SIZE                                         1
#define AVR32_HMATRIXB_RCB2                                              2
#define AVR32_HMATRIXB_RCB2_MASK                                0x00000004
#define AVR32_HMATRIXB_RCB2_OFFSET                                       2
#define AVR32_HMATRIXB_RCB2_SIZE                                         1
#define AVR32_HMATRIXB_RCB3                                              3
#define AVR32_HMATRIXB_RCB3_MASK                                0x00000008
#define AVR32_HMATRIXB_RCB3_OFFSET                                       3
#define AVR32_HMATRIXB_RCB3_SIZE                                         1
#define AVR32_HMATRIXB_RCB4                                              4
#define AVR32_HMATRIXB_RCB4_MASK                                0x00000010
#define AVR32_HMATRIXB_RCB4_OFFSET                                       4
#define AVR32_HMATRIXB_RCB4_SIZE                                         1
#define AVR32_HMATRIXB_RCB5                                              5
#define AVR32_HMATRIXB_RCB5_MASK                                0x00000020
#define AVR32_HMATRIXB_RCB5_OFFSET                                       5
#define AVR32_HMATRIXB_RCB5_SIZE                                         1
#define AVR32_HMATRIXB_RCB6                                              6
#define AVR32_HMATRIXB_RCB6_MASK                                0x00000040
#define AVR32_HMATRIXB_RCB6_OFFSET                                       6
#define AVR32_HMATRIXB_RCB6_SIZE                                         1
#define AVR32_HMATRIXB_RCB7                                              7
#define AVR32_HMATRIXB_RCB7_MASK                                0x00000080
#define AVR32_HMATRIXB_RCB7_OFFSET                                       7
#define AVR32_HMATRIXB_RCB7_SIZE                                         1
#define AVR32_HMATRIXB_RCB8                                              8
#define AVR32_HMATRIXB_RCB8_MASK                                0x00000100
#define AVR32_HMATRIXB_RCB8_OFFSET                                       8
#define AVR32_HMATRIXB_RCB8_SIZE                                         1
#define AVR32_HMATRIXB_RCB9                                              9
#define AVR32_HMATRIXB_RCB9_MASK                                0x00000200
#define AVR32_HMATRIXB_RCB9_OFFSET                                       9
#define AVR32_HMATRIXB_RCB9_SIZE                                         1
#define AVR32_HMATRIXB_ROUND_ROBIN                              0x00000000
#define AVR32_HMATRIXB_SCFG0                                    0x00000040
#define AVR32_HMATRIXB_SCFG0_ARBT                                       24
#define AVR32_HMATRIXB_SCFG0_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG0_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG0_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG0_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG0_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG0_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG0_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG0_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG0_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG0_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG0_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG0_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG0_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG0_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG0_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG0_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG1                                    0x00000044
#define AVR32_HMATRIXB_SCFG10                                   0x00000068
#define AVR32_HMATRIXB_SCFG10_ARBT                                      24
#define AVR32_HMATRIXB_SCFG10_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG10_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG10_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG10_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG10_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG10_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG10_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG10_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG10_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG10_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG10_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG10_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG10_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG10_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG10_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG10_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG11                                   0x0000006c
#define AVR32_HMATRIXB_SCFG11_ARBT                                      24
#define AVR32_HMATRIXB_SCFG11_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG11_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG11_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG11_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG11_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG11_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG11_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG11_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG11_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG11_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG11_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG11_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG11_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG11_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG11_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG11_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG12                                   0x00000070
#define AVR32_HMATRIXB_SCFG12_ARBT                                      24
#define AVR32_HMATRIXB_SCFG12_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG12_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG12_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG12_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG12_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG12_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG12_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG12_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG12_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG12_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG12_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG12_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG12_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG12_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG12_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG12_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG13                                   0x00000074
#define AVR32_HMATRIXB_SCFG13_ARBT                                      24
#define AVR32_HMATRIXB_SCFG13_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG13_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG13_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG13_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG13_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG13_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG13_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG13_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG13_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG13_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG13_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG13_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG13_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG13_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG13_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG13_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG14                                   0x00000078
#define AVR32_HMATRIXB_SCFG14_ARBT                                      24
#define AVR32_HMATRIXB_SCFG14_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG14_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG14_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG14_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG14_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG14_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG14_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG14_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG14_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG14_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG14_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG14_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG14_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG14_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG14_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG14_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG15                                   0x0000007c
#define AVR32_HMATRIXB_SCFG15_ARBT                                      24
#define AVR32_HMATRIXB_SCFG15_ARBT_FIXED_PRIORITY               0x00000001
#define AVR32_HMATRIXB_SCFG15_ARBT_MASK                         0x01000000
#define AVR32_HMATRIXB_SCFG15_ARBT_OFFSET                               24
#define AVR32_HMATRIXB_SCFG15_ARBT_ROUND_ROBIN                  0x00000000
#define AVR32_HMATRIXB_SCFG15_ARBT_SIZE                                  1
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE                              16
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_FIXED_DEFAULT        0x00000002
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_LAST_DEFAULT         0x00000001
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_MASK                 0x00030000
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_NO_DEFAULT           0x00000000
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_OFFSET                       16
#define AVR32_HMATRIXB_SCFG15_DEFMSTR_TYPE_SIZE                          2
#define AVR32_HMATRIXB_SCFG15_FIXED_DEFMSTR                             18
#define AVR32_HMATRIXB_SCFG15_FIXED_DEFMSTR_MASK                0x003c0000
#define AVR32_HMATRIXB_SCFG15_FIXED_DEFMSTR_OFFSET                      18
#define AVR32_HMATRIXB_SCFG15_FIXED_DEFMSTR_SIZE                         4
#define AVR32_HMATRIXB_SCFG15_MASK                              0x013f00ff
#define AVR32_HMATRIXB_SCFG15_RESETVALUE                        0x00000010
#define AVR32_HMATRIXB_SCFG15_SLOT_CYCLE                                 0
#define AVR32_HMATRIXB_SCFG15_SLOT_CYCLE_MASK                   0x000000ff
#define AVR32_HMATRIXB_SCFG15_SLOT_CYCLE_OFFSET                          0
#define AVR32_HMATRIXB_SCFG15_SLOT_CYCLE_SIZE                            8
#define AVR32_HMATRIXB_SCFG1_ARBT                                       24
#define AVR32_HMATRIXB_SCFG1_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG1_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG1_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG1_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG1_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG1_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG1_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG1_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG1_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG1_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG1_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG1_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG1_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG1_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG1_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG1_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG2                                    0x00000048
#define AVR32_HMATRIXB_SCFG2_ARBT                                       24
#define AVR32_HMATRIXB_SCFG2_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG2_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG2_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG2_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG2_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG2_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG2_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG2_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG2_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG2_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG2_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG2_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG2_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG2_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG2_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG2_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG3                                    0x0000004c
#define AVR32_HMATRIXB_SCFG3_ARBT                                       24
#define AVR32_HMATRIXB_SCFG3_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG3_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG3_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG3_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG3_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG3_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG3_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG3_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG3_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG3_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG3_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG3_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG3_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG3_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG3_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG3_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG4                                    0x00000050
#define AVR32_HMATRIXB_SCFG4_ARBT                                       24
#define AVR32_HMATRIXB_SCFG4_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG4_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG4_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG4_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG4_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG4_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG4_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG4_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG4_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG4_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG4_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG4_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG4_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG4_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG4_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG4_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG5                                    0x00000054
#define AVR32_HMATRIXB_SCFG5_ARBT                                       24
#define AVR32_HMATRIXB_SCFG5_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG5_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG5_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG5_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG5_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG5_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG5_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG5_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG5_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG5_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG5_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG5_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG5_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG5_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG5_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG5_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG6                                    0x00000058
#define AVR32_HMATRIXB_SCFG6_ARBT                                       24
#define AVR32_HMATRIXB_SCFG6_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG6_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG6_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG6_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG6_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG6_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG6_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG6_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG6_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG6_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG6_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG6_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG6_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG6_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG6_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG6_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG7                                    0x0000005c
#define AVR32_HMATRIXB_SCFG7_ARBT                                       24
#define AVR32_HMATRIXB_SCFG7_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG7_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG7_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG7_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG7_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG7_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG7_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG7_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG7_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG7_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG7_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG7_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG7_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG7_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG7_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG7_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG8                                    0x00000060
#define AVR32_HMATRIXB_SCFG8_ARBT                                       24
#define AVR32_HMATRIXB_SCFG8_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG8_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG8_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG8_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG8_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG8_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG8_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG8_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG8_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG8_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG8_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG8_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG8_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG8_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG8_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG8_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SCFG9                                    0x00000064
#define AVR32_HMATRIXB_SCFG9_ARBT                                       24
#define AVR32_HMATRIXB_SCFG9_ARBT_FIXED_PRIORITY                0x00000001
#define AVR32_HMATRIXB_SCFG9_ARBT_MASK                          0x01000000
#define AVR32_HMATRIXB_SCFG9_ARBT_OFFSET                                24
#define AVR32_HMATRIXB_SCFG9_ARBT_ROUND_ROBIN                   0x00000000
#define AVR32_HMATRIXB_SCFG9_ARBT_SIZE                                   1
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE                               16
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_FIXED_DEFAULT         0x00000002
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_LAST_DEFAULT          0x00000001
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_MASK                  0x00030000
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_NO_DEFAULT            0x00000000
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_OFFSET                        16
#define AVR32_HMATRIXB_SCFG9_DEFMSTR_TYPE_SIZE                           2
#define AVR32_HMATRIXB_SCFG9_FIXED_DEFMSTR                              18
#define AVR32_HMATRIXB_SCFG9_FIXED_DEFMSTR_MASK                 0x003c0000
#define AVR32_HMATRIXB_SCFG9_FIXED_DEFMSTR_OFFSET                       18
#define AVR32_HMATRIXB_SCFG9_FIXED_DEFMSTR_SIZE                          4
#define AVR32_HMATRIXB_SCFG9_MASK                               0x013f00ff
#define AVR32_HMATRIXB_SCFG9_RESETVALUE                         0x00000010
#define AVR32_HMATRIXB_SCFG9_SLOT_CYCLE                                  0
#define AVR32_HMATRIXB_SCFG9_SLOT_CYCLE_MASK                    0x000000ff
#define AVR32_HMATRIXB_SCFG9_SLOT_CYCLE_OFFSET                           0
#define AVR32_HMATRIXB_SCFG9_SLOT_CYCLE_SIZE                             8
#define AVR32_HMATRIXB_SFR                                               0
#define AVR32_HMATRIXB_SFR0                                     0x00000110
#define AVR32_HMATRIXB_SFR0_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR0_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR0_SFR                                          0
#define AVR32_HMATRIXB_SFR0_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR0_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR0_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR1                                     0x00000114
#define AVR32_HMATRIXB_SFR10                                    0x00000138
#define AVR32_HMATRIXB_SFR10_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR10_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR10_SFR                                         0
#define AVR32_HMATRIXB_SFR10_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR10_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR10_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR11                                    0x0000013c
#define AVR32_HMATRIXB_SFR11_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR11_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR11_SFR                                         0
#define AVR32_HMATRIXB_SFR11_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR11_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR11_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR12                                    0x00000140
#define AVR32_HMATRIXB_SFR12_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR12_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR12_SFR                                         0
#define AVR32_HMATRIXB_SFR12_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR12_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR12_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR13                                    0x00000144
#define AVR32_HMATRIXB_SFR13_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR13_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR13_SFR                                         0
#define AVR32_HMATRIXB_SFR13_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR13_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR13_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR14                                    0x00000148
#define AVR32_HMATRIXB_SFR14_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR14_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR14_SFR                                         0
#define AVR32_HMATRIXB_SFR14_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR14_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR14_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR15                                    0x0000014c
#define AVR32_HMATRIXB_SFR15_MASK                               0xffffffff
#define AVR32_HMATRIXB_SFR15_RESETVALUE                         0x00000000
#define AVR32_HMATRIXB_SFR15_SFR                                         0
#define AVR32_HMATRIXB_SFR15_SFR_MASK                           0xffffffff
#define AVR32_HMATRIXB_SFR15_SFR_OFFSET                                  0
#define AVR32_HMATRIXB_SFR15_SFR_SIZE                                   32
#define AVR32_HMATRIXB_SFR1_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR1_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR1_SFR                                          0
#define AVR32_HMATRIXB_SFR1_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR1_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR1_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR2                                     0x00000118
#define AVR32_HMATRIXB_SFR2_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR2_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR2_SFR                                          0
#define AVR32_HMATRIXB_SFR2_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR2_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR2_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR3                                     0x0000011c
#define AVR32_HMATRIXB_SFR3_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR3_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR3_SFR                                          0
#define AVR32_HMATRIXB_SFR3_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR3_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR3_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR4                                     0x00000120
#define AVR32_HMATRIXB_SFR4_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR4_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR4_SFR                                          0
#define AVR32_HMATRIXB_SFR4_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR4_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR4_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR5                                     0x00000124
#define AVR32_HMATRIXB_SFR5_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR5_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR5_SFR                                          0
#define AVR32_HMATRIXB_SFR5_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR5_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR5_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR6                                     0x00000128
#define AVR32_HMATRIXB_SFR6_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR6_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR6_SFR                                          0
#define AVR32_HMATRIXB_SFR6_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR6_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR6_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR7                                     0x0000012c
#define AVR32_HMATRIXB_SFR7_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR7_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR7_SFR                                          0
#define AVR32_HMATRIXB_SFR7_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR7_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR7_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR8                                     0x00000130
#define AVR32_HMATRIXB_SFR8_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR8_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR8_SFR                                          0
#define AVR32_HMATRIXB_SFR8_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR8_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR8_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR9                                     0x00000134
#define AVR32_HMATRIXB_SFR9_MASK                                0xffffffff
#define AVR32_HMATRIXB_SFR9_RESETVALUE                          0x00000000
#define AVR32_HMATRIXB_SFR9_SFR                                          0
#define AVR32_HMATRIXB_SFR9_SFR_MASK                            0xffffffff
#define AVR32_HMATRIXB_SFR9_SFR_OFFSET                                   0
#define AVR32_HMATRIXB_SFR9_SFR_SIZE                                    32
#define AVR32_HMATRIXB_SFR_MASK                                 0xffffffff
#define AVR32_HMATRIXB_SFR_OFFSET                                        0
#define AVR32_HMATRIXB_SFR_SIZE                                         32
#define AVR32_HMATRIXB_SINGLE                                   0x00000001
#define AVR32_HMATRIXB_SIXTEEN_BEAT                             0x00000004
#define AVR32_HMATRIXB_SLOT_CYCLE                                        0
#define AVR32_HMATRIXB_SLOT_CYCLE_MASK                          0x000000ff
#define AVR32_HMATRIXB_SLOT_CYCLE_OFFSET                                 0
#define AVR32_HMATRIXB_SLOT_CYCLE_SIZE                                   8
#define AVR32_HMATRIXB_ULBT                                              0
#define AVR32_HMATRIXB_ULBT_EIGHT_BEAT                          0x00000003
#define AVR32_HMATRIXB_ULBT_FOUR_BEAT                           0x00000002
#define AVR32_HMATRIXB_ULBT_INFINITE                            0x00000000
#define AVR32_HMATRIXB_ULBT_MASK                                0x00000007
#define AVR32_HMATRIXB_ULBT_OFFSET                                       0
#define AVR32_HMATRIXB_ULBT_SINGLE                              0x00000001
#define AVR32_HMATRIXB_ULBT_SIXTEEN_BEAT                        0x00000004
#define AVR32_HMATRIXB_ULBT_SIZE                                         3




#ifdef __AVR32_ABI_COMPILER__


typedef struct avr32_hmatrixb_mcfg_t {
    unsigned int                 :29;
    unsigned int ulbt            : 3;
} avr32_hmatrixb_mcfg_t;



typedef struct avr32_hmatrixb_scfg_t {
    unsigned int                 : 7;
    unsigned int arbt            : 1;
    unsigned int                 : 2;
    unsigned int fixed_defmstr   : 4;
    unsigned int defmstr_type    : 2;
    unsigned int                 : 8;
    unsigned int slot_cycle      : 8;
} avr32_hmatrixb_scfg_t;



typedef struct avr32_hmatrixb_pras_t {
    unsigned int m7pr            : 4;
    unsigned int m6pr            : 4;
    unsigned int m5pr            : 4;
    unsigned int m4pr            : 4;
    unsigned int m3pr            : 4;
    unsigned int m2pr            : 4;
    unsigned int m1pr            : 4;
    unsigned int m0pr            : 4;
} avr32_hmatrixb_pras_t;



typedef struct avr32_hmatrixb_prbs_t {
    unsigned int m15pr           : 4;
    unsigned int m14pr           : 4;
    unsigned int m13pr           : 4;
    unsigned int m12pr           : 4;
    unsigned int m11pr           : 4;
    unsigned int m10pr           : 4;
    unsigned int m9pr            : 4;
    unsigned int m8pr            : 4;
} avr32_hmatrixb_prbs_t;



typedef struct avr32_hmatrixb_mrcr_t {
    unsigned int                 :16;
    unsigned int rcb15           : 1;
    unsigned int rcb14           : 1;
    unsigned int rcb13           : 1;
    unsigned int rcb12           : 1;
    unsigned int rcb11           : 1;
    unsigned int rcb10           : 1;
    unsigned int rcb9            : 1;
    unsigned int rcb8            : 1;
    unsigned int rcb7            : 1;
    unsigned int rcb6            : 1;
    unsigned int rcb5            : 1;
    unsigned int rcb4            : 1;
    unsigned int rcb3            : 1;
    unsigned int rcb2            : 1;
    unsigned int rcb1            : 1;
    unsigned int rcb0            : 1;
} avr32_hmatrixb_mrcr_t;


typedef struct avr32_hmatrixb_prs_t {
  union {
          unsigned long                  pras      ;//0x0000
          avr32_hmatrixb_pras_t          PRAS      ;
  };
  union {
          unsigned long                  prbs      ;//0x0004
          avr32_hmatrixb_prbs_t          PRBS      ;
  };
} avr32_hmatrixb_prs_t;


typedef struct avr32_hmatrixb_t {
  union {
          unsigned long                  mcfg      [16];//0x0000
          avr32_hmatrixb_mcfg_t          MCFG      [16];
  };
  union {
          unsigned long                  scfg      [16];//0x0040
          avr32_hmatrixb_scfg_t          SCFG      [16];
  };
  avr32_hmatrixb_prs_t prs[16];//0x80
  union {
          unsigned long                  mrcr      ;//0x0100
          avr32_hmatrixb_mrcr_t          MRCR      ;
  };
          unsigned int                   :32       ;//0x0104
          unsigned int                   :32       ;//0x0108
          unsigned int                   :32       ;//0x010c
          unsigned long                  sfr       [16];//0x0110
} avr32_hmatrixb_t;



/*#ifdef __AVR32_ABI_COMPILER__*/
#endif

/*#ifdef AVR32_HMATRIXB_130_H_INCLUDED*/
#endif

