/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.CssListStyleType;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssContent
extends org.w3c.css.properties.css.CssContent {
    protected static CssIdent[] allowed_values;

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssContent() {
    }

    public CssContent(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 1: 
                case 2: {
                    values.add(val);
                    break;
                }
                case 11: {
                    CssContent.checkCounterFunction(ac, this, val);
                    values.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        values.add(inherit);
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.value = CssContent.getMatchingIdent((CssIdent)val);
                    if (this.value != null) {
                        values.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static void checkCounterFunction(ApplContext ac, CssProperty property, CssValue function) throws InvalidParamException {
        CssFunction f = (CssFunction)function;
        switch (f.getName()) {
            case "counter": {
                CssExpression exp = f.getParameters();
                if (exp.getCount() > 2) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                CssValue v = exp.getValue();
                char op = exp.getOperator();
                if (v.getType() != 0) {
                    throw new InvalidParamException("value", v, property.getPropertyName(), ac);
                }
                exp.next();
                if (exp.end()) break;
                if (op != ',') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                v = exp.getValue();
                if (v.getType() != 0 || null != CssListStyleType.getAllowedIdent((CssIdent)v)) break;
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
            case "counters": {
                CssExpression exp = f.getParameters();
                if (exp.getCount() < 2 || exp.getCount() > 3) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                CssValue v = exp.getValue();
                char op = exp.getOperator();
                if (v.getType() != 0) {
                    throw new InvalidParamException("value", v, property.getPropertyName(), ac);
                }
                exp.next();
                if (op != ',') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                v = exp.getValue();
                op = exp.getOperator();
                if (v.getType() != 1) {
                    throw new InvalidParamException("value", v, property.getPropertyName(), ac);
                }
                exp.next();
                if (exp.end()) break;
                if (op != ',') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                v = exp.getValue();
                if (v.getType() != 0 || null != CssListStyleType.getAllowedIdent((CssIdent)v)) break;
                throw new InvalidParamException("value", v, property.getPropertyName(), ac);
            }
            default: {
                throw new InvalidParamException("value", function, property.getPropertyName(), ac);
            }
        }
    }

    public CssContent(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_values = new String[]{"open-quote", "close-quote", "no-open-quote", "no-close-quote"};
        int i = 0;
        allowed_values = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssContent.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

