/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.OneOfTypeBinderCreationListener;
import org.gradle.model.internal.registry.PathBinderCreationListener;

@NotThreadSafe
public class RuleBinder {
    private final ModelBinding subjectBinding;
    private final ModelAction action;
    private final List<BindingPredicate> inputReferences;
    private final Collection<RuleBinder> binders;
    private int inputsBound;
    private final List<ModelBinding> inputBindings;

    public RuleBinder(BindingPredicate subjectReference, List<BindingPredicate> inputReferences, ModelAction action, Collection<RuleBinder> binders) {
        this.action = action;
        this.inputReferences = inputReferences;
        this.binders = binders;
        this.subjectBinding = RuleBinder.binding(subjectReference, action.getDescriptor(), true, new Action<ModelBinding>(){

            public void execute(ModelBinding modelBinding) {
                BindingPredicate predicate;
                ModelNodeInternal node = modelBinding.getNode();
                if (node.isAtLeast((predicate = modelBinding.getPredicate()).getState())) {
                    throw new IllegalStateException(String.format("Cannot add rule %s for model element '%s' at state %s as this element is already at state %s.", new Object[]{modelBinding.referrer, node.getPath(), predicate.getState().previous(), node.getState()}));
                }
                RuleBinder.this.maybeFire();
            }
        });
        this.inputBindings = RuleBinder.inputBindings(inputReferences, action.getDescriptor(), new Action<ModelBinding>(){

            public void execute(ModelBinding modelBinding) {
                ModelNodeInternal node = modelBinding.getNode();
                BindingPredicate reference = modelBinding.getPredicate();
                if (node.getState().compareTo(reference.getState()) > 0) {
                    throw new IllegalStateException(String.format("Cannot add rule %s with input model element '%s' at state %s as this element is already at state %s.", new Object[]{modelBinding.referrer, node.getPath(), reference.getState(), node.getState()}));
                }
                ++RuleBinder.this.inputsBound;
                RuleBinder.this.maybeFire();
            }
        });
        if (!this.isBound()) {
            binders.add(this);
        }
    }

    private static List<ModelBinding> inputBindings(List<BindingPredicate> inputReferences, ModelRuleDescriptor descriptor, Action<ModelBinding> inputBindAction) {
        if (inputReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelBinding> bindings = new ArrayList<ModelBinding>(inputReferences.size());
        for (BindingPredicate inputReference : inputReferences) {
            bindings.add(RuleBinder.binding(inputReference, descriptor, false, inputBindAction));
        }
        return bindings;
    }

    private static ModelBinding binding(BindingPredicate reference, ModelRuleDescriptor descriptor, boolean writable, Action<ModelBinding> bindAction) {
        if (reference.getPath() != null) {
            return new PathBinderCreationListener(descriptor, reference, writable, bindAction);
        }
        return new OneOfTypeBinderCreationListener(descriptor, reference, writable, bindAction);
    }

    public ModelAction getAction() {
        return this.action;
    }

    public ModelBinding getSubjectBinding() {
        return this.subjectBinding;
    }

    public List<ModelBinding> getInputBindings() {
        return this.inputBindings;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.action.getDescriptor();
    }

    private void maybeFire() {
        if (this.isBound()) {
            this.binders.remove(this);
        }
    }

    public boolean isBound() {
        return this.subjectBinding.isBound() && this.inputsBound == this.inputReferences.size();
    }

    public String toString() {
        return String.format("%s[%s - %s]", this.getClass().getSimpleName(), this.subjectBinding, this.action.getDescriptor());
    }
}

