/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.model;

import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.FilteringCache;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableAbstractRow;
import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableCollectionRow
extends TableAbstractRow {
    protected final List<TableFilteringRow> myChildren = new ArrayList<TableFilteringRow>();
    protected List<TableFilteringRow> myVisibleChildren = Collections.emptyList();
    private String lastFilter = "";
    private int myIDMaxWidth = 0;
    private boolean isCollectionExpanded = true;
    protected IssueTableModel myModel;
    protected FilteringCache myFilteringCache = new FilteringCache();
    private int myVisibleLenght = 1;

    public TableCollectionRow(IssueTableModel model) {
        this.myModel = model;
    }

    public void updateFiltering(boolean forceUpdate) {
        String filter = this.myModel.getFilterString();
        if (!filter.equals(this.lastFilter) || forceUpdate) {
            this.lastFilter = filter;
            if (this.isCollectionExpanded) {
                if (!this.myModel.isFiltering() || filter.equals("")) {
                    this.myVisibleChildren = this.myChildren;
                } else {
                    Pattern pattern = this.myModel.getFilterPattern();
                    this.myVisibleChildren = this.myFilteringCache.include(this.myChildren, pattern);
                }
                this.myVisibleLenght = this.myVisibleChildren.size() + 1;
            } else {
                this.myVisibleChildren = Collections.emptyList();
                this.myVisibleLenght = 1;
            }
        }
    }

    public int getPosByChild(TableFilteringRow row) {
        return this.myVisibleChildren.indexOf(row);
    }

    public TableFilteringRow getChildByPos(int index) {
        if (index >= 0 && index < this.myVisibleChildren.size()) {
            return this.myVisibleChildren.get(index);
        }
        return null;
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.myVisibleChildren.clear();
        this.myFilteringCache.clear();
    }

    public boolean isCollectionExpanded() {
        return this.isCollectionExpanded;
    }

    public void setCollectionExpanded(boolean expanded) {
        if (this.isCollectionExpanded != expanded) {
            this.isCollectionExpanded = expanded;
            this.updateFiltering(true);
            this.myModel.fireTableDataChanged();
        }
    }

    public int getCollectionSize() {
        return this.myChildren.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Expanded: ");
        if (this.isCollectionExpanded) {
            buffer.append("yes");
        } else {
            buffer.append("no");
        }
        buffer.append(" childs:");
        buffer.append(this.myChildren.size());
        return buffer.toString();
    }

    public final List<TableFilteringRow> getChildrenAsArray() {
        return Collections.unmodifiableList(this.myChildren);
    }

    public int getCollectionVisibleLength() {
        return this.myVisibleLenght;
    }

    public void addChild(TableFilteringRow row) {
        this.myChildren.add(row);
    }

    protected void insert(ArtifactInfoRow artifactNode, int index) {
        this.myChildren.add(index, artifactNode);
    }

    public void removeChild(TableFilteringRow row) {
        this.myChildren.remove(row);
    }

    public void forEachChild(TObjectProcedure<TableFilteringRow> proc) {
        for (TableFilteringRow child : this.myChildren) {
            proc.execute((Object)child);
        }
    }

    public void updateColumnWidth(int i, String columnText) {
        if (i == 0 && columnText.length() > this.myIDMaxWidth) {
            this.myIDMaxWidth = columnText.length();
        }
    }

    public int getColuntWidth(int i) {
        return this.myIDMaxWidth;
    }
}

