/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.model;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.toolwindow.table.model.ArtifactCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import com.almworks.tracklink.util.Utils;

public class ArtifactInfoRow
extends TableFilteringRow {
    private String myUrl;
    private ArtifactInfo myInfo;
    private boolean isFirstCheckStackTrace = true;
    private boolean isDataCached = false;
    private boolean hasStackTrace = false;
    private String myStringID = "";
    private String mySummary = "";
    private String myFullText = "";
    private int myNumID;
    private boolean myIsResolved = false;

    public ArtifactInfoRow(String url, ArtifactInfoCache cache, ArtifactCollectionRow parent) {
        super(parent);
        this.myUrl = url;
        this.setArtifactInfo(cache.getArtifactInfoSnapshot(url));
    }

    public void dereference() {
        super.dereference();
        this.myStringID = null;
        this.mySummary = null;
        this.myFullText = null;
        this.myInfo = null;
        this.myUrl = null;
    }

    public boolean hasStackTrace() {
        if (this.isFirstCheckStackTrace) {
            this.hasStackTrace = Utils.hasStackTrace(this.myFullText);
            this.isFirstCheckStackTrace = false;
        }
        return this.hasStackTrace;
    }

    public String getStackTrace() {
        String presentation;
        if (this.myInfo.getApplicableKeys().contains(GenericKeys.LONG_DESCRIPTION_HTML) && (presentation = (String)this.myInfo.getPresentation(GenericKeys.LONG_DESCRIPTION_HTML)) != null) {
            return Utils.extractStackTrace(presentation);
        }
        return Utils.extractStackTrace(this.myFullText);
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getColumn(int index) {
        switch (index) {
            case 0: {
                return this.myStringID;
            }
            case 1: {
                return this.mySummary;
            }
        }
        return "";
    }

    public String getText() {
        if (!this.myFullText.equals("")) {
            return this.myFullText;
        }
        return this.getColumn(0) + this.getColumn(1);
    }

    public int getID() {
        return this.myNumID;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.myInfo;
    }

    public void setArtifactInfo(ArtifactInfo info) {
        assert (info != null);
        this.myInfo = info;
        this.isFirstCheckStackTrace = true;
        this.cacheData();
        this.getParent().updateColumnWidth(0, this.myStringID != null ? this.myStringID : "");
    }

    public boolean isResolved() {
        return this.myIsResolved;
    }

    private void cacheData() {
        String presentation;
        if (this.myInfo.getApplicableKeys().contains(GenericKeys.ID) && (presentation = (String)this.myInfo.getPresentation(GenericKeys.ID)) != null) {
            this.myStringID = presentation;
            this.myNumID = !this.myStringID.equals("") ? Utils.getNumericID(this.myStringID) : 0;
        }
        if (this.myInfo.getApplicableKeys().contains(GenericKeys.SUMMARY) && (presentation = (String)this.myInfo.getPresentation(GenericKeys.SUMMARY)) != null) {
            this.mySummary = presentation;
        }
        if (this.myInfo.getApplicableKeys().contains(GenericKeys.LONG_DESCRIPTION_HTML)) {
            presentation = (String)this.myInfo.getPresentation(GenericKeys.LONG_DESCRIPTION_HTML);
            if (presentation != null) {
                this.myFullText = Utils.removeHTMLEntities(presentation);
                this.myIsResolved = Utils.isResolved(this.myFullText);
            }
        } else {
            this.myFullText = this.myUrl + ' ' + this.mySummary;
        }
    }
}

