/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javolution.lang.Reusable;

public final class UTF8StreamWriter
extends Writer
implements Reusable {
    private OutputStream _outputStream;
    private final byte[] _bytes;
    private int _index;
    private char _highSurrogate;

    public UTF8StreamWriter() {
        this._bytes = new byte[2048];
    }

    public UTF8StreamWriter(int n) {
        this._bytes = new byte[n];
    }

    public UTF8StreamWriter setOutput(OutputStream outputStream) {
        if (this._outputStream != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._outputStream = outputStream;
        return this;
    }

    public void write(char c) throws IOException {
        if (c < '\ud800' || c > '\udfff') {
            this.write((int)c);
        } else if (c < '\udc00') {
            this._highSurrogate = c;
        } else {
            int n = (this._highSurrogate - 55296 << 10) + (c - 56320) + 65536;
            this.write(n);
        }
    }

    public void write(int n) throws IOException {
        if ((n & 0xFFFFFF80) == 0) {
            this._bytes[this._index] = (byte)n;
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            this.write2(n);
        }
    }

    private void write2(int n) throws IOException {
        if ((n & 0xFFFFF800) == 0) {
            this._bytes[this._index] = (byte)(0xC0 | n >> 6);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xFFFF0000) == 0) {
            this._bytes[this._index] = (byte)(0xE0 | n >> 12);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xFF200000) == 0) {
            this._bytes[this._index] = (byte)(0xF0 | n >> 18);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & 0xF4000000) == 0) {
            this._bytes[this._index] = (byte)(0xF8 | n >> 24);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((n & Integer.MIN_VALUE) == 0) {
            this._bytes[this._index] = (byte)(0xFC | n >> 30);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 24 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | n & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            throw new CharConversionException("Illegal character U+" + Integer.toHexString(n));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c;
            if ((c = cArray[n4++]) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c;
            if ((c = string.charAt(n4++)) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    public void write(CharSequence charSequence) throws IOException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this._outputStream.flush();
    }

    public void close() throws IOException {
        if (this._outputStream != null) {
            this.flushBuffer();
            this._outputStream.close();
            this.reset();
        }
    }

    private void flushBuffer() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(this._bytes, 0, this._index);
        this._index = 0;
    }

    public void reset() {
        this._highSurrogate = '\u0000';
        this._index = 0;
        this._outputStream = null;
    }

    public UTF8StreamWriter setOutputStream(OutputStream outputStream) {
        return this.setOutput(outputStream);
    }
}

