/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util.detach;

import org.almworks.util.Log;
import org.almworks.util.RuntimeInterruptedException;
import org.almworks.util.detach.Detach$DetachNothing;

public abstract class Detach {
    public static final Detach NOTHING = new Detach$DetachNothing(null);
    private boolean myDetached;
    private Thread myDetachingThread;
    private Thread myRequestStacktraceThread;

    protected abstract void doDetach();

    public final void detach() {
        this.detachImpl();
    }

    public void preDetach() {
    }

    protected Object getLock() {
        return this;
    }

    protected void onException(Exception exception) {
        if (exception instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)exception);
        }
        Log.error(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetached() {
        Object object = this.getLock();
        synchronized (object) {
            return this.myDetached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetachStarted() {
        Object object = this.getLock();
        synchronized (object) {
            return this.myDetached || this.myDetachingThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachImpl() {
        Thread thread = Thread.currentThread();
        Object object = this.getLock();
        synchronized (object) {
            if (this.myDetached) {
                return;
            }
            if (this.myDetachingThread != null) {
                if (this.myDetachingThread == thread) {
                    Log.warn("recursive detach", new Throwable());
                } else {
                    Log.warn("concurrent detach --- (" + thread + ";" + this.myDetachingThread + ")", new Throwable());
                    this.myRequestStacktraceThread = this.myDetachingThread;
                }
                return;
            }
            this.myDetachingThread = thread;
        }
        try {
            try {
                this.preDetach();
            }
            catch (Exception exception) {
                this.onException(exception);
            }
            try {
                this.doDetach();
            }
            catch (Exception exception) {
                this.onException(exception);
            }
        }
        finally {
            object = this.getLock();
            synchronized (object) {
                assert (thread == this.myDetachingThread) : thread + " " + this.myDetachingThread;
                this.myDetachingThread = null;
                this.myDetached = true;
                if (this.myRequestStacktraceThread == thread) {
                    Log.warn("concurrent detach +++ (" + thread + ")", new Throwable());
                }
                this.myRequestStacktraceThread = null;
            }
        }
    }
}

