import { OTRCPDriver } from 'zigbee-on-host';
import { Backup } from '../../../models/backup';
import * as ZSpec from '../../../zspec';
import * as Zcl from '../../../zspec/zcl';
import * as Zdo from '../../../zspec/zdo';
import * as ZdoTypes from '../../../zspec/zdo/definition/tstypes';
import { Adapter } from '../../adapter';
import { ZclPayload } from '../../events';
import * as TsType from '../../tstype';
export declare class ZoHAdapter extends Adapter {
    private serialPort?;
    private socketPort?;
    /** True when adapter is currently closing */
    private closing;
    private interpanLock;
    readonly driver: OTRCPDriver;
    private readonly queue;
    private readonly zclWaitress;
    private readonly zdoWaitress;
    constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    /**
     * Init the serial or socket port and hook parser/writer.
     */
    initPort(): Promise<void>;
    /**
     * Handle port closing
     * @param err A boolean for Socket, an Error for serialport
     */
    private onPortClose;
    /**
     * Handle port error
     * @param error
     */
    private onPortError;
    closePort(): Promise<void>;
    start(): Promise<TsType.StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(ieeeAddressesInDatabase: string[]): Promise<Backup>;
    getNetworkParameters(): Promise<TsType.NetworkParameters>;
    addInstallCode(ieeeAddress: string, key: Buffer): Promise<void>;
    waitFor(networkAddress: number, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<ZclPayload>;
        cancel: () => void;
    };
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<ZclPayload | void>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: ZSpec.BroadcastAddress): Promise<void>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddress: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<ZclPayload>;
    restoreChannelInterPAN(): Promise<void>;
    private checkInterpanLock;
    /**
     * @param sender16 If undefined, sender64 is expected defined
     * @param sender64 If undefined, sender16 is expected defined
     * @param apsHeader
     * @param apsPayload
     */
    private onFrame;
    private onGPFrame;
    private onDeviceJoined;
    private onDeviceRejoined;
    private onDeviceLeft;
    private onDeviceAuthorized;
    private waitressTimeoutFormatter;
    private zclWaitressValidator;
    private zdoWaitressValidator;
}
//# sourceMappingURL=zohAdapter.d.ts.map