/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.plugins.PluginCreateRule;
import org.apache.commons.digester3.plugins.RuleLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginCreateRuleBuilder
extends AbstractBackToLinkedRuleBuilder<PluginCreateRule> {
    private final Map<String, String> pluginClassAttributes = new LinkedHashMap<String, String>();
    private final Map<String, String> pluginIdAttributes = new LinkedHashMap<String, String>();
    private Class<?> baseClass;
    private Class<?> dfltPluginClass;
    private RuleLoader dfltPluginRuleLoader;

    PluginCreateRuleBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
    }

    public <T> PluginCreateRuleBuilder ofType(Class<T> type) {
        if (type == null) {
            this.reportError("createPlugin().ofType( Class<?> )", "NULL Java type not allowed");
            return this;
        }
        this.baseClass = type;
        return this;
    }

    public <T> PluginCreateRuleBuilder usingDefaultPluginClass(Class<T> type) {
        this.dfltPluginClass = type;
        return this;
    }

    public <RL extends RuleLoader> PluginCreateRuleBuilder usingRuleLoader(RL ruleLoader) {
        this.dfltPluginRuleLoader = ruleLoader;
        return this;
    }

    public PluginCreateRuleBuilder setPluginClassAttribute(String attrName) {
        if (attrName == null) {
            this.reportError("createPlugin().setPluginClassAttribute( String )", "NULL attribute name not allowed");
            return this;
        }
        return this.setPluginClassAttribute(null, attrName);
    }

    public PluginCreateRuleBuilder setPluginClassAttribute(String namespaceUri, String attrName) {
        if (attrName == null) {
            this.reportError("createPlugin().setPluginClassAttribute( String, String )", "NULL attribute name not allowed");
            return this;
        }
        return this.addToMap(this.pluginClassAttributes, namespaceUri, attrName);
    }

    public PluginCreateRuleBuilder setPluginIdAttribute(String attrName) {
        if (attrName == null) {
            this.reportError("createPlugin().setPluginIdAttribute( String )", "NULL attribute name not allowed");
            return this;
        }
        return this.setPluginIdAttribute(null, attrName);
    }

    public PluginCreateRuleBuilder setPluginIdAttribute(String namespaceUri, String attrName) {
        if (attrName == null) {
            this.reportError("createPlugin().setPluginIdAttribute( String, String )", "NULL attribute name not allowed");
            return this;
        }
        return this.addToMap(this.pluginIdAttributes, namespaceUri, attrName);
    }

    private PluginCreateRuleBuilder addToMap(Map<String, String> map, String namespaceUri, String attrName) {
        map.put(namespaceUri, attrName);
        return this;
    }

    @Override
    protected PluginCreateRule createRule() {
        if (this.baseClass == null) {
            this.reportError("createPlugin()", "'baseClass' has to be specified");
        }
        PluginCreateRule rule = this.dfltPluginClass != null ? (this.dfltPluginRuleLoader != null ? new PluginCreateRule(this.baseClass, this.dfltPluginClass, this.dfltPluginRuleLoader) : new PluginCreateRule(this.baseClass, this.dfltPluginClass)) : new PluginCreateRule(this.baseClass);
        for (Map.Entry<String, String> entry : this.pluginClassAttributes.entrySet()) {
            rule.setPluginClassAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.pluginIdAttributes.entrySet()) {
            rule.setPluginIdAttribute(entry.getKey(), entry.getValue());
        }
        return rule;
    }
}

