/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.connectivity;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.TransportHandlerFactory;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectivityChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Connection connection;

    public ConnectivityChecker(Connection connection) {
        this.connection = connection;
    }

    public boolean isConnectable() {
        if (this.connection.getTransportHandlerType() == null) {
            this.connection.setTransportHandlerType(TransportHandlerType.TCP);
        }
        if (this.connection.getTimeout() == null) {
            this.connection.setTimeout(5000);
        }
        TransportHandler handler = TransportHandlerFactory.createTransportHandler(this.connection);
        try {
            handler.initialize();
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex);
            return false;
        }
        if (handler.isInitialized()) {
            try {
                handler.closeConnection();
            }
            catch (IOException ex) {
                LOGGER.debug((Object)ex);
            }
            return true;
        }
        return false;
    }

    public boolean speaksTls(Config config) {
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(config);
        WorkflowTrace trace = factory.createWorkflowTrace(WorkflowTraceType.HELLO, RunningModeType.CLIENT);
        trace.removeTlsAction(trace.getTlsActions().size() - 1);
        ReceiveTillAction receiveTillAction = new ReceiveTillAction((ProtocolMessage)new ServerHelloDoneMessage());
        trace.addTlsAction(receiveTillAction);
        State state = new State(config, trace);
        WorkflowExecutor executor = WorkflowExecutorFactory.createWorkflowExecutor(WorkflowExecutorType.DEFAULT, state);
        executor.executeWorkflow();
        if (receiveTillAction.getRecords().size() > 0) {
            if (receiveTillAction.getRecords().get(0) instanceof Record) {
                return true;
            }
            for (ProtocolMessage message : receiveTillAction.getReceivedMessages()) {
                if (!(message instanceof ServerHelloMessage) && !(message instanceof ServerHelloDoneMessage) && !(message instanceof SSL2ServerHelloMessage)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean speaksStartTls(Config config) {
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(config.getDefaultClientConnection());
        State state = new State(config, trace);
        WorkflowExecutor executor = WorkflowExecutorFactory.createWorkflowExecutor(WorkflowExecutorType.DEFAULT, state);
        executor.executeWorkflow();
        if (trace.allActionsExecuted()) {
            for (TlsAction action : trace.getTlsActions()) {
                AsciiAction asciiAction;
                if (!(action instanceof AsciiAction) && action instanceof SendAsciiAction || (asciiAction = (AsciiAction)action).getAsciiText() == null || !asciiAction.getAsciiText().toLowerCase().contains("TLS negotiation".toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

