/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FragmentStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private HashMap<Integer, Byte> fragmentByteMap = new HashMap();
    private int intendedSize;

    public FragmentStream(int intendedSize) {
        this.intendedSize = intendedSize;
    }

    public boolean canInsertByteArray(byte[] bytesToAdd, int offset) {
        for (int i = 0; i < bytesToAdd.length; ++i) {
            if (!this.fragmentByteMap.containsKey(offset + i) || this.fragmentByteMap.get(offset + i) == bytesToAdd[i]) continue;
            return false;
        }
        return true;
    }

    public void insertByteArray(byte[] bytesToAdd, int offset) {
        for (int i = 0; i < bytesToAdd.length; ++i) {
            if (this.fragmentByteMap.containsKey(offset + i)) {
                this.fragmentByteMap.remove(offset + i);
            }
            this.fragmentByteMap.put(offset + i, bytesToAdd[i]);
        }
    }

    public boolean isComplete(int tillIndex) {
        if (tillIndex < 0) {
            throw new IllegalArgumentException("Cannot check stream for completnes with negative index: " + tillIndex);
        }
        for (int i = 0; i < tillIndex; ++i) {
            if (this.fragmentByteMap.containsKey(i)) continue;
            return false;
        }
        return true;
    }

    public byte[] getCompleteFilledStream(byte fillingByte) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int fillingCounter = 0;
        for (int i = 0; i < this.intendedSize; ++i) {
            Byte b = this.fragmentByteMap.get(i);
            if (b == null) {
                b = fillingByte;
                ++fillingCounter;
            }
            stream.write(b.byteValue());
        }
        if (fillingCounter > 0) {
            LOGGER.warn("Had to fill " + fillingCounter + " missing bytes in HandshakeMessageFragments. This will _likely_ result in invalid messages");
        }
        for (Integer i : this.fragmentByteMap.keySet()) {
            if (i <= this.intendedSize) continue;
            LOGGER.warn("Found fragment greater than indended message size(intendet size: " + this.intendedSize + " but found byte for: " + i + "). Ignoring");
        }
        return stream.toByteArray();
    }

    public byte[] getCompleteTruncatedStream() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int skipCounter = 0;
        for (int i = 0; i < this.intendedSize; ++i) {
            Byte b = this.fragmentByteMap.get(i);
            if (b == null) {
                ++skipCounter;
                continue;
            }
            stream.write(b.byteValue());
        }
        if (skipCounter > 0) {
            LOGGER.warn("Did not receive all bytes. Truncated  " + skipCounter + " missing bytes.");
        }
        for (Integer i : this.fragmentByteMap.keySet()) {
            if (i <= this.intendedSize) continue;
            LOGGER.warn("Found fragment greater than indended message size(intendet size: " + this.intendedSize + " but found byte for: " + i + "). Ignoring");
        }
        return stream.toByteArray();
    }
}

