/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;

public class InterpreterPool {
    private static final String RHINO = "org.apache.batik.script.rhino.RhinoInterpreterFactory";
    private static final String JPYTHON = "org.apache.batik.script.jpython.JPythonInterpreterFactory";
    private static final String JACL = "org.apache.batik.script.jacl.JaclInterpreterFactory";
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);
    static /* synthetic */ Class class$org$apache$batik$script$InterpreterFactory;

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String string) {
        InterpreterFactory interpreterFactory = (InterpreterFactory)this.factories.get(string);
        Interpreter interpreter = null;
        if (interpreterFactory != null) {
            interpreter = interpreterFactory.createInterpreter(((SVGOMDocument)document).getURLObject());
        }
        if (document != null) {
            interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        }
        return interpreter;
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Iterator iterator = Service.providers(class$org$apache$batik$script$InterpreterFactory == null ? (class$org$apache$batik$script$InterpreterFactory = InterpreterPool.class$("org.apache.batik.script.InterpreterFactory")) : class$org$apache$batik$script$InterpreterFactory);
        while (iterator.hasNext()) {
            InterpreterFactory interpreterFactory = null;
            interpreterFactory = (InterpreterFactory)iterator.next();
            defaultFactories.put(interpreterFactory.getMimeType(), interpreterFactory);
        }
    }
}

