/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.exceptions.JBBPException;
import com.igormaznitsa.jbbp.exceptions.JBBPIllegalArgumentException;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.utils.DslBinCustom;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.jbbp.utils.ReflectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMappedClassFieldObserver {
    private static volatile Map<Class<?>, Field[]> cachedClasses;

    private static Object readFieldValue(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new JBBPException("Can't get value from field [" + field + ']', ex);
        }
    }

    private static void assertFieldArray(Field field) {
        if (!field.getType().isArray()) {
            throw new IllegalArgumentException("Detected non-array field marked to be written as an array [" + field + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processObject(Object obj, Field field, Object customFieldProcessor) {
        Map<Class<?>, Field[]> fieldz;
        JBBPUtils.assertNotNull(obj, "Object must not be null");
        Field[] orderedFields = null;
        if (cachedClasses == null) {
            fieldz = new HashMap();
            cachedClasses = fieldz;
        } else {
            fieldz = cachedClasses;
            Map<Class<?>, Field[]> map = cachedClasses;
            synchronized (map) {
                orderedFields = fieldz.get(obj.getClass());
            }
        }
        if (orderedFields == null) {
            int i;
            ArrayList listOfClassHierarchy = new ArrayList();
            ArrayList<OrderedField> fields = new ArrayList<OrderedField>();
            for (Class<?> current = obj.getClass(); current != Object.class; current = current.getSuperclass()) {
                listOfClassHierarchy.add(current);
            }
            for (i = listOfClassHierarchy.size() - 1; i >= 0; --i) {
                Class clazzToProcess = (Class)listOfClassHierarchy.get(i);
                Bin clazzAnno = clazzToProcess.getAnnotation(Bin.class);
                for (Field f : clazzToProcess.getDeclaredFields()) {
                    int modifiers = (f = ReflectUtils.makeAccessible(f)).getModifiers();
                    if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || f.getName().indexOf(36) >= 0) continue;
                    Bin fieldAnno = f.getAnnotation(Bin.class);
                    Bin bin = fieldAnno = fieldAnno == null ? clazzAnno : fieldAnno;
                    if (fieldAnno == null) continue;
                    fields.add(new OrderedField(fieldAnno.outOrder(), f));
                }
            }
            Collections.sort(fields);
            orderedFields = new Field[fields.size()];
            for (i = 0; i < fields.size(); ++i) {
                orderedFields[i] = ((OrderedField)fields.get((int)i)).field;
            }
            Map<Class<?>, Field[]> i2 = fieldz;
            synchronized (i2) {
                fieldz.put(obj.getClass(), orderedFields);
            }
        }
        field = ReflectUtils.makeAccessible(field);
        Bin clazzAnno = obj.getClass().getAnnotation(Bin.class);
        DslBinCustom clazzCustomAnno = obj.getClass().getAnnotation(DslBinCustom.class);
        Bin fieldAnno = field == null ? null : field.getAnnotation(Bin.class);
        DslBinCustom fieldCustomAnno = field == null ? null : field.getAnnotation(DslBinCustom.class);
        this.onStructStart(obj, field, clazzAnno == null ? fieldAnno : clazzAnno);
        for (Field f : orderedFields) {
            Bin binAnno = f.getAnnotation(Bin.class);
            if (binAnno == null && (binAnno = f.getDeclaringClass().getAnnotation(Bin.class)) == null) {
                throw new JBBPIllegalArgumentException("Can't find any Bin annotation to use for " + f + " field");
            }
            if (binAnno.custom() && customFieldProcessor == null) {
                throw new JBBPIllegalArgumentException("The Class '" + obj.getClass().getName() + "' contains the field '" + f.getName() + "' which is a custom one, you must provide a JBBPCustomFieldWriter instance to save the field.");
            }
            this.processObjectField(obj, f, binAnno, customFieldProcessor);
        }
        this.onStructEnd(obj, field, clazzAnno == null ? fieldAnno : clazzAnno);
    }

    protected void processObjectField(Object obj, Field field, Bin annotation, Object customFieldProcessor) {
        if (annotation.custom()) {
            this.onFieldCustom(obj, field, annotation, customFieldProcessor, AbstractMappedClassFieldObserver.readFieldValue(obj, field));
        } else {
            Class<?> fieldType = field.getType();
            BinType type = annotation.type() == BinType.UNDEFINED ? BinType.findCompatible(fieldType) : annotation.type();
            boolean reverseBits = annotation.bitOrder() == JBBPBitOrder.MSB0;
            block0 : switch (type) {
                case BIT: {
                    JBBPBitNumber bitNumber = annotation.outBitNumber();
                    if (fieldType == Boolean.TYPE) {
                        this.onFieldBits(obj, field, annotation, bitNumber, (Boolean)AbstractMappedClassFieldObserver.readFieldValue(obj, field) != false ? 255 : 0);
                        break;
                    }
                    byte value = ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).byteValue();
                    if (reverseBits) {
                        value = JBBPUtils.reverseBitsInByte(bitNumber, value);
                    }
                    this.onFieldBits(obj, field, annotation, bitNumber, value);
                    break;
                }
                case BOOL: {
                    if (fieldType == Boolean.TYPE) {
                        this.onFieldBool(obj, field, annotation, (Boolean)AbstractMappedClassFieldObserver.readFieldValue(obj, field));
                        break;
                    }
                    this.onFieldBool(obj, field, annotation, ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).longValue() != 0L);
                    break;
                }
                case BYTE: 
                case UBYTE: {
                    byte value = ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).byteValue();
                    if (reverseBits) {
                        value = JBBPUtils.reverseBitsInByte(value);
                    }
                    this.onFieldByte(obj, field, annotation, type == BinType.BYTE, value);
                    break;
                }
                case SHORT: 
                case USHORT: {
                    short value = fieldType == Character.TYPE ? (short)((Character)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).charValue() : ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).shortValue();
                    if (reverseBits) {
                        value = (short)JBBPFieldShort.reverseBits(value);
                    }
                    this.onFieldShort(obj, field, annotation, type == BinType.SHORT, value);
                    break;
                }
                case INT: {
                    int value = ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).intValue();
                    if (reverseBits) {
                        value = (int)JBBPFieldInt.reverseBits(value);
                    }
                    this.onFieldInt(obj, field, annotation, value);
                    break;
                }
                case FLOAT: {
                    float value = Float.TYPE == fieldType ? ((Float)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).floatValue() : ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).floatValue();
                    if (reverseBits) {
                        value = Float.intBitsToFloat((int)JBBPFieldInt.reverseBits(Float.floatToIntBits(value)));
                    }
                    this.onFieldFloat(obj, field, annotation, value);
                    break;
                }
                case STRING: {
                    String value;
                    Object valueAsObject = AbstractMappedClassFieldObserver.readFieldValue(obj, field);
                    if (valueAsObject != null) {
                        value = String.valueOf(valueAsObject);
                        if (reverseBits) {
                            value = JBBPFieldString.reverseBits(value);
                        }
                    } else {
                        value = null;
                    }
                    this.onFieldString(obj, field, annotation, value);
                    break;
                }
                case LONG: {
                    long value = ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).longValue();
                    if (reverseBits) {
                        value = JBBPFieldLong.reverseBits(value);
                    }
                    this.onFieldLong(obj, field, annotation, value);
                    break;
                }
                case DOUBLE: {
                    double value = Float.TYPE == fieldType ? (double)((Float)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).floatValue() : (Double.TYPE == fieldType ? ((Double)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).doubleValue() : ((Number)AbstractMappedClassFieldObserver.readFieldValue(obj, field)).doubleValue());
                    if (reverseBits) {
                        value = Double.longBitsToDouble(JBBPFieldLong.reverseBits(Double.doubleToLongBits(value)));
                    }
                    this.onFieldDouble(obj, field, annotation, value);
                    break;
                }
                case STRUCT: {
                    this.processObject(AbstractMappedClassFieldObserver.readFieldValue(obj, field), field, customFieldProcessor);
                    break;
                }
                default: {
                    Object array = AbstractMappedClassFieldObserver.readFieldValue(obj, field);
                    switch (type) {
                        case BIT_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            JBBPBitNumber bitNumber = annotation.outBitNumber();
                            if (fieldType.getComponentType() == Boolean.TYPE) {
                                for (int i = 0; i < len; ++i) {
                                    this.onFieldBits(obj, field, annotation, bitNumber, (Boolean)Array.get(array, i) != false ? 255 : 0);
                                }
                            } else {
                                for (int i = 0; i < len; ++i) {
                                    byte value = ((Number)Array.get(array, i)).byteValue();
                                    if (reverseBits) {
                                        value = JBBPUtils.reverseBitsInByte(bitNumber, value);
                                    }
                                    this.onFieldBits(obj, field, annotation, bitNumber, value);
                                }
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case BOOL_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                this.onFieldBool(obj, field, annotation, (Boolean)Array.get(array, i));
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case UBYTE_ARRAY: 
                        case BYTE_ARRAY: {
                            boolean signed;
                            boolean bl = signed = type == BinType.BYTE_ARRAY;
                            if (fieldType == String.class) {
                                String strValue = (String)AbstractMappedClassFieldObserver.readFieldValue(obj, field);
                                this.onArrayStart(obj, field, annotation, strValue.length());
                                for (int i = 0; i < strValue.length(); ++i) {
                                    byte value = (byte)strValue.charAt(i);
                                    if (reverseBits) {
                                        value = JBBPUtils.reverseBitsInByte(value);
                                    }
                                    this.onFieldByte(obj, field, annotation, signed, value);
                                }
                            } else {
                                AbstractMappedClassFieldObserver.assertFieldArray(field);
                                int len = Array.getLength(array);
                                this.onArrayStart(obj, field, annotation, len);
                                for (int i = 0; i < len; ++i) {
                                    byte value = ((Number)Array.get(array, i)).byteValue();
                                    if (reverseBits) {
                                        value = JBBPUtils.reverseBitsInByte(value);
                                    }
                                    this.onFieldByte(obj, field, annotation, signed, value);
                                }
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case SHORT_ARRAY: 
                        case USHORT_ARRAY: {
                            boolean signed;
                            boolean bl = signed = type == BinType.SHORT_ARRAY;
                            if (fieldType == String.class) {
                                String str = (String)AbstractMappedClassFieldObserver.readFieldValue(obj, field);
                                this.onArrayStart(obj, field, annotation, str.length());
                                for (int i = 0; i < str.length(); ++i) {
                                    short value = (short)str.charAt(i);
                                    if (reverseBits) {
                                        value = (short)JBBPFieldShort.reverseBits(value);
                                    }
                                    this.onFieldShort(obj, field, annotation, signed, value);
                                }
                                break block0;
                            }
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            if (fieldType.getComponentType() == Character.TYPE) {
                                for (int i = 0; i < len; ++i) {
                                    short value = (short)((Character)Array.get(array, i)).charValue();
                                    if (reverseBits) {
                                        value = (short)JBBPFieldShort.reverseBits(value);
                                    }
                                    this.onFieldShort(obj, field, annotation, signed, value);
                                }
                            } else {
                                for (int i = 0; i < len; ++i) {
                                    short value = ((Number)Array.get(array, i)).shortValue();
                                    if (reverseBits) {
                                        value = (short)JBBPFieldShort.reverseBits(value);
                                    }
                                    this.onFieldShort(obj, field, annotation, signed, value);
                                }
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case FLOAT_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                float value = Array.getFloat(array, i);
                                if (reverseBits) {
                                    value = Float.intBitsToFloat((int)JBBPFieldInt.reverseBits(Float.floatToIntBits(value)));
                                }
                                this.onFieldFloat(obj, field, annotation, value);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case INT_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                int value = ((Number)Array.get(array, i)).intValue();
                                if (reverseBits) {
                                    value = (int)JBBPFieldInt.reverseBits(value);
                                }
                                this.onFieldInt(obj, field, annotation, value);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case LONG_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                long value = ((Number)Array.get(array, i)).longValue();
                                if (reverseBits) {
                                    value = JBBPFieldLong.reverseBits(value);
                                }
                                this.onFieldLong(obj, field, annotation, value);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case STRING_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                String nullableStrValue;
                                Object value = Array.get(array, i);
                                String string = nullableStrValue = value == null ? null : String.valueOf(value);
                                if (nullableStrValue != null && reverseBits) {
                                    nullableStrValue = JBBPFieldString.reverseBits(nullableStrValue);
                                }
                                this.onFieldString(obj, field, annotation, nullableStrValue);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case DOUBLE_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                double value = ((Number)Array.get(array, i)).doubleValue();
                                if (reverseBits) {
                                    value = Double.longBitsToDouble(JBBPFieldLong.reverseBits(Double.doubleToLongBits(value)));
                                }
                                this.onFieldDouble(obj, field, annotation, value);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        case STRUCT_ARRAY: {
                            AbstractMappedClassFieldObserver.assertFieldArray(field);
                            int len = Array.getLength(array);
                            this.onArrayStart(obj, field, annotation, len);
                            for (int i = 0; i < len; ++i) {
                                this.processObject(Array.get(array, i), field, customFieldProcessor);
                            }
                            this.onArrayEnd(obj, field, annotation);
                            break block0;
                        }
                        default: {
                            throw new Error("Unexpected situation for field type, contact developer [" + (Object)((Object)type) + ']');
                        }
                    }
                }
            }
        }
    }

    protected void onFieldCustom(Object obj, Field field, Bin annotation, Object customFieldProcessor, Object value) {
    }

    protected void onFieldBits(Object obj, Field field, Bin annotation, JBBPBitNumber bitNumber, int value) {
    }

    protected void onFieldBool(Object obj, Field field, Bin annotation, boolean value) {
    }

    protected void onFieldByte(Object obj, Field field, Bin annotation, boolean signed, int value) {
    }

    protected void onFieldShort(Object obj, Field field, Bin annotation, boolean signed, int value) {
    }

    protected void onFieldInt(Object obj, Field field, Bin annotation, int value) {
    }

    protected void onFieldFloat(Object obj, Field field, Bin annotation, float value) {
    }

    protected void onFieldString(Object obj, Field field, Bin annotation, String value) {
    }

    protected void onFieldDouble(Object obj, Field field, Bin annotation, double value) {
    }

    protected void onFieldLong(Object obj, Field field, Bin annotation, long value) {
    }

    protected void onStructStart(Object obj, Field field, Bin annotation) {
    }

    protected void onStructEnd(Object obj, Field field, Bin annotation) {
    }

    protected void onArrayStart(Object obj, Field field, Bin annotation, int length) {
    }

    protected void onArrayEnd(Object obj, Field field, Bin annotation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInsideClassCache() {
        Map<Class<?>, Field[]> fieldz = cachedClasses;
        if (fieldz != null) {
            Map<Class<?>, Field[]> map = fieldz;
            synchronized (map) {
                fieldz.clear();
            }
        }
    }

    private static final class OrderedField
    implements Comparable<OrderedField> {
        final int order;
        final Field field;

        OrderedField(int order, Field field) {
            this.order = order;
            this.field = field;
        }

        public boolean equals(Object obj) {
            return obj != null && (obj == this || obj instanceof OrderedField && this.field.equals(((OrderedField)obj).field));
        }

        public int hashCode() {
            return this.order;
        }

        @Override
        public int compareTo(OrderedField o) {
            int result = this.order == o.order ? this.field.getName().compareTo(o.field.getName()) : (this.order < o.order ? -1 : 1);
            return result;
        }
    }
}

