/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.policy.AgePasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;

public class AgePasswordPolicyProviderFactory
implements PasswordPolicyProviderFactory {
    public static final Integer DEFAULT_AGE_DAYS = 30;

    public String getId() {
        return "passwordAge";
    }

    @Override
    public String getDisplayName() {
        return "Not Recently Used (In Days)";
    }

    @Override
    public String getConfigType() {
        return "int";
    }

    @Override
    public String getDefaultConfigValue() {
        return String.valueOf(DEFAULT_AGE_DAYS);
    }

    @Override
    public boolean isMultiplSupported() {
        return false;
    }

    public PasswordPolicyProvider create(KeycloakSession session) {
        return new AgePasswordPolicyProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

