/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.DefaultActionToken;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.StringUtil;

public class AuthenticatorUtil {
    private static final Logger logger = Logger.getLogger(AuthenticatorUtil.class);
    public static String CALLBACKS_FACTORY_IDS_NOTE = "callbacksFactoryProviderIds";

    public static boolean isSSOAuthentication(AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getAuthNote("SSO_AUTH"));
    }

    public static boolean isForcedReauthentication(AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getAuthNote("FORCED_REAUTHENTICATION"));
    }

    public static boolean isPasswordValidated(AuthenticationSessionModel authSession) {
        return "true".equals(authSession.getAuthNote("PASSWORD_VALIDATED"));
    }

    public static boolean isForkedFlow(AuthenticationSessionModel authSession) {
        return authSession.getAuthNote("forked.from") != null;
    }

    public static void setAuthCallbacksFactoryIds(AuthenticationSessionModel authSession, String authFactoryId) {
        if (authSession == null || StringUtil.isBlank((String)authFactoryId)) {
            return;
        }
        String callbacksFactories = authSession.getAuthNote(CALLBACKS_FACTORY_IDS_NOTE);
        if (StringUtil.isNotBlank((String)callbacksFactories)) {
            boolean containsProviderId;
            boolean bl = containsProviderId = callbacksFactories.equals(authFactoryId) || callbacksFactories.contains("##" + authFactoryId) || callbacksFactories.contains(authFactoryId + "##");
            if (!containsProviderId) {
                authSession.setAuthNote(CALLBACKS_FACTORY_IDS_NOTE, callbacksFactories + "##" + authFactoryId);
            }
        } else {
            authSession.setAuthNote(CALLBACKS_FACTORY_IDS_NOTE, authFactoryId);
        }
    }

    public static Set<String> getAuthCallbacksFactoryIds(AuthenticationSessionModel authSession) {
        if (authSession == null) {
            return Collections.emptySet();
        }
        String callbacksFactories = authSession.getAuthNote(CALLBACKS_FACTORY_IDS_NOTE);
        if (StringUtil.isNotBlank((String)callbacksFactories)) {
            String[] split = callbacksFactories.split("##");
            HashSet<String> set = new HashSet<String>(split.length);
            for (String s : split) {
                set.add(s);
            }
            return Collections.unmodifiableSet(set);
        }
        return Collections.emptySet();
    }

    public static List<AuthenticationExecutionModel> getExecutionsByType(RealmModel realm, String flowId, String providerId) {
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        realm.getAuthenticationExecutionsStream(flowId).forEach(authExecution -> {
            if (providerId.equals(authExecution.getAuthenticator())) {
                executions.add((AuthenticationExecutionModel)authExecution);
            } else if (authExecution.isAuthenticatorFlow() && authExecution.getFlowId() != null) {
                executions.addAll(AuthenticatorUtil.getExecutionsByType(realm, authExecution.getFlowId(), providerId));
            }
        });
        return executions;
    }

    public static AuthenticationFlowModel getTopParentFlow(RealmModel realm, AuthenticationExecutionModel executionModel) {
        if (executionModel.getParentFlow() != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(executionModel.getParentFlow());
            if (flow == null) {
                throw new IllegalStateException("Flow '" + executionModel.getParentFlow() + "' referenced from execution '" + executionModel.getId() + "' not found in realm " + realm.getName());
            }
            if (flow.isTopLevel()) {
                return flow;
            }
            AuthenticationExecutionModel execution = realm.getAuthenticationExecutionByFlowId(flow.getId());
            if (execution == null) {
                throw new IllegalStateException("Not found execution referenced by flow '" + flow.getId() + "' in realm " + realm.getName());
            }
            return AuthenticatorUtil.getTopParentFlow(realm, execution);
        }
        throw new IllegalStateException("Execution '" + executionModel.getId() + "' does not have parent flow in realm " + realm.getName());
    }

    public static void logoutOtherSessions(RequiredActionContext context) {
        EventBuilder event = context.getEvent().clone().detail("logout_triggered_by_required_action", context.getAction());
        AuthenticatorUtil.logoutOtherSessions(context.getSession(), context.getRealm(), context.getUser(), context.getAuthenticationSession(), context.getConnection(), context.getHttpRequest(), event);
    }

    public static void logoutOtherSessions(DefaultActionToken token, ActionTokenContext<? extends DefaultActionToken> context) {
        EventBuilder event = context.getEvent().clone().detail("logout_triggered_by_action_token", token.getActionId());
        AuthenticatorUtil.logoutOtherSessions(context.getSession(), context.getRealm(), context.getAuthenticationSession().getAuthenticatedUser(), context.getAuthenticationSession(), context.getClientConnection(), context.getRequest(), event);
    }

    private static void logoutOtherSessions(KeycloakSession session, RealmModel realm, UserModel user, AuthenticationSessionModel authSession, ClientConnection conn, HttpRequest req, EventBuilder event) {
        session.sessions().getUserSessionsStream(realm, user).filter(s -> !Objects.equals(s.getId(), authSession.getParentSession().getId())).collect(Collectors.toList()).forEach(s -> {
            AuthenticationManager.backchannelLogout(session, realm, s, (UriInfo)session.getContext().getUri(), conn, req.getHttpHeaders(), true);
            event.event(EventType.LOGOUT).session(s).user(s.getUser()).success();
        });
    }

    public static Stream<CredentialProvider> getCredentialProviders(KeycloakSession session) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports(CredentialProvider.class, (Object)f, CredentialProviderFactory.class)).map(f -> (CredentialProvider)session.getProvider(CredentialProvider.class, f.getId()));
    }
}

