/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.x500.cert.CertUtil;
import org.wildfly.security.x500.cert.PKCS10CertificateSigningRequest;
import org.wildfly.security.x500.cert.SubjectKeyIdentifierExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.cert._private.ElytronMessages;
import org.wildfly.security.x500.cert.util.KeyUtil;

public final class SelfSignedX509CertificateAndSigningKey {
    private final X509Certificate selfSignedcertificate;
    private final PrivateKey signingKey;

    private SelfSignedX509CertificateAndSigningKey(Builder builder) {
        this.selfSignedcertificate = builder.selfSignedCertificate;
        this.signingKey = builder.signingKey;
    }

    public X509Certificate getSelfSignedCertificate() {
        return this.selfSignedcertificate;
    }

    public PrivateKey getSigningKey() {
        return this.signingKey;
    }

    public PKCS10CertificateSigningRequest generatePKCS10CertificateSigningRequest() {
        return PKCS10CertificateSigningRequest.builder().setCertificate(this.selfSignedcertificate).setSigningKey(this.signingKey).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final String DEFAULT_KEY_ALGORITHM_NAME = "DSA";
        public static final int DEFAULT_EC_KEY_SIZE = 256;
        public static final int DEFAULT_KEY_SIZE = 2048;
        private static final int VERSION = 3;
        private final Map<String, X509CertificateExtension> extensionsByOid = new LinkedHashMap<String, X509CertificateExtension>();
        private String keyAlgorithmName;
        private String signatureAlgorithmName;
        private int keySize = -1;
        private X500Principal dn;
        private ZonedDateTime notValidBefore;
        private ZonedDateTime notValidAfter;
        private X509Certificate selfSignedCertificate;
        private PrivateKey signingKey;

        Builder() {
        }

        public Builder setKeyAlgorithmName(String keyAlgorithmName) {
            Assert.checkNotNullParam((String)"keyAlgorithmName", (Object)keyAlgorithmName);
            this.keyAlgorithmName = keyAlgorithmName;
            return this;
        }

        public Builder setKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public Builder setSignatureAlgorithmName(String signatureAlgorithmName) {
            Assert.checkNotNullParam((String)"signatureAlgorithmName", (Object)signatureAlgorithmName);
            this.signatureAlgorithmName = signatureAlgorithmName;
            return this;
        }

        public Builder setDn(X500Principal dn) {
            Assert.checkNotNullParam((String)"dn", (Object)dn);
            this.dn = dn;
            return this;
        }

        public Builder addExtension(X509CertificateExtension extension) throws IllegalArgumentException {
            Assert.checkNotNullParam((String)"extension", (Object)extension);
            String oid = extension.getId();
            Assert.checkNotNullParam((String)"extension.getOid()", (Object)oid);
            if (this.extensionsByOid.putIfAbsent(oid, extension) != null) {
                throw ElytronMessages.log.extensionAlreadyExists(oid);
            }
            return this;
        }

        public Builder addExtension(boolean critical, String extensionName, String extensionValue) throws IllegalArgumentException {
            Assert.checkNotNullParam((String)"name", (Object)extensionName);
            Assert.checkNotNullParam((String)"value", (Object)extensionValue);
            return this.addExtension(CertUtil.getX509CertificateExtension(critical, extensionName, extensionValue));
        }

        public X509CertificateExtension addOrReplaceExtension(X509CertificateExtension extension) {
            Assert.checkNotNullParam((String)"extension", (Object)extension);
            String oid = extension.getId();
            Assert.checkNotNullParam((String)"extension.getOid()", (Object)oid);
            return this.extensionsByOid.put(oid, extension);
        }

        public X509CertificateExtension addOrReplaceExtension(boolean critical, String extensionName, String extensionValue) {
            Assert.checkNotNullParam((String)"name", (Object)extensionName);
            return this.addOrReplaceExtension(CertUtil.getX509CertificateExtension(critical, extensionName, extensionValue));
        }

        public X509CertificateExtension removeExtension(String oid) {
            Assert.checkNotNullParam((String)"oid", (Object)oid);
            return this.extensionsByOid.remove(oid);
        }

        public Builder setNotValidBefore(ZonedDateTime notValidBefore) {
            Assert.checkNotNullParam((String)"notValidBefore", (Object)notValidBefore);
            this.notValidBefore = notValidBefore;
            return this;
        }

        public Builder setNotValidAfter(ZonedDateTime notValidAfter) {
            Assert.checkNotNullParam((String)"notValidAfter", (Object)notValidAfter);
            this.notValidAfter = notValidAfter;
            return this;
        }

        public SelfSignedX509CertificateAndSigningKey build() throws IllegalArgumentException {
            if (this.dn == null) {
                throw ElytronMessages.log.noDnGiven();
            }
            if (this.keyAlgorithmName == null) {
                this.keyAlgorithmName = DEFAULT_KEY_ALGORITHM_NAME;
            }
            if (this.keySize == -1) {
                this.keySize = this.keyAlgorithmName.equals("EC") ? 256 : 2048;
            }
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithmName);
                keyPairGenerator.initialize(this.keySize, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                this.signingKey = keyPair.getPrivate();
                if (this.signatureAlgorithmName == null) {
                    this.signatureAlgorithmName = KeyUtil.getDefaultCompatibleSignatureAlgorithmName((String)this.signingKey.getAlgorithm(), (int)this.keySize);
                    if (this.signatureAlgorithmName == null) {
                        throw ElytronMessages.log.unableToDetermineDefaultCompatibleSignatureAlgorithmName(this.signingKey.getAlgorithm());
                    }
                }
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(KeyUtil.getKeyIdentifier((PublicKey)keyPair.getPublic()));
                this.addExtension(subjectKeyIdentifierExtension);
                X509CertificateBuilder certificateBuilder = new X509CertificateBuilder();
                certificateBuilder.setIssuerDn(this.dn);
                certificateBuilder.setSubjectDn(this.dn);
                certificateBuilder.setPublicKey(keyPair.getPublic());
                certificateBuilder.setSigningKey(this.signingKey);
                certificateBuilder.setSignatureAlgorithmName(this.signatureAlgorithmName);
                certificateBuilder.setVersion(3);
                BigInteger serialNumber = new BigInteger(64, new SecureRandom());
                certificateBuilder.setSerialNumber(serialNumber);
                for (X509CertificateExtension extension : this.extensionsByOid.values()) {
                    certificateBuilder.addExtension(extension);
                }
                if (this.notValidBefore != null) {
                    certificateBuilder.setNotValidBefore(this.notValidBefore);
                }
                if (this.notValidAfter != null) {
                    certificateBuilder.setNotValidAfter(this.notValidAfter);
                }
                this.selfSignedCertificate = certificateBuilder.build();
                return new SelfSignedX509CertificateAndSigningKey(this);
            }
            catch (Exception e) {
                throw ElytronMessages.log.selfSignedCertificateGenerationFailed(e);
            }
        }
    }
}

