/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HttpContinue {
    private static final Set<String> COMPATIBLE_PROTOCOLS;
    public static final String CONTINUE = "100-continue";
    private static final AttachmentKey<Boolean> ALREADY_SENT;

    public static boolean requiresContinueResponse(HttpServerExchange exchange) {
        if (!COMPATIBLE_PROTOCOLS.contains(exchange.getProtocol()) || exchange.isResponseStarted() || exchange.getAttachment(ALREADY_SENT) != null) {
            return false;
        }
        return HttpContinue.requiresContinueResponse(exchange.getRequestHeaders("Expect"));
    }

    public static boolean requiresContinueResponse(List<String> expect) {
        if (expect != null) {
            for (String header : expect) {
                if (!header.equalsIgnoreCase(CONTINUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void rejectExchange(HttpServerExchange exchange) {
        exchange.setStatusCode(417);
        exchange.setPersistent(false);
        exchange.endExchange();
    }

    static {
        HashSet<String> compat = new HashSet<String>();
        compat.add("HTTP/1.1");
        compat.add("HTTP/2.0");
        COMPATIBLE_PROTOCOLS = Collections.unmodifiableSet(compat);
        ALREADY_SENT = AttachmentKey.create(Boolean.class);
    }
}

