/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.impl;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCodeWriter
implements ICodeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCodeWriter.class);
    private static final String[] INDENT_CACHE = new String[]{"", "    ", "        ", "            ", "                ", "                    "};
    protected StringBuilder buf = new StringBuilder();
    protected String indentStr = "";
    protected int indent = 0;
    private final boolean insertLineNumbers;

    public SimpleCodeWriter() {
        this.insertLineNumbers = false;
    }

    public SimpleCodeWriter(JadxArgs args) {
        this.insertLineNumbers = args.isInsertDebugLines();
        if (this.insertLineNumbers) {
            this.incIndent(3);
            this.add(this.indentStr);
        }
    }

    @Override
    public boolean isMetadataSupported() {
        return false;
    }

    @Override
    public SimpleCodeWriter startLine() {
        this.addLine();
        this.addLineIndent();
        return this;
    }

    @Override
    public SimpleCodeWriter startLine(char c) {
        this.startLine();
        this.add(c);
        return this;
    }

    @Override
    public SimpleCodeWriter startLine(String str) {
        this.startLine();
        this.add(str);
        return this;
    }

    @Override
    public SimpleCodeWriter startLineWithNum(int sourceLine) {
        if (sourceLine == 0) {
            this.startLine();
            return this;
        }
        if (this.insertLineNumbers) {
            this.newLine();
            this.attachSourceLine(sourceLine);
            int start = this.getLength();
            this.add("/* ").add(Integer.toString(sourceLine)).add(" */ ");
            int len = this.getLength() - start;
            if (this.indentStr.length() > len) {
                this.add(this.indentStr.substring(len));
            }
        } else {
            this.startLine();
            this.attachSourceLine(sourceLine);
        }
        return this;
    }

    @Override
    public SimpleCodeWriter addMultiLine(String str) {
        if (str.contains(NL)) {
            this.buf.append(str.replace(NL, NL + this.indentStr));
        } else {
            this.buf.append(str);
        }
        return this;
    }

    @Override
    public SimpleCodeWriter add(String str) {
        this.buf.append(str);
        return this;
    }

    @Override
    public SimpleCodeWriter add(char c) {
        this.buf.append(c);
        return this;
    }

    @Override
    public ICodeWriter add(ICodeWriter cw) {
        this.buf.append(cw.getCodeStr());
        return this;
    }

    @Override
    public SimpleCodeWriter newLine() {
        this.addLine();
        return this;
    }

    @Override
    public SimpleCodeWriter addIndent() {
        this.add("    ");
        return this;
    }

    protected void addLine() {
        this.buf.append(NL);
    }

    protected SimpleCodeWriter addLineIndent() {
        this.buf.append(this.indentStr);
        return this;
    }

    private void updateIndent() {
        int curIndent = this.indent;
        this.indentStr = curIndent < INDENT_CACHE.length ? INDENT_CACHE[curIndent] : Utils.strRepeat("    ", curIndent);
    }

    @Override
    public void incIndent() {
        this.incIndent(1);
    }

    @Override
    public void decIndent() {
        this.decIndent(1);
    }

    private void incIndent(int c) {
        this.indent += c;
        this.updateIndent();
    }

    private void decIndent(int c) {
        this.indent -= c;
        if (this.indent < 0) {
            LOG.warn("Indent < 0");
            this.indent = 0;
        }
        this.updateIndent();
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public void setIndent(int indent) {
        this.indent = indent;
        this.updateIndent();
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getLineStartPos() {
        return 0;
    }

    @Override
    public void attachDefinition(ICodeNodeRef obj) {
    }

    @Override
    public void attachAnnotation(ICodeAnnotation obj) {
    }

    @Override
    public void attachLineAnnotation(ICodeAnnotation obj) {
    }

    @Override
    public void attachSourceLine(int sourceLine) {
    }

    @Override
    public ICodeInfo finish() {
        this.removeFirstEmptyLine();
        String code = this.buf.toString();
        this.buf = null;
        return new SimpleCodeInfo(code);
    }

    protected void removeFirstEmptyLine() {
        int len = NL.length();
        if (this.buf.length() > len && this.buf.substring(0, len).equals(NL)) {
            this.buf.delete(0, len);
        }
    }

    @Override
    public int getLength() {
        return this.buf.length();
    }

    @Override
    public StringBuilder getRawBuf() {
        return this.buf;
    }

    @Override
    public Map<Integer, ICodeAnnotation> getRawAnnotations() {
        return Collections.emptyMap();
    }

    @Override
    public String getCodeStr() {
        this.removeFirstEmptyLine();
        return this.buf.toString();
    }

    public String toString() {
        return this.getCodeStr();
    }
}

